<?php
# $pagina = 7; # no es necesario definiar la pagina en modals o sql_cods
define('PERMITIDO', true);
require_once("../inc/init.php");

$filtroCodFonasa = $codFonasaExamenesNotNull ? " AND ex.COD_FONASA IS NOT NULL " : "";

if (isset($_POST["busqueda"])) {
	$busqueda = "%{$_POST['busqueda']}%";
	$qExamenes = $mysqli->prepare("SELECT ex.COD_INTERNO, ex.NOMBRE, ex.SINONIMOS
	FROM examenes ex
	WHERE (ex.NOMBRE LIKE ? OR ex.SINONIMOS LIKE ? OR ex.COD_INTERNO LIKE ?)
		AND ex.COD_INTERNO NOT IN (SELECT COD_EXAMEN FROM precios_examenes WHERE ID_EMPRESA = ?)
		AND ex.FLAG_ELIMINADO IS NULL
		$filtroCodFonasa
	ORDER BY ex.NOMBRE ASC
	LIMIT 30");
	echo $mysqli->error;
	$qExamenes->bind_param('sssi', $busqueda, $busqueda, $busqueda, $_POST["id_empresa"]);
	$qExamenes->execute();
	$qExamenes->bind_result($codExamen, $nombreExamen, $sinonimosExamen);

	$options = array();
	while ($qExamenes->fetch()) {
		$texto = $sinonimosExamen ? "$nombreExamen ($sinonimosExamen)" : $nombreExamen;
		$options[] = array('codExamen' => $codExamen, 'nombreExamen' => $texto);
	}
	$qExamenes->close();


	echo json_encode($options);
	return;
}
