<?php
$pantalla_actual = 'PRE_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$hora = time();
$hr = date("H:i:s", $hora);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idEmpresa = isset($_GET["idEmpresa"]) ? $_GET["idEmpresa"] : "-1";

$stmt_empresa = $mysqli->prepare("SELECT NOMBRE_E
FROM empresas
WHERE ID_EMPRESA = ?");
$stmt_empresa->bind_param("i", $idEmpresa);
$stmt_empresa->execute();
$resultado_empresa = $stmt_empresa->get_result();
$row_empresa = $resultado_empresa->fetch_assoc();

ob_start();
?>

<h2>Empresa: <?= $row_empresa["NOMBRE_E"] ?> </h2>

<form id="form_subir_archivo" class="smart-form" action="sql_cod.php" method="post" enctype="multipart/form-data">
  <div class="row">
    <section class="col col-3">
      <label class="label">Código a utilizar para actualización</label>
      <label class="select">
        <select id="flag_buscar_por_codigo_fonasa" class="input-sm" required>
          <option selected value="">--Seleccione--</option>
          <option value="interno">Código interno</option>
          <option value="fonasa">Código FONASA</option>
        </select> <i></i>
      </label>
    </section>
  </div>
  <div class="row">
    <section class="col col-3">
      <label class="label">Archivo de precios de exámenes</label>
      <div class="input input-file">
        <span class="button">
          <input type="file" id="file" name="archivo_csv" accept=".csv" required onchange="$('#nombre_archivo').val($(this).val().split('\\').pop());">Buscar
        </span>
        <input id="nombre_archivo" type="text" placeholder="Subir archivo CSV" readonly>
      </div>
    </section>
    <section class="col col-4">
      <label class="label">&nbsp;</label>
      <button type="submit" class="btn-sm btn-primary">Cargar precios</button>
    </section>
  </div>
</form>

<br>
<p class="font-md">Nota: Los precios anteriores de los exámenes incluidos en la planilla quedarán obsoletos y serán guardados en un historial.</p>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {

    $('#form_subir_archivo').submit(function(event) {
      event.preventDefault();
      var idEmpresa = <?= $idEmpresa ?>;

      if (!confirm("¿Desea cargar los precios desde el archivo CSV?")) return false;

      var formData = new FormData($(this)[0]);

      $.ajax({
        url: 'subirArchivoCsv.php',
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
          if (response.status) {
            // exito();
            // alert(response.message);
            var formDataCSV = new FormData();
            formDataCSV.append('ruta_destino_completa', response.ruta_destino_completa);
            formDataCSV.append('id_empresa', idEmpresa);
            formDataCSV.append('flag_buscar_por_codigo_fonasa', $('#flag_buscar_por_codigo_fonasa').val());
            $.ajax({
              url: 'insertarPreciosDesdeCsv.php',
              type: 'POST',
              data: formDataCSV,
              dataType: 'json',
              processData: false, // No proceses los datos (ya que ya están en el formato correcto)
              contentType: false, // No necesitas establecer el tipo de contenido, ya que FormData lo maneja automáticamente
              success: function(response) {
                // exito();
                // alert(response.message);
                window.location.href = 'historialArchivosCargados.php?idEmpresa=' + idEmpresa;
              },
              error: function(xhr, status, error) {
                alert("Error: " + error);
              }
            });
          }
        },
        error: function(xhr, status, error) {
          error("Error: " + error);
        },
        cache: false,
        contentType: false,
        processData: false
      });

      return false;
    });

  });
</script>

<?php
include("../inc/google-analytics.php");
?>