<?php
$pantalla_actual = 'PRE_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$hora = time();
$hr = date("H:i:s", $hora);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idEmpresa = isset($_GET["idEmpresa"]) ? $_GET["idEmpresa"] : "-1";
$idCarga = isset($_GET["idCarga"]) ? $_GET["idCarga"] : "-1";

$stmt_empresa = $mysqli->prepare("SELECT NOMBRE_E
FROM empresas
WHERE ID_EMPRESA = ?");
$stmt_empresa->bind_param("i", $idEmpresa);
$stmt_empresa->execute();
$resultado_empresa = $stmt_empresa->get_result();
$row_empresa = $resultado_empresa->fetch_assoc();

$stmt_cargaArchivo = $mysqli->prepare("SELECT cpe.NOMBRE_ARCHIVO, DATE_FORMAT(cpe.FECHA,'%d/%m/%Y') AS fechaCargaArchivo, cpe.HORA,
CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO) AS nombreUsuario
FROM cargas_precios_examenes cpe
LEFT JOIN usuarios u ON u.ID_USUARIO = cpe.ID_USUARIO
WHERE cpe.ID_CARGA_PRECIOS_EXAMENES = ?");
$stmt_cargaArchivo->bind_param("i", $idCarga);
$stmt_cargaArchivo->execute();
$resultado_cargaArchivo = $stmt_cargaArchivo->get_result();
$row_cargaArchivo = $resultado_cargaArchivo->fetch_assoc();

$stmt_preciosCarga = $mysqli->prepare("SELECT p.COD_EXAMEN, p.PRECIO, ex.NOMBRE, ex.COD_FONASA
FROM precios_examenes p
LEFT JOIN examenes ex ON ex.COD_INTERNO = p.COD_EXAMEN
WHERE p.ID_CARGA_PRECIOS_EXAMENES = ?
ORDER BY p.ID_PEX DESC");
$stmt_preciosCarga->bind_param("i", $idCarga);
$stmt_preciosCarga->execute();
$resultados_preciosCarga = $stmt_preciosCarga->get_result();

ob_start();
?>

<div class="font-md">
  <p>Empresa: <?= $row_empresa['NOMBRE_E'] ?></p>
  <p>Fecha / Hora de carga de archivo: <?= $row_cargaArchivo['fechaCargaArchivo'] ?> <?= $row_cargaArchivo['HORA'] ?></p>
  <p>Archivo cargado: <a href="../HISTORIAL_PRECIOS/<?= $row_cargaArchivo['NOMBRE_ARCHIVO'] ?>"><?= $row_cargaArchivo['NOMBRE_ARCHIVO'] ?></a></p>
</div>


<div class="table-responsive">
  <table class="table table-hover table-bordered" id="dataTable-detalleHistorial">
    <thead>
      <tr>
        <th>Código Interno</th>
        <th>Código FONASA</th>
        <th>Nombre</th>
        <th>Precio</th>
      </tr>
      <thead>
      <tbody>
        <?php while ($row_preciosCarga = $resultados_preciosCarga->fetch_assoc()) { ?>
          <tr>
            <td><?= $row_preciosCarga['COD_EXAMEN'] ?></td>
            <td><?= $row_preciosCarga['COD_FONASA'] ?></td>
            <td><?= $row_preciosCarga['NOMBRE'] ?></td>
            <td><?= number_format($row_preciosCarga['PRECIO'], 0, ',', '.') ?></td>
          </tr>
        <?php } ?>
      </tbody>
  </table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $('#dataTable-detalleHistorial').DataTable({
    'lengthMenu': [
      [50, 100, 200],
      [50, 100, 200]
    ],
    'language': {
      "sProcessing": "Procesando...",
      "sZeroRecords": "No se encontraron resultados",
      "sInfoPostFix": "",
      "sUrl": "",
      "oPaginate": {
        "sFirst": "Primero",
        "sPrevious": "Anterior",
        "sNext": "Siguiente",
        "sLast": "Último"
      },
      "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
      "sInfoEmpty": "0 Registros",
      "sInfoFiltered": "(de _MAX_ Registros en total)",
      "sLengthMenu": "Mostrar _MENU_ Registros",
      "sSearch": "Buscar: "
    },
    'pageLength': 50,
    'order': [],
    'columnDefs': [{
      "orderable": false,
      "targets": [3]
    }],
    'destroy': true
  });
</script>

<?php
include("../inc/google-analytics.php");
?>