<?php
$pantalla_actual = 'PRE_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$hora = time();
$hr = date("H:i:s", $hora);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idEmpresa = isset($_GET["idEmpresa"]) ? $_GET["idEmpresa"] : "-1";

$stmt_empresa = $mysqli->prepare("SELECT NOMBRE_E
FROM empresas
WHERE ID_EMPRESA = ?");
$stmt_empresa->bind_param("i", $idEmpresa);
$stmt_empresa->execute();
$resultado_empresa = $stmt_empresa->get_result();
$row_empresa = $resultado_empresa->fetch_assoc();

$stmt_cargaArchivos = $mysqli->prepare("SELECT cpe.ID_CARGA_PRECIOS_EXAMENES, cpe.NOMBRE_ARCHIVO, DATE_FORMAT(cpe.FECHA,'%d/%m/%Y') AS fechaCargaArchivo, cpe.HORA,
CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO) AS nombreUsuario
FROM cargas_precios_examenes cpe
LEFT JOIN usuarios u ON u.ID_USUARIO = cpe.ID_USUARIO
WHERE cpe.ID_EMPRESA = ?
ORDER BY cpe.ID_CARGA_PRECIOS_EXAMENES DESC");
$stmt_cargaArchivos->bind_param("i", $idEmpresa);
$stmt_cargaArchivos->execute();
$resultados_cargaArchivos = $stmt_cargaArchivos->get_result();

ob_start();
?>

<p class="font-md">
	Empresa: <?= $row_empresa['NOMBRE_E'] ?>
</p>

<div class="table-responsive">
	<table class="table table-hover table-bordered" id="dataTable-historial">
		<thead>
			<tr>
				<th>Fecha</th>
				<th>Hora</th>
				<th>Archivo</th>
				<th>Usuario responsable</th>
				<th>Detalle</th>
			</tr>
			<thead>
			<tbody>
				<?php while ($row = $resultados_cargaArchivos->fetch_assoc()) { ?>
					<tr>
						<td><?= $row['fechaCargaArchivo'] ?></td>
						<td><?= $row['HORA'] ? $row['HORA'] : "-" ?></td>
						<td><a href="../HISTORIAL_PRECIOS/<?= $row['NOMBRE_ARCHIVO'] ?>"><?= $row['NOMBRE_ARCHIVO'] ?></a></td>
						<td><?= $row['nombreUsuario'] ?></td>
						<td><a href="detalleHistorialArchivoCargado.php?idEmpresa=<?= $idEmpresa ?>&idCarga=<?= $row['ID_CARGA_PRECIOS_EXAMENES'] ?>"><i class="fa fa-eye fa-lg"></i></a></td>
					</tr>
				<?php } ?>
			</tbody>
	</table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$('#dataTable-historial').DataTable({
		'lengthMenu': [
			[50, 100, 200],
			[50, 100, 200]
		],
		'language': {
			"sProcessing": "Procesando...",
			"sZeroRecords": "No se encontraron resultados",
			"sInfoPostFix": "",
			"sUrl": "",
			"oPaginate": {
				"sFirst": "Primero",
				"sPrevious": "Anterior",
				"sNext": "Siguiente",
				"sLast": "Último"
			},
			"sInfo": "_START_ a _END_ de _TOTAL_ Registros",
			"sInfoEmpty": "0 Registros",
			"sInfoFiltered": "(de _MAX_ Registros en total)",
			"sLengthMenu": "Mostrar _MENU_ Registros",
			"sSearch": "Buscar: "
		},
		'pageLength': 50,
		'order': [],
		'columnDefs': [{
			"orderable": false,
			"targets": [4]
		}],
		'destroy': true
	});
</script>

<?php
include("../inc/google-analytics.php");
?>