<?
$pagina = 21;
define('PERMITIDO', true);
require_once("../inc/init.php");

function detectarSeparadorCSV($archivo)
{
    $separadores = array(',', ';', "\t"); // Lista de posibles separadores

    // Abrir el archivo y leer las primeras dos líneas
    if (($handle = fopen($archivo, "r")) !== false) {
        $primeraLinea = fgets($handle);
        $segundaLinea = fgets($handle);
        fclose($handle);

        // Buscar el primer separador en las dos primeras líneas
        foreach ($separadores as $separador) {
            if (strpos($primeraLinea, $separador) !== false && strpos($segundaLinea, $separador) !== false) {
                return $separador;
            }
        }

        return null; // Si no se encuentra ningún separador en común, devolver null

    } else {
        return false; // Manejo de errores si no se puede abrir el archivo
    }
}

$fechaHoraActual = date("Y-m-d H:i:s");
$fecha = date("Y-m-d");
$hora = date("H:i:s");
$idEmpresa = $_POST["id_empresa"];
$rutaArchivoCsv = $_POST["ruta_destino_completa"];
$nombreArchivoCsv = basename($rutaArchivoCsv);

$separadorDetectado = detectarSeparadorCSV($rutaArchivoCsv);
$contenidoArchivoCsv = array_map(function ($linea) use ($separadorDetectado) {
    return str_getcsv($linea, $separadorDetectado);
}, file($rutaArchivoCsv));

array_shift($contenidoArchivoCsv); // Eliminar la primera fila del contenido del archivo CSV

$sql_insert = "INSERT INTO cargas_precios_examenes (ID_EMPRESA, FECHA, HORA, ID_USUARIO, NOMBRE_ARCHIVO) VALUES (?, ?, ?, ?, ?)";
$stmt_cargaArchivo = $mysqli->prepare($sql_insert);
$stmt_cargaArchivo->bind_param("issis", $idEmpresa, $fecha, $hora, $usuario_id, $nombreArchivoCsv);
$stmt_cargaArchivo->execute();
$idCargaArchivoPreciosExamenes = $stmt_cargaArchivo->insert_id;
$stmt_cargaArchivo->close();

// $i = 0;
foreach ($contenidoArchivoCsv as $fila) {

    // if ($i == 5) break; # para testear un número limitado (5)

    $codigo = $fila[0];
    $precio = $fila[1];

    if ($codigo == "" || $precio == "" || $precio == 0) continue;

    // ECHO "Código: $codigo, Precio: $precio, idEmpresa: $idEmpresa, fechaHoraActual: $fechaHoraActual, idCarga: $idCargaArchivoPreciosExamenes<br>";

    if ($_POST["flag_buscar_por_codigo_fonasa"] == "fonasa") {
        $sql_select = "SELECT COD_INTERNO FROM examenes WHERE COD_FONASA = ?";
        $stmt = $mysqli->prepare($sql_select);
        $stmt->bind_param("s", $codigo);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $codInterno = $row['COD_INTERNO'];
                $sql_insert = "INSERT INTO precios_examenes (COD_EXAMEN, PRECIO, ID_EMPRESA, FECHA_INICIO, ID_CARGA_PRECIOS_EXAMENES) VALUES (?, ?, ?, ?, ?)";
                $stmt_insert = $mysqli->prepare($sql_insert);
                $stmt_insert->bind_param("siisi", $codInterno, $precio, $idEmpresa, $fechaHoraActual, $idCargaArchivoPreciosExamenes);
                $stmt_insert->execute();
                $stmt_insert->close();
            }
        }
        $stmt->close();
    }
    
    if ($_POST["flag_buscar_por_codigo_fonasa"] == "interno") {
        $sql_insert = "INSERT INTO precios_examenes (COD_EXAMEN, PRECIO, ID_EMPRESA, FECHA_INICIO, ID_CARGA_PRECIOS_EXAMENES) VALUES (?, ?, ?, ?, ?)";
        $stmt_insert = $mysqli->prepare($sql_insert);
        $stmt_insert->bind_param("siisi", $codigo, $precio, $idEmpresa, $fechaHoraActual, $idCargaArchivoPreciosExamenes);
        $stmt_insert->execute();
        $stmt_insert->close();
    }    

    // $i++;
}

echo json_encode(["status" => true, "message" => "exito"]);
exit(0);
