<?php
$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Ingresar precio para examen </h4>
</div>

<div class="modal-body">
  <form action="sql_cod.php" id="formAgregarNuevoPrecioExamen" name="formAgregarNuevoPrecioExamen" class="smart-form" method="post">
    <div class="row">
      <section class="col col-2">
        Examen:
      </section>
      <section class="col col-8">
        <label class="input"> <i class="icon-prepend fa fa-calendar"></i>
          <input id="selectExamen" name="cod_examen" style="width: -webkit-fill-available;">
        </label>
      </section>
    </div>
    <div class="row">
      <section class="col col-2">
        Precio:
      </section>
      <section class="col col-8">
        <label class="input"> <i class="icon-prepend fa fa-dollar"></i>
          <input type="number" class="input-sm" name="precio_examen" value="" />
        </label>
      </section>
    </div>
    <input type="hidden" name="formAgregarNuevoPrecioExamen" value="formAgregarNuevoPrecioExamen" />
    <input type="hidden" name="id_empresa" value="<?= $idEmpresa ?>" />
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
  <button class="btn btn-primary btn-agregarNuevoPrecioExamen pull-right" data-form="#formAgregarNuevoPrecioExamen">
    <i class="fa fa-save"></i> Grabar
  </button>
</div>

<script>
  $(document).ready(function() {
    $('#selectExamen').select2({
      placeholder: "Buscar examen",
      minimumInputLength: 1,
      formatInputTooShort: function() {
        return 'Ingrese uno o más caracteres';
      },
      formatSearching: "Buscando...",
      formatNoMatches: "No se encontraron resultados",
      ajax: {
        type: "POST",
        url: "ajax_examenes.php",
        dataType: 'json',
        quietMillis: 100,
        data: function(term, page) {
          return {
            busqueda: term,
            id_empresa: <?= $idEmpresa ?>
          };
        },
        results: function(data) {
          return {
            results: $.map(data, function(item) {
              return {
                id: item.codExamen,
                text: item.codExamen + " - " + item.nombreExamen,
              }
            })
          };
        },
        cache: true
      },
      escapeMarkup: function(m) {
        return m;
      } // we do not want to escape markup since we are displaying html in results
    });

    $(".btn-agregarNuevoPrecioExamen").on("click", function() {
      $(".btn-agregarNuevoPrecioExamen").attr('disabled', true);
      $.post('sql_cod.php', $('#formAgregarNuevoPrecioExamen').serialize(), function(data) {
        if (data.exito) {
          exito();
          // $("#md_ingresarPrecioExamen .close").click();
          location.reload();
        } else {
          error(data.mensaje);
          $(".btn-agregarNuevoPrecioExamen").attr('disabled', false);
        }
      }, 'json');
    });
  });
</script>