<?php
$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$codExamen = isset($_GET['codExamen']) ? $_GET['codExamen'] : "-1";
$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

$qEmpresas = $mysqli->prepare("SELECT pe.PRECIO, ex.NOMBRE
FROM precios_examenes pe
LEFT JOIN examenes ex ON ex.COD_INTERNO = pe.COD_EXAMEN
WHERE ex.COD_INTERNO = ? 
AND ID_EMPRESA = ?
AND pe.ID_PEX = (
  SELECT MAX(ID_PEX)
  FROM precios_examenes
  WHERE COD_EXAMEN = ex.COD_INTERNO
  AND ID_EMPRESA = ?
)");
$qEmpresas->bind_param("sii", $codExamen, $idEmpresa, $idEmpresa);
$qEmpresas->execute();
$qEmpresas->bind_result($precioExamen, $nombreExamen);
$qEmpresas->store_result();
$qEmpresas->fetch();
$qEmpresas->close();

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Agregar nuevo precio para examen </h4>
</div>

<div class="modal-body">
  <form action="sql_cod.php" id="formModificarPrecioExamen" name="formModificarPrecioExamen" class="smart-form" method="post">
    <div class="row">
      <section class="col col-2">
        Examen:
      </section>
      <section class="col col-8">
        <?= $nombreExamen ?>
      </section>
    </div>
    <div class="row">
      <section class="col col-2">
        Precio actual:
      </section>
      <section class="col col-8">
        $ <?= number_format($precioExamen, '0', ',', '.') ?>
      </section>
    </div>
    <div class="row">
      <section class="col col-2">
        Nuevo precio:
      </section>
      <section class="col col-8">
        <label class="input"> <i class="icon-prepend fa fa-dollar"></i>
          <input type="number" class="input-sm" name="precio_examen"/>
        </label>
      </section>
    </div>
    <input type="hidden" name="formModificarPrecioExamen" value="formModificarPrecioExamen" />
    <input type="hidden" name="cod_examen" value="<?= $codExamen ?>" />
    <input type="hidden" name="id_empresa" value="<?= $idEmpresa ?>" />
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
  <button class="btn btn-primary btn-modificarPrecioExamen pull-right" data-form="#formModificarPrecioExamen">
    <i class="fa fa-save"></i> Grabar
  </button>
</div>

<script>
  $(document).ready(function() {
    $(".btn-modificarPrecioExamen").on("click", function() {
      $(".btn-modificarPrecioExamen").attr('disabled', true);
      $.post('sql_cod.php', $('#formModificarPrecioExamen').serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error(data.mensaje);
          $(".btn-modificarPrecioExamen").attr('disabled', false);
        }
      }, 'json');
    });
  });
</script>