<?php
$pantalla_actual = 'PRE_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$hora = time();
$hr = date("H:i:s", $hora);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$empresas = $mysqli->query("SELECT e.ID_EMPRESA, CONCAT_WS('-', e.NRO_RUT_EMPRESA, e.DV_RUT_EMPRESA) AS rutEmpresa,
e.NOMBRE_E, e.NBR, DATE_FORMAT(cpe.FECHA,'%d/%m/%Y') AS fechaCargaArchivo, cpe.HORA
FROM empresas e
LEFT JOIN (
  SELECT cpe.ID_EMPRESA, MAX(cpe.FECHA) AS ultima_fecha
  FROM cargas_precios_examenes cpe
  GROUP BY cpe.ID_EMPRESA
) ultima_cpe ON ultima_cpe.ID_EMPRESA = e.ID_EMPRESA
LEFT JOIN cargas_precios_examenes cpe ON cpe.ID_EMPRESA = ultima_cpe.ID_EMPRESA AND cpe.FECHA = ultima_cpe.ultima_fecha
ORDER BY e.NOMBRE_E ASC");

ob_start();
?>

<div class="table-responsive">
  <table class="table table-hover table-bordered" id="dataTable-empresas">
    <thead>
      <tr>
        <th>RUT empresa</th>
        <th>Nombre empresa</th>
        <th>Abreviación</th>
        <th>Fecha/Hora última carga</th>
        <th>Ver detalle</th>
        <th>Historial cargas</th>
        <th></th>
      </tr>
      <thead>
      <tbody>
        <?php while ($row_empresas = $empresas->fetch_assoc()) { ?>
          <tr>
            <td><?= $row_empresas['rutEmpresa']; ?></td>
            <td><?= $row_empresas['NOMBRE_E']; ?></td>
            <td><?= $row_empresas['NBR']; ?></td>
            <td>
              <?= ($row_empresas['fechaCargaArchivo']) ? $row_empresas['fechaCargaArchivo'] : "Sin carga por archivo" ?>
              <?= ($row_empresas['HORA']) ? $row_empresas['HORA'] : "" ?>
            </td>
            <td class="text-center">
              <a href="preciosExamenesEmpresa.php?idEmpresa=<?= $row_empresas['ID_EMPRESA'] ?>" class="btn btn-link"><i class="glyphicon glyphicon-search"></i> </a>
            </td>
            <td class="text-center">
              <?php if ($row_empresas['fechaCargaArchivo']) { ?>
                <a href="historialArchivosCargados.php?idEmpresa=<?= $row_empresas['ID_EMPRESA'] ?>" class="btn btn-link">
                  <i class="fa fa-list fa-lg"></i>
                </a>
              <?php } else { ?>
                -
              <?php } ?>
            </td>
            <td class="text-center">
              <a href="cargarPreciosExamenesDesdeArchvoCsv.php?idEmpresa=<?= $row_empresas['ID_EMPRESA'] ?>" class="btn btn-primary">
                <i class="glyphicon glyphicon-cloud-upload"></i> Cargar archivo CSV
              </a>
            </td>
          </tr>
        <?php } ?>
      </tbody>
  </table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('#dataTable-empresas').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [],
      'columnDefs': [{
        "orderable": false,
        "targets": [3]
      }],
      'destroy': true
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>