<?php
$pagina = 21;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = "Historial";
$page_css[] = "your_style.css";
include("../inc/header.php");
$page_nav['especiales']['sub']['Carga_precios']["active"] = true;
include("../inc/nav.php");

ob_start();
?>

<table width="1000" border="0" align="center">
	<tr>
		<td align="center">
			<?php
			$directorio = "../HISTORIAL_PRECIOS/";
			$archivos = scandir($directorio);

			// Array para almacenar la fecha de modificación de cada archivo
			$fechas_modificacion = array();

			// Recorrer cada archivo
			foreach ($archivos as $archivo) {
				// Ignorar los archivos especiales . y ..
				if ($archivo != '.' && $archivo != '..') {
					// Obtener la fecha de modificación del archivo
					$fecha_modificacion = filemtime($directorio . $archivo);

					// Almacenar la fecha de modificación junto con el nombre del archivo
					$fechas_modificacion[$archivo] = $fecha_modificacion;
				}
			}

			// Ordenar el array de fechas de modificación en orden descendente (más reciente primero)
			asort($fechas_modificacion);

			// Recorrer los archivos en el orden de la fecha de modificación
			foreach ($fechas_modificacion as $archivo => $fecha_modificacion) {
				// Separar el nombre del archivo en partes usando el guion bajo como delimitador
				$datos = explode('_', $archivo);

				$nombre = $datos[0];
				$fecha = isset($datos[1]) ? str_replace('.csv', '', $datos[1]) : '';
				$hora = isset($datos[2]) ? str_replace(['.csv', '-'], ['', ':'], $datos[2]) : '';

				if (preg_match("/^(\d{2})-(\d{2})-(\d{4})$/", $fecha, $matches)) {
					// Si el formato es "dd-mm-yyyy", transformar a "yyyy-mm-dd"
					$fecha = date('Y-m-d', strtotime("$matches[3]-$matches[2]-$matches[1]"));
				}

				$stmt = $mysqli->prepare("SELECT ID_EMPRESA FROM empresas WHERE NOMBRE_E = ?");
				$stmt->bind_param(
					's',
					$nombre
				);
				$stmt->execute();
				$stmt->bind_result($id_empresa);
				$stmt->fetch();
				$stmt->close();

				// Aquí puedes hacer lo que necesites con los datos extraídos
				echo "Nombre: $nombre Id: $id_empresa, Fecha: $fecha, Hora: $hora, Usuario: $usuario_id, Archivo: $archivo<br>";

				// $stmt = $mysqli->prepare("INSERT INTO cargas_precios_examenes (ID_EMPRESA, FECHA, HORA, ID_USUARIO, NOMBRE_ARCHIVO)
				// VALUES (?, ?, ?, ?, ?)");
				// $stmt->bind_param(
				// 	'issis',
				// 	$id_empresa,
				// 	$fecha,
				// 	$hora,
				// 	$usuario_id,
				// 	$archivo
				// );
				$stmt->execute();
				$stmt->close();
			}
			?>
		</td>
	</tr>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => '<h2><strong>Carga de Precios por Previsión</strong><em> Historial</em></h2>',
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	$breadcrumbs["Carga de Precios por Previsión"] = "prevV2.php";
	include("../inc/ribbon.php");

	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<?php
include("../inc/google-analytics.php");
?>