<?php
$pantalla_actual = 'ATE_TRA';
define('PERMITIDO', true);
require_once '../inc/init.php';
require_once '../assets/tcpdf/tcpdf.php';

// $firma = 'QF Andoni Etcheverry<br>Director Técnico';

if (!isset($_GET['idht'])) die();

$sql_hoja_transporte = "SELECT ht.ID_HOJA_TRANSPORTE, ht.FECHA, cc.NOMBRE 
FROM hojas_transporte ht
JOIN centros_contacto cc ON ht.ID_LOCAL = cc.ID_CENTRO_CONTACTO
WHERE ht.ID_HOJA_TRANSPORTE = {$_GET['idht']}";
$resultado_hoja_transporte = $mysqli->query($sql_hoja_transporte);
$datos_hoja_transporte = $resultado_hoja_transporte->fetch_assoc();

class AtencionesHojaTransporte extends TCPDF {

	public function Header() {
		global $datos_hoja_transporte;

		$this->SetFont('helvetica', '', 8);
		$fecha = explode('-', $datos_hoja_transporte['FECHA']);
		$fecha = $fecha[2] . '-' . $fecha[1] . '-' . $fecha[0];
		$texto_hoja_transporte = "HOJA DE TRANSPORTE <strong>NRO:</strong> {$datos_hoja_transporte['ID_HOJA_TRANSPORTE']}  <strong>LOCAL:</strong> {$datos_hoja_transporte['NOMBRE']}  <strong>FECHA:</strong> {$fecha}";
		$this->writeHTMLCell(150, '', 10, 25, $texto_hoja_transporte);

		$this->setImageScale(1.53);
		$this->setJPEGQuality(100);
		$this->Image('../imagenes/new_logo_small.jpg', '10', '10');
	}

	public function Footer() {
		global $firma;
		/*$this->SetFont('helvetica', '', 8);
		$this->writeHTMLCell('50', '', 230, 180, $firma, 0, 1, 0, true, 'C', true);
		$paginas = 'Página ' . $this->getAliasNumPage(). ' de ' . $this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);*/
	}
}

$pdf = new AtencionesHojaTransporte('P', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 35, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 58);
$pdf->setFontSubsetting(true);
$pdf->SetFont('helvetica', '', 10);

# SI LA TABLA NO APARECE EN EL PDF, SE PUEDE DEBER A ALGÚN CARACTER IRRECONOCIBLE DE LA OBSERVACION DE ALGUNA ATENCIÓN
$resultado_atenciones = $mysqli->prepare("SELECT a.ID_ATENCION, pe.APELLIDO_PATERNO, pe.APELLIDO_MATERNO, pe.NOMBRES, pe.NRO_RUT, pe.DV_RUT, IFNULL(a.OBS, '-')
FROM atenciones a
INNER JOIN personas pe ON a.ID_CLIENTE = pe.ID_PERSONA
WHERE a.ID_HOJA_TRANSPORTE = ? AND a.FLAG_ELIMINADO = 0
ORDER BY a.ID_ATENCION ASC");
$resultado_atenciones->bind_param("i", $_GET['idht']);
$resultado_atenciones->execute();
$resultado_atenciones->bind_result($at_id, $at_apellido_paterno, $at_apellido_materno, $at_nombres, $at_nro_rut, $at_dv_rut, $at_obs);
$resultado_atenciones->store_result();

$pdf->AddPage();

$tbl =
	'<table border="1" cellpadding="2" style="text-align: left">
	<tbody>';

while ($resultado_atenciones->fetch()) {

	$tbl .= '
	<tr>
		<td>';

	$tbl .= "<b>$at_id</b>";
	$tbl .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>$at_nombres $at_apellido_paterno $at_apellido_materno</b>";
	$tbl .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>" . number_format($at_nro_rut, 0, ',', '.') . "- $at_dv_rut </b>";
	$tbl .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>OBS: </b>$at_obs";
	$tbl .= "<br>";

	$resultado_examenes_atencion = $mysqli->prepare("SELECT e.NOMBRE FROM examenes_atenciones ea
	INNER JOIN examenes e ON e.COD_INTERNO = ea.COD_EXAMEN
	WHERE ea.ID_ATENCION = {$at_id} AND ea.F_HIJO IS NULL
	ORDER BY e.NOMBRE");
	$resultado_examenes_atencion->execute();
	$resultado_examenes_atencion->bind_result($ex_nombre);
	$resultado_examenes_atencion->store_result();

	$ex_nombres = [];
	while ($resultado_examenes_atencion->fetch()) {
		$ex_nombres[] = $ex_nombre;
	}

	if (count($ex_nombres) > 0) {
		$tbl .= '<span style="font-size: 90%">' . implode($ex_nombres, '<strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong>') . '</span>';
	} else {
		$tbl .= 'Esta atención no tiene exámenes registrados.';
	}

	$tbl .= '
		</td>
	</tr>';
}

$tbl .= '
	</tbody>
</table>';

$pdf->SetFont('helvetica', '', 8);
$pdf->writeHTML($tbl, true, false, false, false, '');
ob_end_clean();
$pdf->Output('atenciones_hoja_transporte.pdf', 'I');
