<?php
$pantalla_actual = 'ATE_TRA';
define('PERMITIDO', true);
require_once "../inc/init.php";
require_once "../inc/config.ui.php";
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$style = '<style>.note { margin:0 !important; }</style>';
$page_css[] = "your_style.css";
include "../inc/header.php";
include "../inc/nav.php";
$hoy = date('Y-m-d');

if (isset($_GET['local']) && $_GET['local'] != '') {

	$f_nro = '';
	if (isset($_GET['busq']) && $_GET['busq'] != '') {
		$id = $_GET['busq'];
		$f_nro .= " AND (a.ID_ATENCION LIKE '%$id%' OR p.NOMBRES LIKE '%$id%' OR p.APELLIDO_PATERNO LIKE '%$id%' OR cto.NOMBRE LIKE '%$id%')";
	}

	if (isset($_GET['local']) && $_GET['local'] != '') {
		$f_local = ' AND a.ID_CENTRO_CONTACTO = ' . $_GET['local'];
	}

	$filtros = $f_nro . $f_local;

	$cant_reg = 100;
	$inicio = 0;
	$pagina = 1;
	if (isset($_GET['pag'])) {
		$pagina = $_GET['pag'];
		$inicio = ($pagina - 1) * $cant_reg;
	}
	/* Consulta para saber total de páginas */
	if (isset($_GET['tpag'])) {
		$total_paginas = $_GET['tpag'];
	} else {
		$consultaTotal = "SELECT a.ID_ATENCION
		FROM atenciones a
		LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
		LEFT JOIN centros_contacto cto ON a.ID_CENTRO_CONTACTO = cto.ID_CENTRO_CONTACTO
		WHERE a.FECHA BETWEEN ('$hoy' - INTERVAL 5 DAY) AND '$hoy' AND a.FLAG_ELIMINADO = 0 AND a.ID_CLIENTE != 61 $filtros
		GROUP BY a.ID_ATENCION";
		$qtotal = $mysqli->prepare($consultaTotal);
		$qtotal->execute();
		$qtotal->store_result();
		$totalRows_total = $qtotal->num_rows;
		$qtotal->close();
		$total_paginas = ceil($totalRows_total / $cant_reg);
	}

	$consulta = "SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, a.MONTO_ATENCION, a.MONTO_PAGADO,
	p.NOMBRES, p.APELLIDO_PATERNO, cto.NOMBRE, a.FLAG_RECHAZADO, a.ID_HOJA_TRANSPORTE
	FROM atenciones a
	LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
	LEFT JOIN centros_contacto cto ON a.ID_CENTRO_CONTACTO = cto.ID_CENTRO_CONTACTO
	WHERE a.FECHA BETWEEN ('$hoy' - INTERVAL 5 DAY) AND '$hoy' AND a.FLAG_ELIMINADO = 0 AND a.ID_CLIENTE != 61 $filtros
	GROUP BY a.ID_ATENCION
	ORDER BY a.ID_ATENCION DESC
	LIMIT ?, ?";
	$qatenciones = $mysqli->prepare($consulta);
	$qatenciones->bind_param('ii', $inicio, $cant_reg);
	$qatenciones->execute();
	$qatenciones->bind_result($at_id, $at_fecha, $at_montoAtencion, $at_montoPagado, $at_nombre, $at_apPaterno, $at_local, $at_flagRechazado, $at_idHojaTransporte);
	$qatenciones->store_result();
	$totalRows_atenciones = $qatenciones->num_rows;
}

$qlocales = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto");
$qlocales->execute();
$qlocales->bind_result($l_id, $l_nombre);

$optionsLocales = '<option value="">--Seleccione--</option>';

while ($qlocales->fetch()) {
	$selected = '';
	if (isset($_GET['local']) && $_GET['local'] == $l_id) {
		$selected = 'selected="selected"';
	}
	$optionsLocales .= '<option value="' . $l_id . '" ' . $selected . '>' . $l_nombre . '</option>';
}
$qlocales->close();

$optionsOtros = '<option value="">--Seleccione--</option>';
$selected = '';
if (isset($_GET['otros']) && $_GET['otros'] == 'pendientes') {
	$selected = 'selected="selected"';
}
$optionsOtros .= '<option value="pendientes" ' . $selected . '>Pendientes de Resultados</option>';
$selected = '';
if (isset($_GET['otros']) && $_GET['otros'] == 'rechazadas') {
	$selected = 'selected="selected"';
}
$optionsOtros .= '<option value="rechazadas" ' . $selected . '>Muestras Rechazadas</option>';

ob_start();
?>
<form action="" method="get" class="smart-form">
	<div class="row">
		<section>
			<div class="col col-3">
				<label class="select">
					<select name="local" id="local" required>
						<?= $optionsLocales; ?>
					</select>
					<i></i>
					<div class="note">Local</div>
				</label>
			</div>
			<div class="col col-1">
				<label class="input">
					<input name="busq" class="input-sm" type="text" value="<?php if (isset($_GET['busq'])) echo $_GET['busq']; ?>" />
					<div class="note">N° Atención</div>
				</label>
			</div>
			<div class="col col-1">
				<label class="input">
					<input type="submit" class="btn btn-success" value="Buscar" />
				</label>
			</div>
			<div class="col col-5">
				Se mostrarán las atenciones de los últimos 5 días
			</div>
		</section>
	</div>
</form>
<br>

<?php if ($qatenciones != null) { ?>
	<div class="row">
		<div class="col-md-6">
			<?php echo '<h4>Registros Encontrados: ' . $totalRows_total . '<small> Mostrando del ' . ($inicio + 1) . ' al ';
			if ($cant_reg * $pagina > $totalRows_total) {
				echo $totalRows_total;
			} else {
				echo $cant_reg * $pagina;
			}
			echo ' </small></h4>';
			?>
		</div>
		<div class="col-md-6">
			<div class="text-right">
				<?php if ($total_paginas > 1) {
					echo paginacion('atenciones_transporte.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina, 2, 2);
				}
				?>
			</div>
		</div>
	</div>

	<table class="table table-hover table-responsive">
		<thead>
			<tr bgcolor="#999999">
				<th>Nro Atención</th>
				<th>Fecha</th>
				<th>Local</th>
				<th>Paciente</th>
				<th class="smart-form">
					<label class="checkbox">
						<input type="checkbox" class="marcar_todos"><i></i>Transporte
					</label>
				</th>
			</tr>
		</thead>
		<tbody>
			<?php while ($qatenciones->fetch()) { ?>
				<tr>
					<td><?php echo $at_id; ?></td>
					<td><?php echo $at_fecha; ?></td>
					<td><?php echo $at_local; ?></td>
					<td><?php echo $at_nombre . ' ' . $at_apPaterno; ?></td>
					<td width="42" class="smart-form">
						<?php
						if ($at_idHojaTransporte == null) {
						?>
							<label class="checkbox">
								<input type="checkbox" class="checkbox_atencion" value="<?= $at_id; ?>"><i></i>
							</label>
						<?php
						} else {
						?>
							<a href="atenciones_hoja_transporte_pdf.php?idht=<?= $at_idHojaTransporte; ?>" target="_blank"><i class="fa fa-file-pdf-o"></i></a>
						<?php
						}
						?>
					</td>
				</tr>
			<?php }
			$qatenciones->close();
			?>
		</tbody>
	</table>

	<br />

	<div class="row">
		<div class="col-md-12">
			<button type="button" class="btn btn-danger btn-sm btn-CrearHojaTransporte pull-right"><i class="fa fa-truck fa-lg"></i> Crear Hoja de Transporte</button>
		</div>
	</div>

	<?php if ($total_paginas > 1) {
		echo '<div class="text-center" style="padding-top:1em;">' . paginacion('atenciones_transporte.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina) . '</div>';
	} ?>

<?php } else { ?>
	<div class="row">
		<div class="col-md-12 text-center">
			<h4>Ingrese un filtro.</h4>
		</div>
	</div>
<?php } ?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="hojas_transporte.php" class="btn btn-primary"><i class="fa fa-file"></i> Hojas de Transporte</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {
		$('.marcar_todos').on('change', function() {
			if (this.checked) {
				$('.checkbox_atencion').prop('checked', true);
			} else {
				$('.checkbox_atencion').prop('checked', false);
			}
		});

		$('.btn-CrearHojaTransporte').on('click', function() {
			var atenciones = $('.checkbox_atencion:checked');

			var ids = [];
			for (var i = 0; i < atenciones.length; i++) {
				ids.push($(atenciones[i]).val());
			}

			<?php
			if (isset($_GET['local'])) {
			?>
				$.post('sql_cod.php', {
					'CrearHojaTransporte': true,
					'id_local': <?= $_GET['local']; ?>,
					'atenciones': ids
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error('Error: ' + data.mensaje);
					}
				}, 'json');
			<?php
			}
			?>
		});
	})
</script>

<?php
include "../inc/google-analytics.php";
?>