<?php
$pantalla_actual = 'ATE_TRA';
define('PERMITIDO', true);
require_once "../inc/init.php";
require_once "../inc/config.ui.php";

$page_title = $datos_pantallas[$pantalla_actual]['page_title'];

$page_css[] = "your_style.css";
include "../inc/header.php";
include "../inc/nav.php";

$consulta = "SELECT ht.ID_HOJA_TRANSPORTE, DATE_FORMAT(ht.FECHA,'%d/%m/%Y'), ht.FLAG_RECEPCIONADO, cc.NOMBRE, IFNULL(ht.TEMP_R, '-')
FROM hojas_transporte ht
JOIN centros_contacto cc ON ht.ID_LOCAL = cc.ID_CENTRO_CONTACTO
WHERE ht.FECHA > '2021-01-01'
ORDER BY ht.ID_HOJA_TRANSPORTE DESC";
$qHojasTransporte = $mysqli->prepare($consulta);
$qHojasTransporte->execute();
$qHojasTransporte->bind_result($ht_id, $ht_fecha, $ht_flag_recepcionado, $ht_nombre_local, $ht_temp_r);
$qHojasTransporte->store_result();

mysql_select_db($database_conexionlab, $conexionlab);
$query_usuarios = "SELECT usuarios.ID_USUARIO, usuarios.USUARIO FROM usuarios WHERE usuarios.ACTIVO='S' AND usuarios.ID_USUARIO!=0 AND PERFIL not in ('', 'MEDICO','MEDICO_ASOCIADO','EXTERNO', 'CONVENIO', 'CONVENIO_MULTI_LOCAL', 'PACIENTE') ORDER BY USUARIO";
$usuarios = mysql_query($query_usuarios, $conexionlab) or die(mysql_error());

$options_usuarios = '<option value="">--Seleccione--</option>';
while ($row_usuarios = mysql_fetch_assoc($usuarios)) {
	$options_usuarios .= '<option value="' . $row_usuarios['ID_USUARIO'] . '">' . $row_usuarios['USUARIO'] . '</option>';
}

ob_start();
?>

<form action="#" class="smart-form" id="form-recepcionar" method="get">
	<fieldset style="padding-top:0;">
		<div class="row">
			<!-- <section>
				<div class="col col-3">
					<label class="select">
						<select name="id_usuario_responsable" id="id_usuario_responsable" required>
							<?=$options_usuarios;?>
						</select>
						<i></i>
						<div class="note">Responsable recepción (obligatorio)</div>
					</label>
				</div>
				<div class="col col-2">
					<label class="input">
						<input name="fecha_r" id="fecha_r" class="input-sm" type="date" value="<?=date('Y-m-d');?>" required />
						<div class="note">Fecha recepción (obligatoria)</div>
					</label>
				</div>
				<div class="col col-2">
					<label class="input">
						<input name="hora_r" id="hora_r" class="input-sm" type="time" value="<?=date('H:i:s');?>" required />
						<div class="note">Hora recepción (obligatoria)</div>
					</label>
				</div>
				<div class="col col-2">
					<label class="input">
						<input name="temp_r" id="temp_r" class="input-sm" type="number" required />
						<div class="note">Temperatura recepción °C (obligatoria)</div>
					</label>
				</div>
				<div class="col col-3">
					<label class="input">
						<input type="submit" class="btn btn-success" value="Recepcionar" />
					</label>
				</div>
			</section> -->
      <section>
				<div class="col col-2">
					<label class="input">
						<input name="temp_r" id="temp_r" class="input-sm" type="number" required />
						<div class="note">Temperatura recepción °C</div>
					</label>
				</div>
				<div class="col col-2">
					<button type="submit" class="btn btn-sm btn-success"> Recepcionar </button>
				</div>
			</section>
		</div>
	</fieldset>
</form>

<br>
<table class="table table-hover table-bordered" id="table_hojasTransporte">
  <thead>
    <tr>
      <th>N° Hoja</th>
      <th>Fecha Hoja</th>
      <th>Local</th>
      <th>PDF</th>
      <th>Códigos de Barra</th>
      <th>T° Recepción (°C)</th>
      <th class="text-center">
        Recepción <br/> <label class="checkbox"> <input type="checkbox" class="marcar_todos" style="width: auto !important"> </label>
      </th>
    </tr>
  </thead>
  <tbody>
  <?php while($qHojasTransporte->fetch()) { ?>
    <tr>
      <td><?=$ht_id?></td>
      <td><?=$ht_fecha?></td>
      <td><?=$ht_nombre_local?></td>
      <td><a href="atenciones_hoja_transporte_pdf.php?idht=<?=$ht_id?>" target="_blank"><i class="fa fa-lg fa-file-pdf-o"></i></a></td>
      <td><a href="cod_barras_hoja_transporte_pdf.php?idht=<?=$ht_id?>" target="_blank"><i class="fa fa-lg fa-barcode"></i></a></td>
      <td><?=$ht_temp_r?></td>
      <td>
        <?php	
        if ($ht_flag_recepcionado == 1) echo "<label class='label label-success'> Recepcionado <i class='fa fa-check'> </i> </label>";	
        else echo "<div class='smart-form'>
          <label class='checkbox'>
            <input type='checkbox' class='checkbox_hoja_transporte' value='$ht_id'><i></i>
          </label>
          </div>";
        ?>
      </td>
    </tr>
  <?php } $qHojasTransporte->close(); ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      'id' => 'toolbar-id',
      'content' => '<a href="atenciones_transporte.php" class="btn btn-primary"><i class="fa fa-truck"></i> Transporte de Atenciones</a>',
      'class' => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
<?php
include '../inc/ribbon.php';
?>

<!-- MAIN CONTENT -->
<div id="content">
<?php
$widget->print_html();
?>
</div>
<!-- END MAIN PANEL -->
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
// include page footer
include '../inc/footer.php';
?>
<!-- END PAGE FOOTER -->

<?php
include '../inc/scripts.php';
?>

<script>

$(document).ready(function() {

  $('#table_hojasTransporte').DataTable({
    'lengthMenu': [[5, 10, 20, 50, 100], [5, 10, 20, 50, 100]],
    'language': {
      "sProcessing":   "Procesando...",
      "sZeroRecords":  "No se encontraron resultados",
      "sInfoPostFix":  "",
      "sUrl":          "",
      "oPaginate": {
      "sFirst":    "Primero",
      "sPrevious": "Anterior",
      "sNext":     "Siguiente",
      "sLast":     "Último"
      },
      "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
      "sInfoEmpty":    "0 Registros",
      "sInfoFiltered": "(de _MAX_ Registros en total)",
      "sLengthMenu":"Mostrar _MENU_ Registros",
      "sSearch":"Buscar: "
    },
    'pageLength' : 20,
    'order' : [ 0, "desc" ],
    'columns': [
      null,
      null,
      null,
      {"orderable": false},
      {"orderable": false},
      {"orderable": false},
      {"orderable": false},
    ],
    'destroy': true
	});//DataTables

	$('.marcar_todos').on('change', function() {
		if (this.checked) $('.checkbox_hoja_transporte').prop('checked', true);
		else              $('.checkbox_hoja_transporte').prop('checked', false);
	});
	
	$('.btn-RecepcionarHojaTransporte').on('click', function() {
		var id = $(this).data('id_hoja_transporte');
		
		$.post('sql_cod.php', {'RecepcionarHojaTransporte': true, 'id_hoja_transporte': id}, function (data) {
			if (data.exito) {
				exito();
				location.reload();
			} else {
				error('Error: ' + data.mensaje);
			}
		}, 'json');
	});
	
	$('#form-recepcionar').on('submit', function() {		
		var data = {};
		
		data['RecepcionarHojaTransporte'] = true;
		
		data['id_usuario'] = $('#id_usuario_responsable').val();
		data['fecha_r'] = $('#fecha_r').val();
		data['hora_r'] = $('#hora_r').val();
		data['temp_r'] = $('#temp_r').val();
		
		var hojas_transporte = $('.checkbox_hoja_transporte:checked');
		
		var ids = [];
		for (var i = 0; i < hojas_transporte.length; i++) {
			ids.push($(hojas_transporte[i]).val());
		}
		
		data['ids_hoja_transporte'] = ids;
		
		$.post('sql_cod.php', data, function (data) {
			if (data.exito) {
				exito();
				location.reload();
			} else {
				error('Error: ' + data.mensaje);
			}
		}, 'json');
		
		return false;
	});
});
</script>

<?php
include '../inc/google-analytics.php';
?>
