<?php
$pantalla_actual = 'HOJ_TRA_GEN';
set_time_limit(300);
error_reporting(1);
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");


function obtenerOpcionesTipoEquipo($selectedValue = null)
{
  global $mysqli;
  $options = "<option value=''>--Seleccione--</option>";
  $query = $mysqli->prepare("SELECT e.ID_EQUIPO, e.MODELO
	FROM equipos e
  WHERE USO = 'PRIMARIO' AND CODIGO IN ('V3600', 'V5600')
  ORDER BY e.MODELO ASC");
  # $query->bind_param("i", $selectedValue);
  $query->execute();
  $query->bind_result($id, $modeloEquipo);
  $query->store_result();
  while ($query->fetch()) {
    $selected = ($id == $selectedValue) ? "selected" : "";
    $options .= "<option value='$id' $selected>$modeloEquipo</option>";
  }

  $query->close();
  return $options;
}

$idhoja = "-1";
if (isset($_GET['idhoja'])) $idhoja = $_GET['idhoja'];

$idEquipo = null;
if (isset($_GET['idEquipo'])) $idEquipo = $_GET['idEquipo'];

$optionsEquipos = obtenerOpcionesTipoEquipo($idEquipo);

$query = $mysqli->prepare("SELECT e.CODIGO
FROM equipos e
WHERE ID_EQUIPO = ?");
$query->bind_param("i", $idEquipo);
$query->execute();
$query->bind_result($codigoEquipo);
$query->store_result();
$query->fetch();
$query->close();

$qHoja = $mysqli->prepare("SELECT DATE_FORMAT(FECHA,'%d/%m/%Y'), HORA, AREA FROM hojas_trabajo WHERE ID_HOJA = ?");
$qHoja->bind_param('i', $idhoja);
$qHoja->execute();
$qHoja->bind_result($ht_fechaHoja, $ht_horaHoja, $ht_area);
$qHoja->store_result();
$qHoja->fetch();
$qHoja->close();

$query = $mysqli->prepare("SELECT ea.ID_EXATE, ea.ID_ATENCION,
a.OBS, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, 
p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO, m.APELLIDO_PATERNO AS MEDICO,
YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO) AS EDAD, (((YEAR(CURDATE())-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(CURDATE())-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
cg.DESCRIPCION_CG AS AREA, cg2.DESCRIPCION_CG AS NIVUR
FROM examenes_atenciones ea
LEFT JOIN atenciones a ON ea.ID_ATENCION = a.ID_ATENCION AND a.FLAG_ELIMINADO = 0
LEFT JOIN codigos_generales cg ON ea.NRO_HOJA_TRABAJO = cg.CODIGO AND cg.COD_TABLA = 'SIS_AREAS'
LEFT JOIN codigos_generales cg2 ON a.NIVEL_URGENCIA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_NIVURG'
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO = m.ID_PERSONA
WHERE ea.CORRELATIVO_HOJA_T = ?
GROUP BY ID_ATENCION
ORDER BY ID_ATENCION ASC");
$query->bind_param('i', $idhoja);
$query->execute();
$result = $query->get_result();
$totalRows_paciente = $result->num_rows;


ob_start();
?>

<form action="" method="get" class="smart-form">
  <div class="row">
    <section class="col col-3">
      Correlativo HT: <?= $idhoja ?>
      <br>
      Fecha: <?= $ht_fechaHoja ?> - <?= $ht_horaHoja ?>
      <br>
      Área: <?= $ht_area ?>
      <br>
      N° de Atenciones: <?= $totalRows_paciente ?>
    </section>
    <section class="col col-3">
      <select name="idEquipo" id="selectEquipo" class="form-control">
        <?= $optionsEquipos ?>
      </select>
    </section>
    <section class="col col-2">
      <div class="btn-group">
        <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search"> </i> Seleccionar </button>
        <!-- <a class="btn btn-sm btn-info" href="atenciones.php" style="margin-left: 5px">Ver todo</a> -->
      </div>
    </section>
  </div>
  <input type="hidden" name="idhoja" value="<?= $idhoja ?>">
</form>
<div class="row">
  <section class="col-md-9 text-center">
    <?php if ($idEquipo) { ?>
      <a id="enlaceArchivoPlano" class="btn btn-sm btn-default" href="gen_archivo_plano.php?idhoja=<?= $idhoja ?>&idEquipo=<?= $idEquipo ?>&codigoEquipo=<?= $codigoEquipo ?>"> <i class="fa fa-lg fa-file-text"> Archivo Plano</i> </a>
    <?php } else { ?>
      <button class="btn btn-sm btn-default" disabled> <i class="fa fa-lg fa-file-text"> Archivo Plano</i> </button>
    <?php } ?>
  </section>
</div>
<br>

<p <?php if ($totalRows_paciente > 0) echo "hidden" ?> class="font-md">No se encontraron atenciones con exámenes pendientes para esta hoja de trabajo</p>

<?php while ($paciente = $result->fetch_array(MYSQLI_ASSOC)) { ?>
  <div class="row">
    <div class="col col-md-9">
      <div class="well well-sm">
        <table>
          <tr>
            <td width="130">N° Atención: <?= $paciente['ID_ATENCION'] ?></td>
            <td width="350">Paciente: <?= $paciente['NOMBRES'] ?> <?= $paciente['APELLIDO_PATERNO'] ?> <?= $paciente['APELLIDO_MATERNO'] ?></td>
            <td width="120">Edad: <?= $paciente['EDAD_MES'] < "12" ? $paciente['EDAD_MES'] . " Meses" : $paciente['EDAD'] . " Años" ?></td>
            <td width="130">Fecha: <?= $paciente['FECHA'] ?></td>
            <td width="150">Dr(a): <?= $paciente['MEDICO'] ?> </td>
            <td>Urgencia: <?= $paciente['NIVUR'] ?></td>
          </tr>
          <tr>
            <?php if ($paciente['OBS'] != NULL) { ?> <td colspan="6">Obervación: <?= $paciente['OBS'] ?> </td> <?php } ?>
          </tr>
        </table>
        <br>
        <table class="table table-bordered table-hover table-responsive">
          <tr>
            <!-- <td width="50">N°</td> -->
            <th>Código LIMS</th=>
            <th>Examen</th>
            <th>Código tubo</th>
            <th>Nombre tubo</th>
            <th>Código en equipo</th>
            <th>Resultado</th>
          </tr>
          <?php
          $query = $mysqli->prepare("SELECT ea.ID_ATENCION, ea.COD_EXAMEN, ea.F_HIJO, ea.RESULTADO, ea.TIPO_TUBO, cg.DESCRIPCION_CG AS nombreTipoTubo, ex.NOMBRE, ex.FLAG_AGRUPACION, eq.COD_EXAMEN_EQUIPO
          FROM examenes_atenciones ea
          INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
          LEFT JOIN examenes_eq eq ON eq.COD_INTERNO = ea.COD_EXAMEN AND eq.ID_EQUIPO = ? 
          LEFT JOIN codigos_generales cg ON ea.TIPO_TUBO = cg.CODIGO AND cg.COD_TABLA = 'SIS_TIPTUB'
          WHERE ea.ID_ATENCION = ? AND ea.CORRELATIVO_HOJA_T = ?
          ORDER BY ID_ATENCION ASC, ID_EXATE ASC, FLAG_AGRUPACION DESC");
          $query->bind_param('iii', $idEquipo, $paciente['ID_ATENCION'], $idhoja);
          $query->execute();
          $result2 = $query->get_result();
          # $totalRows_examenes = $result2->num_rows;
          while ($examen = $result2->fetch_array(MYSQLI_ASSOC)) {
            if ($examen["FLAG_AGRUPACION"] == "N") {
          ?>
            <tr class="<?= ($examen['RESULTADO'] === NULL || $examen['RESULTADO'] == 'No Result') ? "" : "danger" ?>">
              <?php
              if ($examen['F_HIJO']) echo "<td align='center'> - {$examen['COD_EXAMEN']} </td>";
              else echo "<td> {$examen['COD_EXAMEN']} </td>";
              ?>
              <td><?= $examen['NOMBRE'] ?></td>
              <td><?= $examen['TIPO_TUBO'] ?> </td>
              <td><?= $examen['nombreTipoTubo'] ?> </td>
              <td>
                <?= $examen['COD_EXAMEN_EQUIPO'] ? $examen['COD_EXAMEN_EQUIPO'] : "-" ?>
              </td>
              <td><?= $examen['RESULTADO'] ?></td>
            </tr>
            <?php } elseif ($examen["FLAG_AGRUPACION"] == "S") { ?>
              <tr>
                <td> <?= $examen['COD_EXAMEN'] ?> </td>
                <td colspan="5"> <?= $examen['NOMBRE'] ?></td>
              </tr>
            <?php } 
          } ?>
        </table>
      </div>
    </div>
  </div>
  <br>
<?php } ?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a  href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>
<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <!-- MAIN CONTENT -->
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?= ASSETS_URL ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    // $('#idhoja').change(function() {
    // var area = $(this).find(':selected').data('area');
    // if (area == "QUIMICA SANGUÍNEA") $('.equipos').show(); 
    // else $('.equipos').hide(); 
    // });

    // $('#selectEquipo').change(function() {
    //   console.log("aaa");
    //   var idEquipoSeleccionado = $(this).val();
    //   $('#enlaceArchivoPlano').attr('href', 'gen_archivo_plano.php?idhoja=<?= $idhoja ?>&idEquipo=' + idEquipoSeleccionado);
    // });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>