<?php
$pantalla_actual = 'MOD_EMP';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : -1;

$qEmpresas = $mysqli->prepare("SELECT ID_EMPRESA, NRO_RUT_EMPRESA, DV_RUT_EMPRESA, NOMBRE_E, NBR, 
FLAG_LABORATORIO, FLAG_HOSPITAL, FLAG_CONVENIO, FLAG_IVA, FLAG_PREVISION, FLAG_PROVEEOR, FLAG_INACTIVO
FROM empresas WHERE ID_EMPRESA = ?");
$qEmpresas->bind_param("i", $idEmpresa);
$qEmpresas->execute();
$qEmpresas->bind_result(
  $id_empresa,
  $nroRutEmpresa,
  $dvRutEmpresa,
  $nombre_e,
  $nbr,
  $flag_laboratorio,
  $flag_hospital,
  $flag_convenio,
  $flag_iva,
  $flag_prevision,
  $flag_proveedor,
  $flag_inactivo
);
$qEmpresas->store_result();
$qEmpresas->fetch();
$qEmpresas->close();

ob_start();
?>

<table class="table table-hover table-bordered">
  <tr>
    <?php if ($flag_laboratorio == 'S') { ?>
      <td align="right">
        <a class="btn btn-success" href="l_centros.php?idem=<?= $idEmpresa ?>">
          <i class="fa fa-lg fa-home"></i> Centros de Toma de Muestras</a>
      </td>
    <?php } ?>
  </tr>
</table>

<form class="form-inline" id="formModificarEmpresa" action="sql_cod.php" method="post">
  <table class="table table-hover table-bordered">
    <tr>
      <td>Rut:</td>
      <td><input type="text" name="NRO_RUT_EMPRESA" value="<?= htmlentities($nroRutEmpresa, ENT_COMPAT, 'utf-8'); ?>" class="form-control" required="required" pattern="[0-9]{6,9}" />
        -
        <input type="text" name="DV_RUT_EMPRESA" value="<?= htmlentities($dvRutEmpresa, ENT_COMPAT, 'utf-8'); ?>" required="required" class="form-control" pattern="[0-9-k*K]" />
      </td>
    </tr>
    <tr>
      <td>Nombre o Razón Social:</td>
      <td><input type="text" class="form-control" name="NOMBRE_E" value="<?= htmlentities($nombre_e, ENT_COMPAT, 'utf-8'); ?>" /></td>
    </tr>
    <tr>
      <td>Abreviación:</td>
      <td>
        <input type="text" class="form-control" name="NBR" value="<?= $nbr ?>" maxlength="20" title="Máximo 20 caracteres" />
      </td>
    </tr>
    <tr>
      <td>Laboratorio:</td>
      <td>
        <select name="FLAG_LABORATORIO" class="form-control">
          <option value="N" <?php if (!(strcmp("N", htmlentities($flag_laboratorio, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($flag_laboratorio, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Hospital:</td>
      <td>
        <select name="FLAG_HOSPITAL" class="form-control">
          <option value="N" <?php if (!(strcmp("N", htmlentities($flag_hospital, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($flag_hospital, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Convenio:</td>
      <td>
        <select name="FLAG_CONVENIO" class="form-control">
          <option value="N" <?php if (!(strcmp("N", htmlentities($flag_convenio, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($flag_convenio, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>IVA incluido en atenciones:</td>
      <td>
        <select name="FLAG_IVA" class="form-control">
          <option value="N" <?php if (!(strcmp("N", htmlentities($flag_iva, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($flag_iva, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Previsión:</td>
      <td>
        <select class="form-control" name="FLAG_PREVISION">
          <option value="N" <?php if (!(strcmp("N", htmlentities($flag_prevision, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($flag_prevision, ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Proveedor</td>
      <td><select name="FLAG_PROVEEOR" class="form-control">
          <option value="N" <?php if (!(strcmp("N", $flag_proveeor))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", $flag_proveeor))) echo "selected" ?>>Si</option>
        </select></td>
    </tr>
    <tr>
      <td colspan="2" align="center"><a class="btn btn-sm btn-primary btn-modificarEmpresa"> <i class="fa fa-lg fa-save"></i> Grabar </a></td>
    </tr>
  </table>
  <input type="hidden" name="modificarEmpresa" value="modificarEmpresa" />
  <input type="hidden" name="ID_EMPRESA" value="<?= $idEmpresa ?>" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('.btn-modificarEmpresa').on('click', function(e) {
      var form = $("#formModificarEmpresa");
      $.post($(form).attr('action'), $(form).serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error(data.mensaje);
        }
      }, 'json');
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>