<?php
$pagina = 27;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = "Exámenes para Equipos";
$page_css[] = "your_style.css";
include("../inc/header.php");
$page_nav['Admin_Sistema']['sub']['ver_equipos']["active"] = true;
include("../inc/nav.php");
$breadcrumbs["Configuración"] = "";
$breadcrumbs["Equipos"] = "l_equipos.php";

$idEquipo = isset($_GET['ideq']) ? $_GET['ideq'] : "-1";

$stmt = $mysqli->prepare("SELECT * FROM equipos WHERE ID_EQUIPO = ?");
$stmt->bind_param("i", $idEquipo);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_equipos = $resultado->fetch_array(MYSQLI_ASSOC);

$stmt = $mysqli->prepare("SELECT exeq.ID_EXAMEN_EQUIPO, exeq.ID_EQUIPO, exeq.COD_INTERNO, exeq.COD_EXAMEN_EQUIPO, ex.NOMBRE, 
cg.DESCRIPCION_CG AS MUESTRA, cg2.DESCRIPCION_CG AS TUBO, cg3.DESCRIPCION_CG AS AREA
FROM examenes_eq exeq
LEFT JOIN examenes ex ON exeq.COD_INTERNO = ex.COD_INTERNO
LEFT JOIN codigos_generales cg ON exeq.COD_MUESTRA = cg.CODIGO AND cg.COD_TABLA = 'SIS_MUEEQU'
LEFT JOIN codigos_generales cg2 ON exeq.TIPO_TUBO = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPTUB'
LEFT JOIN codigos_generales cg3 ON ex.AREA_LAB = cg3.CODIGO AND cg3.COD_TABLA = 'SIS_AREAS'
WHERE ID_EQUIPO = ?
ORDER BY ex.NOMBRE");
$stmt->bind_param("i", $idEquipo);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_examenesEquipo = $resultado->fetch_all(MYSQLI_ASSOC);

$stmt = $mysqli->prepare("SELECT COD_INTERNO, NOMBRE 
FROM examenes 
WHERE (FLAG_AGRUPACION = 'N' OR (FLAG_HIJO = 'N' AND FLAG_AGRUPACION = 'N')) 
AND COD_INTERNO NOT IN (SELECT COD_INTERNO FROM examenes_eq WHERE ID_EQUIPO = ?)
AND FLAG_ELIMINADO IS NULL
ORDER BY NOMBRE ASC");
$stmt->bind_param("i", $idEquipo);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_examenes = $resultado->fetch_all(MYSQLI_ASSOC);
$options_examenes = "<option value=''>--Seleccione--</option>";
foreach ($datos_examenes as $data_examen) {
  $options_examenes .= "<option value='{$data_examen['COD_INTERNO']}'>{$data_examen['COD_INTERNO']} - {$data_examen['NOMBRE']}</option>";
}

$options_codigoMuestra = "<option value=''>-</option>";
$qCodigosMuestra = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_MUEEQU' AND ATRIBUTO1 = '{$datos_equipos['CODIGO']}' ORDER BY DESCRIPCION_CG");
$qCodigosMuestra->execute();
$qCodigosMuestra->bind_result($codigoMuestra, $descripcionMuestra);
$qCodigosMuestra->store_result();
while ($qCodigosMuestra->fetch()) {
  $options_codigoMuestra .= "<option value='$codigoMuestra'> $descripcionMuestra </option>";
}
$qCodigosMuestra->close();

$options_tipoTubo = optionsCodigosG("SIS_TIPTUB", null);

ob_start();
?>

<form id="formAgregarExamenEquipo" class="smart-form">
  <table class="table">
    <tr>
      <td width="30%">
        <label class="label">Examen</label>
        <select name="COD_INTERNO" class="select2" style="width:100%">
          <?= $options_examenes ?>
        </select>
      </td>
      <td width="20%">
        <label class="label">Tipo de tubo</label>
        <select name="TIPO_TUBO" class="select2" style="width:100%">
          <?= $options_tipoTubo ?>
        </select>
      </td>
      <td width="20%">
        <label class="label">Codigo exámen en equipo</label>
        <label class="input">
          <input type="text" name="COD_EXAMEN_EQUIPO" />
        </label>
      </td>
      <td width="20%">
        <label class="label">Código muestra</label>
        <select name="COD_MUESTRA" class="select2" style="width:100%">
          <?= $options_codigoMuestra ?>
        </select>
      </td>
      <td width="10%">
        <label class="label">&nbsp;</label>
        <a class="btn btn-sm btn-success btn-modificarTablaGeneral"> <i class="fa fa-lg fa-save"></i> Grabar</a>
      </td>
    </tr>
  </table>
  <input type="hidden" name="ID_EQUIPO" value="<?= $idEquipo ?>" />
  <input type="hidden" name="formAgregarExamenEquipo" value="formAgregarExamenEquipo" />
</form>

<br>
<table class="table table-bordered table-hover" id="dataTable-examenesEquipo">
  <thead>
    <tr>
      <th>Nombre examen</th>
      <th>Código interno examen</th>
      <th>Tipo de tubo</th>
      <th>Área</th>
      <th>Código examen en equipo</th>
      <th>Código muestra (opcional)</th>
      <th>Eliminar</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($datos_examenesEquipo as $data_examenEquipo) { ?>
      <tr>
        <td><?= $data_examenEquipo['NOMBRE'] ?></td>
        <td><?= $data_examenEquipo['COD_INTERNO'] ?></td>
        <td><?= $data_examenEquipo['TUBO'] ?></td>
        <td><?= $data_examenEquipo['AREA'] ?></td>
        <td><?= $data_examenEquipo['COD_EXAMEN_EQUIPO'] ?></td>
        <td><?= $data_examenEquipo['MUESTRA'] ?></td>
        <td align="center">
          <a type="submit" class="btn btn-link btn-eliminarExamenEquipo" data-id="<?= $data_examenEquipo['ID_EXAMEN_EQUIPO'] ?>" style="padding:0;">
            <i class="fa fa-lg fa-trash-o txt-color-red"></i>
          </a>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => '<h2><strong>Configuración de Exámenes para Equipos</strong><em></em></h2>',
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    var order = [0, "asc"];
    var columnasNoOrdenables = [6];
    inicializarDataTables('dataTable-examenesEquipo', order, columnasNoOrdenables);

    $('.btn-modificarTablaGeneral').on('click', function() {
      if (confirm("¿Desea modificar esta tabla general?")) {
        $.post("sql_cod.php", $("#formAgregarExamenEquipo").serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    $('.btn-eliminarExamenEquipo').on('click', function() {
      if (confirm("¿Desea eliminar este examen del equipo?")) {
        $.post("sql_cod.php", {
          eliminarExamenEquipo: 1,
          idExamenEquipo: $(this).data('id')
        }, function(data) {
          if (data.exito) {
            exito(data.mensaje);
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

  });
</script>

<?php
include("../inc/google-analytics.php");
?>