<?php
$pagina = 27; #modificar
define('PERMITIDO', true);
require_once("../inc/init.php");

$ideq = "-1";
if (isset($_GET['ideq'])) $ideq = $_GET['ideq'];

$qEquipo = $mysqli->prepare("SELECT CODIGO, FABRICANTE, MODELO, SERIE, TIPO, AREA, CONTACTO, FONO, RECEPCION, CONDICION, EN_MARCHA, UBICACION, OPERATIVO, USO, INST_FABRIC
FROM equipos WHERE ID_EQUIPO=?");
$qEquipo->bind_param('i', $ideq);
$qEquipo->execute();
$qEquipo->bind_result($e_codigo, $e_fabricante, $e_modelo, $e_serie, $e_tipo, $e_area, $e_contacto, $e_fono, $e_recepcion, $e_condicion, $e_enMarcha, $e_ubicacion, $e_operativo, $e_uso, $e_instFabric);
$qEquipo->fetch();
$qEquipo->close();

$e_enMarcha = date("d-m-Y", strtotime($e_enMarcha));

$optionsTipos = optionsCodigosG('SIS_TIPEQU', $e_tipo);
$optionsUbicaciones = optionsCodigosG('SIS_UBICA', $e_ubicacion);
$optionsAreas = optionsCodigosG('SIS_AREAS', $e_area);
?>


<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
        &times;
    </button>
    <h4 class="modal-title" id="myModalLabel">Modificar Equipo: <?= $e_fabricante ?> <?= $e_modelo ?></h4>
</div>

<div class="modal-body">
    <form id="formUpdateEquipo" class="smart-form">
        <fieldset style="padding-top:10px;">
            <div class="row">
                <section class="col col-4">
                    Código
                </section>
                <section class="col col-8">
                    <?= $e_codigo ?>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Fabricante
                </section>
                <section class="col col-8">
                    <label class="input">
                        <input class="input-sm" type="text" name="FABRICANTE" value="<?= $e_fabricante ?>">
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Modelo
                </section>
                <section class="col col-8">
                    <label class="input">
                        <input class="input-sm" type="text" name="MODELO" value="<?= $e_modelo ?>">
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Tipo
                </section>
                <section class="col col-8">
                    <label class="select">
                        <select name="TIPO">
                            <?= $optionsTipos ?>
                        </select>
                        <i></i>
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Área
                </section>
                <section class="col col-8">
                    <label class="select">
                        <select name="AREA">
                            <?= $optionsAreas ?>
                        </select>
                        <i></i>
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    N° serie
                </section>
                <section class="col col-8">
                    <label class="input">
                        <input class="input-sm" type="text" name="SERIE" value="<?= $e_serie ?>">
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Operativo
                </section>
                <section class="col col-8">
                    <label class="select">
                        <select name="OPERATIVO">
                            <option value="S" <?= ($e_operativo == 'S') ? 'selected="selected"' : ""; ?>>Si</option>
                            <option value="N" <?= ($e_operativo == 'N') ? 'selected="selected"' : ""; ?>>No</option>
                        </select>
                        <i></i>
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Uso
                </section>
                <section class="col col-8">
                    <label class="select">
                        <select name="USO">
                            <option value="PRIMARIO" <?= ($e_uso == 'PRIMARIO') ? 'selected="selected"' : ""; ?>>Primario</option>
                            <option value="SECUNDARIO" <?= ($e_uso == 'SECUNDARIO') ? 'selected="selected"' : ""; ?>>Secundario</option>
                        </select>
                        <i></i>
                    </label>
                </section>
            </div>
        </fieldset>
        <fieldset>
            <div class="row">
                <section class="col col-4">
                    Contacto
                </section>
                <section class="col col-8">
                    <label class="input">
                        <input class="input-sm" type="text" name="CONTACTO" value="<?= $e_contacto ?>">
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Teléfono Contacto
                </section>
                <section class="col col-8">
                    <label class="input">
                        <input class="input-sm" type="text" name="FONO" value="<?= $e_fono ?>">
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Condición
                </section>
                <section class="col col-8">
                    <label class="input">
                        <input class="input-sm" type="text" name="CONDICION" value="<?= $e_condicion ?>">
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Fecha de Puesta en Marcha
                </section>
                <section class="col col-8">
                    <label class="input">
                        <div class="input-group">
                            <input class="input-sm" name="EN_MARCHA" id="EN_MARCHA" data-mask="99-99-9999" placeholder="Fecha" data-dateformat="dd-mm-yyyy" value="<?= $e_enMarcha ?>" required="required" />
                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                        </div>
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Ubicación
                </section>
                <section class="col col-8">
                    <label class="select">
                        <select name="UBICACION">
                            <?= $optionsUbicaciones ?>
                        </select>
                        <i></i>
                    </label>
                </section>
            </div>
            <div class="row">
                <section class="col col-4">
                    Instrucciones del Fabricante
                </section>
                <section class="col col-8">
                    <label class="textarea textarea-resizable">
                        <textarea rows="3" class="custom-scroll" name="INST_FABRIC"><?= $e_instFabric ?></textarea>
                    </label>
                </section>
            </div>
            <input type="hidden" name="formUpdateEquipo" value="formUpdateEquipo" />
            <input type="hidden" name="ID_EQUIPO" value="<?= $ideq ?>" />
        </fieldset>
        <footer>
            <button type="submit" class="btn btn-primary btn-sm pull-right">
                <i class="fa fa-save"></i> Grabar
            </button>
        </footer>
    </form>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">
        Cerrar
    </button>
</div>


<script>
    $(document).ready(function(e) {
        $(function() {
            $("#EN_MARCHA").datepicker();
        })

        $("#formUpdateEquipo").validate({
            rules: {
                FABRICANTE: {
                    required: true
                },
                MODELO: {
                    required: true
                },
                SERIE: {
                    required: true
                },
                TIPO: {
                    required: true
                },
                AREA: {
                    required: true
                },
                CONTACTO: {
                    required: false
                },
                FONO: {
                    required: false
                },
                CONDICION: {
                    required: false
                },
                EN_MARCHA: {
                    required: true
                },
                UBICACION: {
                    required: true
                },
                OPERATIVO: {
                    required: true
                },
                USO: {
                    required: true
                },
                INST_FABRIC: {
                    required: false
                }
            },
            messages: {
                FABRICANTE: {
                    required: 'Ingrese Fabricante'
                },
                MODELO: {
                    required: 'Ingrese Modelo'
                },
                SERIE: {
                    required: 'Ingrese Nro Serie'
                },
                TIPO: {
                    required: 'Seleccione Tipo'
                },
                AREA: {
                    required: 'Seleccione Área'
                },
                CONTACTO: {
                    required: 'Ingrese Nombre Contacto'
                },
                FONO: {
                    required: 'Ingrese Fono Contacto'
                },
                CONDICION: {
                    required: 'Ingrese Condición'
                },
                EN_MARCHA: {
                    required: 'Ingrese Fecha de Puesta en marcha'
                },
                UBICACION: {
                    required: 'Seleccione Ubicación'
                },
                OPERATIVO: {
                    required: 'Seleccione si esta Opetativo'
                },
                USO: {
                    required: 'Seleccione Uso'
                },
                INST_FABRIC: {
                    required: 'Ingrese Instrucciones del Fabricante'
                }
            },
            onfocusout: false,
            onsubmit: true,
            // Do not change code below
            errorPlacement: function(error, element) {
                error.insertAfter(element.parent());
            }
        });

        $('#formUpdateEquipo').on('submit', function(e) {
            var form = $();
            if (form.valid()) {
                $.post("sql_cod.php", $("#formUpdateEquipo").serialize(), function(data) {
                    if (data.exito) {
                        exito();
                        location.reload();
                    } else {
                        error(data.mensaje);
                    }
                }, 'json');
            }
            e.preventDefault();
            return false;
        });

    });
</script>