<?php
$pagina = 27;
define('PERMITIDO', true);
require_once("../inc/init.php");

if (isset($_POST["formAgregarExamenEquipo"]) && $_POST["formAgregarExamenEquipo"] != "") {
	$query = $mysqli->prepare("INSERT INTO examenes_eq (ID_EQUIPO, COD_INTERNO, COD_MUESTRA, TIPO_TUBO, COD_EXAMEN_EQUIPO) VALUES (?, ?, ?, ?, ?)");
	$query->bind_param(
		'isiis',
		$_POST['ID_EQUIPO'],
		$_POST['COD_INTERNO'],
		$_POST['COD_MUESTRA'],
		$_POST['TIPO_TUBO'],
		$_POST['COD_EXAMEN_EQUIPO'],
	);
	$query->execute();
	$query->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}

if (isset($_POST['eliminarExamenEquipo']) && $_POST['eliminarExamenEquipo'] != "") {
	$query = $mysqli->prepare("DELETE FROM examenes_eq WHERE ID_EXAMEN_EQUIPO = ? LIMIT 1");
	$query->bind_param('i', $_POST['idExamenEquipo']);
	$query->execute();
	$query->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}

if (isset($_POST['formUpdateEquipo']) && $_POST["formUpdateEquipo"] != "") {
	$fechaEnMarcha = implode('-', array_reverse(explode('-', $_POST['EN_MARCHA'])));

	$query = $mysqli->prepare("UPDATE equipos SET FABRICANTE = ?, MODELO = ?, TIPO = ?, AREA = ?, SERIE = ?, CONTACTO = ?, FONO = ?, RECEPCION = ?, CONDICION = ?,
	EN_MARCHA = ?, UBICACION = ?, OPERATIVO = ?, USO = ?, INST_FABRIC = ? 
	WHERE ID_EQUIPO = ?");
	$query->bind_param(
		'ssiissssssisssi',
		$_POST['FABRICANTE'],
		$_POST['MODELO'],
		$_POST['TIPO'],
		$_POST['AREA'],
		$_POST['SERIE'],
		$_POST['CONTACTO'],
		$_POST['FONO'],
		$_POST['RECEPCION'],
		$_POST['CONDICION'],
		$fechaEnMarcha,
		$_POST['UBICACION'],
		$_POST['OPERATIVO'],
		$_POST['USO'],
		$_POST['INST_FABRIC'],
		$_POST['ID_EQUIPO']
	);
	$query->execute();
	$query->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}

if (isset($_POST['bajaEquipo']) && $_POST["bajaEquipo"] != "") {
	$query = $mysqli->prepare("UPDATE equipos SET BAJA = 'S', FECHA_BAJA = CURDATE() WHERE ID_EQUIPO = ?");
	$query->bind_param('i', $_POST['ideq']);
	$query->execute();
	$query->close();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}