<?php
define('PERMITIDO', true);
$pantalla_actual = 'LIS_EXA';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$stmt = $mysqli->prepare("SELECT e.COD_INTERNO, e.NOMBRE, e.NOMBRE_INF, e.COD_FONASA, e.TIPO_TUBO, e.AREA_LAB, e.UNIDAD_MEDIDA, e.FLAG_ULTIMA_REGLA, e.COSTO_INTERNO,
e.FLAG_AGRUPACION, e.FLAG_HIJO, cg.DESCRIPCION_CG AS TIPTUB, cg2.DESCRIPCION_CG AS TIPMUE, e.FLAG_ELIMINADO
FROM examenes e
LEFT JOIN codigos_generales cg ON e.TIPO_TUBO = cg.CODIGO AND cg.COD_TABLA = 'SIS_TIPTUB'
LEFT JOIN codigos_generales cg2 ON e.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE' 
# WHERE e.FLAG_ELIMINADO IS NULL
ORDER BY e.NOMBRE ASC");
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>

<table id="dataTable" class="table table-hover table-bordered">
	<thead>
		<tr>
			<th>Código interno</th>
			<th>Nombre</th>
			<th>Nombre informe</th>
			<th>Código FONASA</th>
			<th>Tipo de tubo</th>
			<th>Tipo muestra</th>
			<th>Agrupación</th>
			<th>Hijo</th>
			<th>Estado</th>
			<th>Acciones</th>
		</tr>
	</thead>
	<tbody>
		<?php foreach ($datos as $data) {
 ?>
			<tr>
				<td><?= $data['COD_INTERNO'] ?></td>
				<td><?= $data['NOMBRE'] ?></td>
				<td><?= $data['NOMBRE_INF'] != "" ? $data['NOMBRE_INF']: "-"; ?></td>
				<td><?= $data['COD_FONASA'] ?></td>
				<td><?= $data['TIPTUB'] ?></td>
				<td><?= $data['TIPMUE'] ?></td>
				<td><?= $data['FLAG_AGRUPACION'] == "N" ? "No" : "Si"; ?></td>
				<td><?= $data['FLAG_HIJO'] == "N" ? "No" : "Si"; ?></td>
				<td><?= $data['FLAG_ELIMINADO'] == 1 ? "<span class='badge bg-color-yellow'>Eliminado</span>" : "<span class='badge bg-color-green'>Activo</span>" ?></td>
				<td align="center" style="padding:0;">
					<a class="btn btn-link" style="padding:6px;" href="e_examen.php?idex=<?= $data['COD_INTERNO'] ?>"><i class="fa fa-edit fa-lg"></i></a>
					<a class="btn btn-link btn-eliminar" style="padding:6px;" data-cod="<?= $data['COD_INTERNO'] ?>"><i class="fa fa-trash-o fa-lg"></i></a>
				</td>
			</tr>
		<?php } ?>
	</tbody>
</table>
<?php

$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="examenes_pdf.php" class="btn btn-primary" title="Lista de Exámenes" target="_blank"><span class="fa fa-file-pdf-o"></span> Exportar Archivo PDF</a>',
			"class" => 'smart-form'
		), array(
			"id" => "toolbar-id",
			"content" => '<a href="n_examen.php" class="btn btn-success" title="Agregar Examen"><i class="fa fa-plus"></i> Agregar Exámen</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php include("../inc/ribbon.php");	?>
	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {

		$('.btn-eliminar').on('click', function() {
			if (confirm('¿Desea eliminar el examen?')) {
				$.post("sql_cod.php", {
					codigo: $(this).data('cod'),
					eliminarEx: '1'
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error("Error: " + data.mensaje);
					}
				}, 'json');
			}
		});

		$('#dataTable').DataTable({
			'lengthMenu': [
				[50, 100, 200],
				[50, 100, 200]
			],
			'language': {
				"sProcessing": "Procesando...",
				"sZeroRecords": "No se encontraron resultados",
				"sInfoPostFix": "",
				"sUrl": "",
				"oPaginate": {
					"sFirst": "Primero",
					"sPrevious": "Anterior",
					"sNext": "Siguiente",
					"sLast": "Último"
				},
				"sInfo": "_START_ a _END_ de _TOTAL_ Registros",
				"sInfoEmpty": "0 Registros",
				"sInfoFiltered": "(de _MAX_ Registros en total)",
				"sLengthMenu": "Mostrar _MENU_ Registros",
				"sSearch": "Buscar: "
			},
			'pageLength': 50,
			'order': [0, "asc"],
			'columns': [
				null,
				null,
				null,
				null,
				null,
				null,
				null,
				null,
				null,
				{ 
					"orderable": false
				}
			],
			'destroy': true
		});
	});
</script>
<?php
include("../inc/google-analytics.php");
?>