<?php
# $pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$idFormula = "-1";
if (isset($_GET['idFormula'])) $idFormula = $_GET['idFormula'];

$qFormula = $mysqli->prepare("SELECT DESCRIPCION, FORMULA FROM formulas_examen WHERE ID_FORMULA_EXAMEN = ?");
$qFormula->bind_param("s", $idFormula);
$qFormula->execute();
$qFormula->bind_result($descripcionFormula, $formulaFormula);
$qFormula->fetch();
$qFormula->close();

$options_examenes = "<option value=''>-</option>";
$qExamenes = $mysqli->prepare("SELECT COD_INTERNO, NOMBRE FROM examenes WHERE FLAG_ELIMINADO IS NULL");
$qExamenes->execute();
$qExamenes->bind_result($codExamen, $nombreExamen);
while ($qExamenes->fetch()) {
  $options_examenes .= "<option value='$codExamen'>$nombreExamen</option>";
}
$qExamenes->close();

$qVariables = $mysqli->prepare("SELECT vf.ID_VARIABLE_FORMULA_EXAMEN, vf.COD_EXAMEN_VARIABLE, vf.VARIABLE, ex.NOMBRE
FROM variables_formula_examen vf
INNER JOIN examenes ex ON ex.COD_INTERNO = vf.COD_EXAMEN_VARIABLE
WHERE vf.ID_FORMULA_EXAMEN = ?
ORDER BY vf.ID_VARIABLE_FORMULA_EXAMEN ASC");
$qVariables->bind_param("i", $idFormula);
$qVariables->execute();
$qVariables->bind_result($idVariableFormulaExamen, $codExamenVariable, $variable, $nombreExamenVariable);

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel">
    Configurar exámenes variables de fórmula
  </h4>
</div>

<div class="modal-body">
  <table class="table table-hover table-bordered">
    <thead>
      <tr>
        <th>Código examen</th>
        <th>Nombre examen</th>
        <th>Variable</th>
        <th></th>
      </tr>
    </thead>
    <tbody>
      <?php while ($qVariables->fetch()) { ?>
        <tr>
          <td><?= $codExamenVariable ?></td>
          <td><?= $nombreExamenVariable ?></td>
          <td><?= $variable ?></td>
          <td>
            <a class="btn btn-link btn-eliminarVariableFormula" data-id="<?= $idVariableFormulaExamen ?>"><i class="fa fa-lg fa-remove txt-color-red"></i></a>
          </td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
  <form class="smart-form" id="formAgregarVariableFormula" action="sql_cod.php">
    <div class="row">
      <div class="col col-6">
        <label class="select">
          <select name="COD_EXAMEN_VARIABLE" class="select2" style="width:100%">
            <?= $options_examenes ?>
          </select> Examen <i></i>
        </label>
      </div>
      <div class="col col-4">
        <label class="input">
          <input type="text" name="VARIABLE" class="input-sm"> Variable <i></i>
        </label>
      </div>
      <div class="col col-2">
        <a class="btn btn-sm btn-success btn-agregarVariableFormula">
          <i class="fa fa-plus"></i> Agregar
        </a>
      </div>
    </div>
    <input type="hidden" name="ID_FORMULA_EXAMEN" value="<?= $idFormula ?>" />
    <input type="hidden" name="formAgregarVariableFormula" value="formAgregarVariableFormula" />
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
</div>

<script>
  $(document).ready(function() {
    $(".btn-agregarVariableFormula").on("click", function() {
      $(this).attr('disabled', true);
      $.post('sql_cod.php', $('#formAgregarVariableFormula').serialize(), function(data) {
        if (data.exito) {
          exito();
          $("#md_variablesFormula .close").click();
          // location.reload();
        } else {
          error(data.mensaje);
          $(this).attr('disabled', false);
        }
      }, 'json');
    });

    $('.btn-eliminarVariableFormula').click(function() {
      if (confirm("¿Desea eliminar el examen variable de la fórmula?")) {
        $.post('sql_cod.php', {
          eliminarVariableFormula: 1,
          idVariableFormula: $(this).data('id'),
        }, function(data) {
          if (data.exito) {
            exito("Se ha guardado con exito!");
            $("#md_variablesFormula .close").click();
            // location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>