<?php
$pantalla_actual = 'ING_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$options_tipoTubo = optionsCodigosG("SIS_TIPTUB", null);
$options_areasLaboratorio = optionsCodigosG("SIS_AREAS", null);
$options_hojaTrabajo = optionsCodigosG("SIS_AREAS", null);
$options_unidadMedida = optionsCodigosG("SIS_UNIMED", null);
$options_tipoMuestra = optionsCodigosG("SIS_TIPMUE", null);
$options_preparacion = optionsCodigosG("SIS_PREPAR", null);
$options_archivoInstrucciones = optionsCodigosG("SIS_ARCINS", null);

ob_start();
?>
<form action="sql_cod.php" method="post" class="form-group" name="FormNuevoExam" id="FormNuevoExam">
  <table class="table table-hover table-bordered" style="width:50%">
    <tr>
      <th>Código Interno:</th>
      <td><input type="text" name="COD_INTERNO" class="form-control" placeholder="12.34.567" /></td>
    </tr>
    <tr>
      <th>Nombre:</th>
      <td><input type="text" name="NOMBRE" class="form-control" /></td>
    </tr>
    <tr>
      <th>Nombre en Informe:</th>
      <td><input name="NOMBRE_INF" type="text" class="form-control" maxlength="200" /></td>
    </tr>
    <tr>
      <th>Sinónimos</th>
      <td><input type="text" class="form-control TM_SINONIMOS" placeholder="Ingrese un sinónimo y presione Enter" autocomplete="off" /></td>
    </tr>
    <tr>
      <th>Agrupación:</th>
      <td>
        <select class="form-control" name="FLAG_AGRUPACION">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Hijo:</th>
      <td>
        <select class="form-control" name="FLAG_HIJO">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Codigo FONASA:</th>
      <td><input type="text" name="COD_FONASA" class="form-control" placeholder="12.34.567" pattern="[0-9][0-9]+.[0-9][0-9]+.[0-9][0-9][0-9]" /></td>
    </tr>
    <tr>
      <th>Tipo de Tubo:</th>
      <td>
        <select class="form-control" name="TIPO_TUBO">
          <?= $options_areasLaboratorio ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Tipo Muestra:</th>
      <td>
        <select name="TIPO_MUESTRA" class="form-control" id="TIPO_MUESTRA">
          <?= $options_tipoMuestra ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Unidad de Medida:</th>
      <td>
        <select class="form-control" name="UNIDAD_MEDIDA">
          <?= $options_unidadMedida ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Método Análisis:</th>
      <td><input name="METODO" type="text" class="form-control" id="METODO" /></td>
    </tr>
    <tr>
      <th>Cantidad:</th>
      <td><input name="CANTIDAD" type="text" class="form-control" id="CANTIDAD" /></td>
    </tr>
    <tr>
      <th>Área de Laboratorio:</th>
      <td>
        <select class="form-control" name="AREA_LAB">
          <?= $options_areasLaboratorio ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Área Hoja de Trabajo:</th>
      <td>
        <select class="form-control" name="NRO_HOJA_TRABAJO">
          <?= $options_hojaTrabajo ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Horas de Proceso:</th>
      <td><input type="number" class="form-control" name="HORAS_PROCESO" min="1" max="999" /></td>
    </tr>
    <tr>
      <th>Género</th>
      <td>
        <select name="GENERO" class="form-control" id="GENERO">
          <option value="F/M">F/M</option>
          <option value="F">FEMENINO</option>
          <option value="M">MASCULINO</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Ultima Regla:</th>
      <td>
        <select class="form-control" name="FLAG_ULTIMA_REGLA">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Costo Interno ($):</th>
      <td><input type="number" value="0" name="COSTO_INTERNO" class="form-control" /></td>
    </tr>
    <tr>
      <th>Secuencia Código de Barra:</th>
      <td><input type="number" class="form-control" name="SECUENCIA_CBARRA" min="0" max="1" /></td>
    </tr>
    <tr>
      <th>Incluir en Informe:</th>
      <td>
        <select class="form-control" name="F_INF">
          <option value="S">Si</option>
          <option value="N">No</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>% de diferencia examen Anterior: </th>
      <td>
        <input type="text" class="form-control" name="PORC_DIFERENCIA" />
      </td>
    </tr>
    <tr>
      <th>Urgente:</th>
      <td>
        <select class="form-control" name="FLAG_URGENTE">
          <option value="0">No</option>
          <option value="1">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Crítico:</th>
      <td>
        <select class="form-control" name="FLAG_CRITICO">
          <option value="0">No</option>
          <option value="1">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Preparación:</th>
      <td>
        <select name="PREPARACION" class="form-control" id="PREPARACION">
          <?= $options_preparacion ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Archivo Instrucciones:</th>
      <td>
        <select name="ARCH_INSTRUCCIONES" class="form-control" id="ARCH_INSTRUCCIONES">
          <?= $options_archivoInstrucciones ?>
        </select>
      </td>
    </tr>
    <!-- <tr>
      <th>Agrupación Homologada en I-MED:</th>
      <td>
        <select name="FLAG_AGRUPACION_HOMOLOGADA_IMED" class="form-control">
          <option value="0">No</option>
          <option value="1">Si</option>
        </select>
      </td>
    </tr> -->
    <tr>
      <th valign="middle">Observaciones:</th>
      <td><textarea name="OBS" id="OBS" class="form-control" cols="40" rows="5"></textarea></td>
    </tr>
    <tr>
      <td colspan="2" align="center">
        <a class="btn btn-primary btn-sm btn-grabar" data-form="#formUpdateAct">
          <i class="fa fa-save"></i> Grabar
        </a>
      </td>
    </tr>
  </table>
  <input type="hidden" name="InsertExamen" value="InsertExamen" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);
$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);

$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php include("../inc/ribbon.php");  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script src="<?= ASSETS_URL ?>/js/plugin/tagManager/3.0.2/tagmanager.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?= ASSETS_URL ?>/js/plugin/tagManager/3.0.2/tagmanager.min.css">

<script>
  $(document).ready(function() {
    $(".TM_SINONIMOS").tagsManager({
      hiddenTagListName: "TM_SINONIMOS",
      deleteTagsOnBackspace: false
    });

    $('.btn-grabar').on('click', function() {
      $.post('sql_cod.php', $('#FormNuevoExam').serialize(), function(data) {
        if (data.exito) {
          exito();
          window.location.href = 'l_examenes.php';
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    });
  })
</script>
<?php
//include footer
include("../inc/google-analytics.php");
?>