<?php
$pantalla_actual = 'LIS_PER';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$stmt = $mysqli->prepare("SELECT * FROM codigos_generales WHERE COD_TABLA = 'SIS_PERFIL'");
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>
<table id="dataTable" class="table table-hover table-bordered">
  <thead>
    <tr>
      <th>Perfiles</th>
      <th>Modificar</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($datos as $data) { ?>
      <tr>
        <td><?= $data['DESCRIPCION_CG'] ?></td>
        <td class="text-center"><a href="e_perfil.php?idPerfilUsuario=<?= $data['DESCRIPCION_CG'] ?>"><i class="fa fa-edit fa-lg"></i></a></td>
      </tr>
    <?php } ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <!-- MAIN CONTENT -->
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
  <!-- END MAIN PANEL -->
</div>

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?= ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    var order = [0, "asc"];
    var columnasNoOrdenables = [1];
    inicializarDataTables('dataTable', order, columnasNoOrdenables);
  })
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>