<?php
$pantalla_actual = 'ING_ELE_DOM';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];;
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idTablaGeneral = isset($_GET['idTablaGeneral']) ? $_GET['idTablaGeneral'] : "-1";
$codigoTablaGeneral = isset($_GET['codigoTablaGeneral']) ? $_GET['codigoTablaGeneral'] : "-1";

$stmt = $mysqli->prepare("SELECT MAX(CODIGO) AS MAX_CORR FROM codigos_generales WHERE COD_TABLA = ?");
$stmt->bind_param("s", $codigoTablaGeneral);
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_array(MYSQLI_ASSOC);

$contador = $datos['MAX_CORR'] + 1;

ob_start();
?>

<form id="formGrabarCodigoGeneral" class="form-horizontal">
  <table class="table table-hover table-bordered">
    <tr>
      <td>Código de la tabla:</td>
      <td><input name="COD_TABLA" type="text" class="form-control" value="<?= $codigoTablaGeneral ?>" readonly="readonly" /></td>
    </tr>
    <tr>
      <td>Descripción:</td>
      <td><input type="text" name="DESCRIPCION_CG" placeholder="Descripción del Código" class="form-control" required="required" autofocus="autofocus" /></td>
    </tr>
    <tr>
      <td>Atributo adicional (opcional):</td>
      <td><input type="text" class="form-control" placeholder="Atributo del Código" name="ATRIBUTO1" /></td>
    </tr>
    <tr>
      <td colspan="2" align="center">
      <a class="btn btn-primary btn-sm btn-grabarCodigoGeneral"><i class="fa fa-lg fa-save"></i> Grabar</a>
      </td>
    </tr>
  </table>
  <input name="CODIGO" type="hidden" value="<?= $contador ?>" />
  <input type="hidden" name="formGrabarCodigoGeneral" value="formGrabarCodigoGeneral" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    $('.btn-grabarCodigoGeneral').on('click', function() {
      idTablaGeneral = <?= $idTablaGeneral ?>;
      if (confirm("¿Desea agregar este elemento al dominio?")) {
        $.post("sql_cod.php", $("#formGrabarCodigoGeneral").serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            window.location.href = "l_codigos.php?idTablaGeneral=" + idTablaGeneral;
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>