<?php
$pantalla_actual = 'ING_DOM';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

ob_start();
?>

<form id="formGrabarTablaGeneral" class="form-horizontal">
  <table class="table table-hover table-bordered">
    <tr>
      <td>Código:</td>
      <td><input type="text" name="COD_TABLA" placeholder="Código del Sistema" value="" class="form-control" required="required" /></td>
    </tr>
    <tr>
      <td>Descripción:</td>
      <td><input type="text" name="DESCRIPCION_TG" value="" placeholder="Descripción de Tabla" class="form-control" required="required" /></td>
    </tr>
    <tr>
      <td>Tipo Tabla:</td>
      <td>
        <select name="ATRIBUTO1" class="form-control">
          <option value="S" selected>Sistema</option>
          <option value="V">Validación</option>
        </select>
      </td>
    </tr>
    <td colspan="2" align="center">
      <a class="btn btn-primary btn-sm btn-grabarTablaGeneral"><i class="fa fa-lg fa-save"></i> Grabar</a>
    </td>
  </table>
  <input type="hidden" name="formGrabarTablaGeneral" value="formGrabarTablaGeneral" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php include("../inc/ribbon.php");  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    $('.btn-grabarTablaGeneral').on('click', function() {
      if (confirm("¿Desea agregar esta tabla general?")) {
        $.post("sql_cod.php", $("#formGrabarTablaGeneral").serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            window.location.href = "l_tablas.php";
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>