<?php
$pantalla_actual = 'MOD_USU';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$id_usuario = "-1";
if (isset($_GET['idus'])) $id_usuario = $_GET['idus'];

$qUsuario = $mysqli->prepare("SELECT NRO_RUT, DV_RUT, NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO, PERFIL, FONO, MAIL, USUARIO, ID_CENTRO_COSTOS
FROM usuarios WHERE ID_USUARIO = ?");
$qUsuario->bind_param("i", $id_usuario);
$qUsuario->execute();
$qUsuario->bind_result($nro_rut, $dv_rut, $nombres, $apellido_p, $apellido_m, $perfil, $fono, $mail, $usuario, $id_centro_costo);
$qUsuario->store_result();
$qUsuario->fetch();
$qUsuario->close();

$qPerfilesUsuario = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_PERFIL'");
$qPerfilesUsuario->execute();
$qPerfilesUsuario->bind_result($codigo, $descripcion_cg);
$qPerfilesUsuario->store_result();
while ($qPerfilesUsuario->fetch()) {
  $selected = $perfil == $descripcion_cg ? "selected" : "";
  $options_perfilesUsuario .= "<option value='$descripcion_cg' $selected> $descripcion_cg </option>";
}
$qPerfilesUsuario->close();

$qCentrosContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto");
$qCentrosContacto->execute();
$qCentrosContacto->bind_result($id_centro_contacto, $nombre_centro_contacto);
$qCentrosContacto->store_result();
while ($qCentrosContacto->fetch()) {
  $selected = $id_centro_costo == $id_centro_contacto ? "selected" : "";
  $options_centroContacto .= "<option value='$id_centro_contacto' $selected> $nombre_centro_contacto </option>";
}
$qCentrosContacto->close();

ob_start();
?>

<form id="formModificarUsuario" class="form-inline">
  <table style="width:50%" class="table table-bordered">
    <tr>
      <td>Rut:</td>
      <td>
        <input type="text" class="form-control" placeholder="RUT" name="NRO_RUT" value="<?= $nro_rut ?>" pattern="[0-9]{6,8}" title="Rut sin Puntos" />
        -
        <input type="text" class="form-control" name="DV_RUT" value="<?= $dv_rut ?>" size="2" pattern="[0-9-k*K]" maxlength="1" />
      </td>
    </tr>
    <tr>
      <td>Nombres:</td>
      <td><input type="text" placeholder="Nombres" class="form-control" name="NOMBRES" value="<?= $nombres ?>" /></td>
    </tr>
    <tr>
      <td>Apellido paterno:</td>
      <td><input type="text" placeholder="Apellido Paterno" class="form-control" name="APELLIDO_PATERNO" value="<?= $apellido_p ?>" /></td>
    </tr>
    <tr>
      <td>Apellido materno:</td>
      <td><input type="text" placeholder="Apellido Materno" class="form-control" name="APELLIDO_MATERNO" value="<?= $apellido_m ?>" /></td>
    </tr>
    <tr>
      <td>Fono:</td>
      <td><input type="text" placeholder="Telefono" class="form-control" name="FONO" value="<?= $fono ?>" /></td>
    </tr>
    <tr>
      <td>Mail:</td>
      <td><input type="text" class="form-control" placeholder="Mail" name="MAIL" value="<?= $mail ?>" /></td>
    </tr>
    <tr>
      <td>Nombre de usuario:</td>
      <td><input type="text" class="form-control" placeholder="Nombre de usuario" name="USUARIO" value="<?= $usuario ?>" /></td>
    </tr>
    <tr>
      <td>Perfil:</td>
      <td>
        <select name="PERFIL" class="form-control">
          <option value="">-</option>
          <?= $options_perfilesUsuario ?>
        </select>
      </td>
    </tr>
    <tr>
      <td>Centro de Costo:</td>
      <td>
        <select name="ID_CENTRO_COSTOS" class="form-control">
          <option value="">-</option>
          <?= $options_centroContacto ?>
        </select>
      </td>
    </tr>
    <tr>
      <td colspan="2" align="center">
        <a class="btn btn-primary btn-sm btn-modificarUsuario"> <i class="fa fa-save"></i> Grabar </a>
      </td>
    </tr>
  </table>
  <input type="hidden" name="formModificarUsuario" value="formModificarUsuario" />
  <input type="hidden" name="ID_USUARIO" value="<?= $id_usuario ?>" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('.btn-modificarUsuario').on('click', function() {
      $.post('sql_cod.php', $('#formModificarUsuario').serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    });
  });
</script>


<?php
include("../inc/google-analytics.php");
?>