<?php
$pagina = 1;
define('PERMITIDO', true);
require_once("../inc/init.php");

if (isset($_POST["formAgregarUsuario"]) && $_POST["formAgregarUsuario"] != "") {

	$stmt = $mysqli->prepare("SELECT USUARIO FROM usuarios WHERE USUARIO = ?");
	$stmt->bind_param('s', $_POST['USUARIO']);
	$stmt->execute();
	$resultado = $stmt->get_result();
	$numFilas = $resultado->num_rows;

	if ($numFilas  > 0) mostrarMensajeError("El nombre de usuario ya existe");

	if ($_POST['CONTRASENA'] != $_POST['CONTRASENA2']) mostrarMensajeError("Las contraseñas deben coincidir");

	$stmt = $mysqli->prepare("INSERT INTO usuarios 
	(NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO, NRO_RUT, DV_RUT, USUARIO, CONTRASENA, PERFIL, ID_CENTRO_COSTOS) 
	VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
	$stmt->bind_param(
		'sssissssi',
		$_POST['NOMBRES'],
		$_POST['APELLIDO_PATERNO'],
		$_POST['APELLIDO_MATERNO'],
		$_POST['NRO_RUT'],
		$_POST['DV_RUT'],
		$_POST['USUARIO'],
		$_POST['CONTRASENA'],
		$_POST['PERFIL'],
		$_POST['ID_CENTRO_COSTOS']
	);
	$stmt->execute();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
	exit(0);
}

if (isset($_POST["formModificarUsuario"]) && $_POST["formModificarUsuario"] != "") {
	$stmt = $mysqli->prepare("UPDATE usuarios
	SET NRO_RUT = ?, DV_RUT = ?, NOMBRES = ?, APELLIDO_PATERNO = ?, APELLIDO_MATERNO = ?, FONO = ?, MAIL = ?, USUARIO = ?, PERFIL = ?, ID_CENTRO_COSTOS = ?
	WHERE ID_USUARIO = ?
	LIMIT 1");
	$stmt->bind_param(
		'issssssssii',
		$_POST['NRO_RUT'],
		$_POST['DV_RUT'],
		$_POST['NOMBRES'],
		$_POST['APELLIDO_PATERNO'],
		$_POST['APELLIDO_MATERNO'],
		$_POST['FONO'],
		$_POST['MAIL'],
		$_POST['USUARIO'],
		$_POST['PERFIL'],
		$_POST['ID_CENTRO_COSTOS'],
		$_POST['ID_USUARIO']
	);
	$stmt->execute();

	$stmt = $mysqli->prepare("UPDATE usuarios
	SET NOMBRES = UPPER(NOMBRES), APELLIDO_PATERNO = UPPER(APELLIDO_PATERNO), APELLIDO_MATERNO = UPPER(APELLIDO_MATERNO)
	WHERE ID_USUARIO = ?
	LIMIT 1");
	$stmt->bind_param('i', $_POST['ID_USUARIO']);
	$stmt->execute();

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}

if (isset($_POST['eliminarUsuario']) && $_POST['eliminarUsuario'] != "") {
	$stmt = $mysqli->prepare("UPDATE usuarios SET ACTIVO = 'N' WHERE ID_USUARIO = ? LIMIT 1");
	$stmt->bind_param('i', $_POST['idus']);
	$stmt->execute();
	$idTablaGeneral = $stmt->insert_id;

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}

if (isset($_POST['restaurarUsuario']) && $_POST['restaurarUsuario'] != "") {
	$stmt = $mysqli->prepare("UPDATE usuarios SET ACTIVO = 'S' WHERE ID_USUARIO = ? LIMIT 1");
	$stmt->bind_param('i', $_POST['idus']);
	$stmt->execute();
	$idTablaGeneral = $stmt->insert_id;

	$respuesta = array('exito' => true);
	echo json_encode($respuesta);
}
