<?php
$pantalla_actual = 'EDI_MEN';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
$style="<style> .note{margin:0 !important;}</style>";
include("../inc/header.php");
include("../inc/nav.php");

$idm="-1";if(isset($_GET['idm'])){$idm=$_GET['idm'];}

$qMensaje=$mysqli->prepare("SELECT ID_MENSAJE, DESCRIPCION, DATE_FORMAT(FH_CREACION,'%d-%m-%y %H:%i'), ID_USUARIO, FLAG_VIGENTE FROM mensajes m WHERE ID_MENSAJE=?");
$qMensaje->bind_param('i', $idm);
$qMensaje->execute();
$qMensaje->bind_result($m_id, $m_descripcion, $m_fhCreacion, $m_usuario, $m_flagVigente);
$qMensaje->execute();
$qMensaje->fetch();
$qMensaje->close();

$qPerfiles=$mysqli->prepare("SELECT PERFIL FROM usuarios
                            WHERE PERFIL!='' AND ACTIVO='S'
                            GROUP BY PERFIL
                            ORDER BY PERFIL");
$qPerfiles->execute();
$qPerfiles->bind_result($p_perfil);
$qPerfiles->store_result();


function usuariosMensaje($perfil, $idM){
    global $mysqli;
    $qUsuarios=$mysqli->prepare("SELECT u.ID_USUARIO, USUARIO, mu.ID_USUARIO, u.APELLIDO_MATERNO, u.APELLIDO_PATERNO, u.NOMBRES, DATE_FORMAT(mu.FH_ACEPTA,'%d-%m-%y %H:%i')
                                FROM usuarios u
                                LEFT JOIN mensajes_usuarios mu ON mu.ID_USUARIO=u.ID_USUARIO AND mu.ID_MENSAJE=?
                                WHERE PERFIL=? AND ACTIVO='S'");
    $qUsuarios->bind_param('is', $idM, $perfil);
    $qUsuarios->execute();
    $qUsuarios->bind_result($u_id, $u_usuario, $u_idUsuario, $u_aMaterno, $u_aPaterno, $u_nombres, $u_fhAcepta);
    $listaUsuarios='<div class="inline-group">';
    while ($qUsuarios->fetch()) {
        $checked=''; if($u_idUsuario!=''){$checked='checked="checked"';}
        $listaUsuarios.='
						<label class="checkbox" title="'.$u_nombres.' '.$u_aPaterno.' '.$u_aMaterno.'">
							<input type="checkbox" name="ID_USUARIO[]" '.$checked.' class="'.$perfil.'" value="'.$u_id.'">
							<i></i>'.$u_usuario.'
                            <div class="note">'.$u_fhAcepta.'</div>
                        </label>
					';
    }$qUsuarios->close();
    $listaUsuarios.='</div>';

    return $listaUsuarios;
}


ob_start();
?>

<div class="well">

    <form class="smart-form" action="sql_cod.php" method="post" name="formUpdateMensaje" id="formUpdateMensaje">
        <fieldset>
            <div class="row">
                    <section class="col col-8">
                        <h3>Descripción</h3>
                        <label class="textarea textarea-resizable">
                            <textarea rows="3" name="DESCRIPCION" class="custom-scroll"><?php echo $m_descripcion?></textarea>
                        </label>
                    </section>
                    <section class="col col-2">
                        <h3>Vigente</h3>
                        <div class="inline-group">
    						<label class="radio">
    							<input type="radio" name="FLAG_VIGENTE" value="1" <?php if($m_flagVigente==1){echo 'checked="checked"';} ?>>
    							<i></i>Si
                            </label>
    						<label class="radio">
    							<input type="radio" name="FLAG_VIGENTE" value="0" <?php if($m_flagVigente!=1){echo 'checked="checked"';} ?>>
    							<i></i>No
                            </label>
    					</div>
                    </section>
                    <section class="col col-2">
                        <h3>Fecha de Creación</h3>
                        <?php echo $m_fhCreacion ?>
                    </section>
            </div>
        </fieldset>
        <fieldset>
            <div class="row">
                <section class="col col-3"><h3>PERFILES</h3></section>
                <section class="col col-9"><h3>USUARIOS</h3></section>
            </div>
            <?php while($qPerfiles->fetch()){?>
            <div class="row">
                <section class="col col-3">
                    <label class="checkbox">
                        <input type="checkbox" class="perfil" data-perfil="<?php echo $p_perfil; ?>">
                        <i></i><?php echo $p_perfil; ?>
                    </label>
                </section>
                <section class="col col-9">
                    <?php echo usuariosMensaje($p_perfil, $idm); ?>
                </section>
            </div>
            <hr style="margin-bottom:10px;"/>
            <?php } $qPerfiles->close(); ?>
        </fieldset>
        <footer>
            <?php if($m_usuario==$usuario_id){ ?>
            <a class="btn btn-primary btn-sm btn-guardarMod" style="margin-right:3em;" data-form="#formUpdateMensaje">Guardar Cambios</a>
        <?php }else{echo '<p class="pull-right"><i class="fa fa-exclamation-circle"></i>  Solo modificable por Usuario Creador del Mensaje</p>';} ?>
        </footer>
    <input type="hidden" name="updateMensaje" value="formUpdateMensaje">
    <input type="hidden" name="ID_MENSAJE" value="<?php echo $m_id?>">
    </form>

</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#" class="btn btn-sm btn-success" data-toggle="modal" data-target="#myModalNew"><i class="fa fa-plus"></i> Crear Mensaje</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		include("../inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
	<div id="content">

		<?php $widget->print_html(); ?>

	</div>
	<!-- END MAIN CONTENT -->

</div>

<div class="modal fade New" id="myModalNew" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">

		<div class="modal-content">
		<form action="sql_cod.php" name="formInsertMensaje" id="formInsertMensaje" method="post">

			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">
					&times;
				</button>
				<h4 class="modal-title" id="myModalLabel">Nuevo Mensaje</h4>
			</div>

			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">
						<div class="form-group">
							<input type="text" class="form-control" placeholder="Descripción" name="DESCRIPCION" required />
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">
					Cancelar
				</button>
				<a class="btn btn-primary btn-sm pull-right btn-guardar" data-form="#formInsertMensaje">
				   <i class="fa fa-save"></i> Grabar
				</a>
			</div>
		<input type="hidden" name="insertMensaje" value="formInsertMensaje" />
		</form>
		</div><!-- /.modal-content -->

	</div><!-- /.modal-dialog -->
</div><!-- modal -->

<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>

	$(document).ready(function() {
		$('.btn-guardar').on('click', function(){
			var form = $(this).data('form');
			$.post($(form).attr('action'), $(form).serialize(), function(data){
				if(data.exito){
					exito();
					//location.reload();
					var id=data.id;
					window.location.href='e_mensaje.php?idm='+id;
				}else{
					error("Error: "+data.mensaje);
				}
			}, 'json');
		});

        $('.btn-guardarMod').on('click', function(){
			var form = $(this).data('form');
			$.post($(form).attr('action'), $(form).serialize(), function(data){
				if(data.exito){
					exito();
					location.reload();
				}else{
					error("Error: "+data.mensaje);
				}
			}, 'json');
		});

        $('.perfil').change(function(){
            var perfil=$(this).data('perfil');
            if($(this).is(':checked')) {
                $('.'+perfil).prop('checked',true);
            }else{
                $('.'+perfil).prop('checked',false);
            }
        })

	})

</script>

<?php
	//include footer
	include("../inc/google-analytics.php");
?>
