<?php
$pantalla_actual = 'LIS_MEN';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$filtro="WHERE mu.ID_USUARIO=$usuario_id";//SOLO LOS MENSAJES DESTINADOS AL USUARIO ACTUAL
if (in_array(54, $autorizaciones)) {$filtro="";}//SI TIENE LA CONFIUGRACION PUEDE VER TODO

$qMensajes=$mysqli->prepare("SELECT m.ID_MENSAJE, DESCRIPCION, FH_CREACION, u.USUARIO FROM mensajes m
	INNER JOIN usuarios u ON u.ID_USUARIO=m.ID_USUARIO
	LEFT JOIN mensajes_usuarios mu ON mu.ID_MENSAJE=m.ID_MENSAJE
	$filtro
	GROUP BY m.ID_MENSAJE
	ORDER BY FH_CREACION DESC");
$qMensajes->execute();
$qMensajes->bind_result($m_id, $m_descripcion, $m_fhCreacion, $m_usuario);
$qMensajes->execute();


ob_start();
?>
<table class="table table-bordered table-hover" id="dataTablesMensajes">
	<thead>
		<tr>
			<th style="width:50%">Decripción</th>
			<th>Fecha</th>
			<th>Usuario</th>
			<th>Modificar</th>
		</tr>
	</thead>
	<tbody>
	<?php while($qMensajes->fetch()){?>
		<tr>
			<td><?php echo $m_descripcion ?></td>
			<td><?php echo $m_fhCreacion ?></td>
			<td><?php echo $m_usuario ?></td>
			<td>
				<?php if (in_array(54, $autorizaciones)) { ?>
				<a class="fa fa-lg fa-edit" href="e_mensaje.php?idm=<?php echo $m_id?>">
				<?php } ?>
			</td>
		</tr>
	<?php }$qMensajes->close();?>
	</tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$boton='';
if (in_array(54, $autorizaciones)) {
	$boton='<a href="#" class="btn btn-sm btn-success" data-toggle="modal" data-target="#myModalNew"><i class="fa fa-plus"></i> Crear Mensaje</a>';
}

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);
$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => $boton,
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		include("../inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
	<div id="content">

		<?php $widget->print_html(); ?>

	</div>
	<!-- END MAIN CONTENT -->

</div>

<div class="modal fade New" id="myModalNew" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">

		<div class="modal-content">
		<form action="sql_cod.php" name="formInsertMensaje" id="formInsertMensaje" method="post">

			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">
					&times;
				</button>
				<h4 class="modal-title" id="myModalLabel">Nuevo Mensaje</h4>
			</div>

			<div class="modal-body">
				<div class="row">
					<div class="col-md-12">
						<div class="form-group">
							<input type="text" class="form-control" placeholder="Descripción" name="DESCRIPCION" required />
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">
					Cancelar
				</button>
				<a class="btn btn-primary btn-sm pull-right btn-guardar" data-form="#formInsertMensaje">
				   <i class="fa fa-save"></i> Grabar
				</a>
			</div>
		<input type="hidden" name="insertMensaje" value="formInsertMensaje" />
		</form>
		</div><!-- /.modal-content -->

	</div><!-- /.modal-dialog -->
</div><!-- modal -->

<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>

	$(document).ready(function() {
		$('.btn-guardar').on('click', function(){
			var form = $(this).data('form');
			$.post($(form).attr('action'), $(form).serialize(), function(data){
				if(data.exito){
					exito();
					//location.reload();
					var id=data.id;
					window.location.href='e_mensaje.php?idm='+id;
				}else{
					error("Error: "+data.mensaje);
				}
			}, 'json');
		});


		$('#dataTablesMensajes').DataTable({
				 'lengthMenu': [[20, 50, 100], [20, 50, 100]],
				 'language': {
						"sProcessing":   "Procesando...",
						"sZeroRecords":  "No se encontraron resultados",
						"sInfoPostFix":  "",
						"sUrl":          "",
						"oPaginate": {
							"sFirst":    "Primero",
							"sPrevious": "Anterior",
							"sNext":     "Siguiente",
							"sLast":     "Último"
						},
					 "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
					 "sInfoEmpty":    "0 Registros",
					 "sInfoFiltered": "(de _MAX_ Registros en total)",
					 "sLengthMenu":"Mostrar _MENU_ Registros",
					 "sSearch":"Buscar: "
				 },
				 'pageLength' : 50,
				 'order' : [ 1, "desc" ],
				 'columns': [
					 null,
					 null,
					 null,
					 {"orderable": false}
				 ],
				 'destroy': true
		});//DataTables
	})

</script>

<?php
	//include footer
	include("../inc/google-analytics.php");
?>
