<?php
$pagina = 11;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = "Consulta de Pagos";
$page_css[] = "your_style.css";
include("../inc/header.php");
$page_nav['Caja']['sub']['consulta_pagos']["active"] = true;
include("../inc/nav.php");



//filtro
$busqueda='';
if(isset($_GET['busq'])&&($_GET['busq']!='')){
	$b=$_GET['busq'];
	$busqueda.='  AND (CONCAT(IFNULL(CONCAT(p.NOMBRES,\' \'),\'\'),IFNULL(CONCAT(p.APELLIDO_PATERNO,\' \'),\'\'), IFNULL(p.APELLIDO_MATERNO,\'\')) LIKE \'%'.$b.'%\' OR p.NRO_RUT = \''.$b.'\' OR atenciones.ID_ATENCION = \''.$b.'\' OR cct.NOMBRE LIKE \'%'.$b.'%\')';
}//
if(isset($_GET['desde'])&&($_GET['desde']!='')){
	$b=$_GET['desde'];
	$busqueda.='  AND FECHA_PAGO >= \''.$b.'\'';
}//
if(isset($_GET['hasta'])&&($_GET['hasta']!='')){
	$b=$_GET['desde'];
	$busqueda.='  AND FECHA_PAGO <= \''.$b.'\'';
}//

$cant_reg = 100;		//Limito la busqueda
$inicio = 0;
$pagina = 1;
if(isset($_GET["pag"])){//examino la página a mostrar y el inicio del registro a mostrar
	$pagina = $_GET["pag"];	
   	$inicio = ($pagina - 1) * $cant_reg;
}
/* Consulta para saber total de paginas */
	if(isset($_GET['tpag'])){
		$total_paginas=$_GET['tpag'];
	}else{
		$consultaTotal='SELECT ID_PAGOS
						FROM pagos
						INNER JOIN atenciones ON pagos.ID_ATENCION=atenciones.ID_ATENCION 
						INNER JOIN personas p ON atenciones.ID_CLIENTE=p.ID_PERSONA 
						INNER JOIN centros_contacto cct ON pagos.ID_CC=cct.ID_CENTRO_CONTACTO
						WHERE 1 '.$busqueda.'';
		$qtotal=$mysqli->prepare($consultaTotal);
		$qtotal->execute();
		$qtotal->store_result();
		$totalRows_total=$qtotal->num_rows;
		$qtotal->close();
		$total_paginas = ceil($totalRows_total / $cant_reg);
}

$consulta='SELECT ID_PAGOS, pagos.ID_ATENCION, DATE_FORMAT(FECHA_PAGO,\'%d/%m/%Y\'), pagos.MONTO_PAGADO, NRO_DOCTO, CIERRE_INGRESO, 
			FLAG_CIERRECAJA, DESCRIPCION_CG, usuarios.USUARIO, CONCAT(IFNULL(p.NOMBRES, \'\'),\' \', IFNULL(p.APELLIDO_PATERNO, \'\'),\' \', IFNULL(p.APELLIDO_MATERNO, \'\')), 
			cct.NOMBRE 
			FROM pagos 
			INNER JOIN centros_contacto cct ON pagos.ID_CC=cct.ID_CENTRO_CONTACTO 
			LEFT JOIN codigos_generales ON pagos.FORMA_PAGO=codigos_generales.CODIGO AND COD_TABLA=\'SIS_FORPAG\'
			LEFT JOIN usuarios ON pagos.ID_CAJERO=usuarios.ID_USUARIO 
			INNER JOIN atenciones ON pagos.ID_ATENCION=atenciones.ID_ATENCION 
			INNER JOIN personas p ON atenciones.ID_CLIENTE=p.ID_PERSONA 
			WHERE 1 '.$busqueda.'
			ORDER BY FECHA_PAGO DESC, pagos.ID_ATENCION
			LIMIT ?, ?';
$qpagos=$mysqli->prepare($consulta);
$qpagos->bind_param('ii', $inicio, $cant_reg);
$qpagos->execute();
$qpagos->bind_result($p_id, $p_idAtencion, $p_fecha, $p_monto, $p_nroDoc, $p_cierreIngreso, $p_flagCierreCaja, $p_formaPago, $p_usuario, $p_paciente, $p_local);
$qpagos->store_result();
$totalRows_personas=$qpagos->num_rows;



ob_start();
?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->

	<!-- MAIN CONTENT -->

<form id="formBuscar" name="formBuscar" method="get" action="" class="smart-form">
<table class="table table-responsive">
  <tr>
	<td align="left" style="width:6em;"><h5>Busqueda:</h5> </td>  
    <td style="width:16em;">
    <label class="input">
      	<input type="search" name="busq" class="input-sm" autofocus="autofocus" placeholder="Atención, Nombre, RUT, Local" value="<?php if(isset($_GET['busq']))echo $_GET['busq']?>"/>
    </label>
    </td> 
    <td style="width:16em;">
    <label class="input">
      	<input type="date" name="desde" class="input-sm" autofocus="autofocus" value="<?php if(isset($_GET['desde']))echo $_GET['desde']?>"/>
    </label>
    </td>  
    <td style="width:16em;">
    <label class="input">
      	<input type="date" name="hasta" class="input-sm" autofocus="autofocus" value="<?php if(isset($_GET['hasta']))echo $_GET['hasta']?>"/>
    </label>
    </td>                
    <td style="width:6em;">
    	<a id="buscar" class="btn btn-link" title=""><i class="fa fa-search fa-lg"></i></a>         
    </td>
    <td style="width:6em;">
    	<a class="btn btn-info btn-sm" tittle="Ver Todo" onclick="location.href='l_pagos.php'"> Ver Todo </a>
    </td>
    <td>
     <div class="text-right"><?php if ($total_paginas > 1) {echo paginacion('l_pagos.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina,2,2);}?></div>
    </td>
  </tr>
</table>
</form>


<!------------------------->

<table class="table table-hover table-responsive table-bordered">
  <thead>
    <tr bgcolor="#999999">
      <th>Fecha Pago</th>
      <th align="left">Cajero</th>
      <th nowrap align="left">Lugar de Pago</th>
      <th nowrap align="left">N° Atención</th>
      <th align="left">Paciente</th>
      <th>Forma de Pago</th>
      <th>Monto Pagado</th>
      <th nowrap>N° Documento</th>
      <th>Cierre Caja</th>
      <th>Modificar</th>
    </tr>
    </thead>
    <tbody>
       <?php while($qpagos->fetch()) { ?>
      <tr>
        <td><?php echo $p_fecha; ?></td>
        <td><?php echo $p_usuario; ?></td>
        <td><?php echo $p_local; ?></td>
        <td><?php echo $p_idAtencion; ?></td>
        <td><?php echo $p_paciente ?></td>
        <td><?php echo $p_formaPago; ?></td>
        <td>$<?php echo number_format($p_monto,0,',','.'); ?></td>
        <td><?php echo $p_nroDoc; ?></td>
        <td><?php if($p_flagCierreCaja=='N'){echo 'No';}elseif($p_flagCierreCaja=='S'){ echo 'Si';}?></td>
		<td> 
		<?php if((($usuario_perfil!='ADMINISTRADOR')&&($p_flagCierreCaja=='N')&&($p_cierreIngreso=='N'))||($usuario_perfil=='ADMINISTRADOR')){?>               
        <a href="m_pago.php?idp=<?php echo $p_id.'&idate='.$p_idAtencion?>" class="btn btn-link"><i class="fa fa-edit fa-lg"></i></a> 
        <?php }?>
       </td>
      </tr>
  <?php }$qpagos->close(); ?>
  </tbody>
</table>
  
<?php if ($total_paginas > 1) {echo '<div class="text-center" style="padding-top:1em;">'.paginacion('l_pagos.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina).'<div class="note" style="margin:0;">'.$totalRows_total.' Registros</div></div>';}?>


<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => '<h2><strong>Consulta de Pagos</strong><em></em></h2>',
    "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		include("../inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
    <div id="content">	
		<?php
            $widget->print_html();
        ?>
	</div>
    		<!-- modal Edit-->
<!-- END MAIN PANEL -->
</div>
<!-- ==========================CONTENT ENDS HERE ========================== -->
<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>

$(document).ready(function() {
	$('#buscar').click(function(){
		$('#formBuscar').submit();
	})
})

</script>

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>