<?php
$pantalla_actual = 'CIE_CAJ';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$fechaB = isset($_GET['fecha']) ? $_GET['fecha'] : date('Y-m-d');
$fechaBusqueda = isset($_GET['fecha']) ? implode('-', array_reverse(explode('-', $fechaB))) : date('d-m-Y');

$filtro_local = isset($_GET['id_cc']) && $_GET['id_cc'] != '' ? " AND ID_CENTRO_CONTACTO = {$_GET['id_cc']}"  : "";

$optionsLocal = "<option value=''>--Seleccione--</option>";
$qOptionsCentroContacto = $mysqli->prepare("SELECT DISTINCT(cc.ID_CENTRO_CONTACTO), cc.NOMBRE
FROM centros_contacto cc
INNER JOIN pagos p ON p.ID_CC = cc.ID_CENTRO_CONTACTO
WHERE p.FECHA_PAGO = ?
ORDER BY cc.NOMBRE ASC");
$qOptionsCentroContacto->bind_param('s', $fechaB);
$qOptionsCentroContacto->execute();
$qOptionsCentroContacto->bind_result($idCentroContacto, $nombreCentroContacto);
$qOptionsCentroContacto->store_result();
while ($qOptionsCentroContacto->fetch()) {
	$selected = $_GET['id_cc'] == $idCentroContacto ? "selected" : "";
	$optionsLocal .= "<option value='$idCentroContacto' $selected> $nombreCentroContacto </option>";
}
$qOptionsCentroContacto->close();

$cierresCaja = $mysqli->prepare("SELECT cc.ID_CENTRO_CONTACTO, cc.NOMBRE, COUNT(p.ID_PAGOS), SUM(p.MONTO_PAGADO),
u.ID_USUARIO, CONCAT_WS(' ',  u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO)
FROM centros_contacto cc
INNER JOIN pagos p ON p.ID_CC = cc.ID_CENTRO_CONTACTO
INNER JOIN usuarios u ON p.ID_CAJERO = u.ID_USUARIO
WHERE p.FECHA_PAGO = ? $filtro_local
GROUP BY cc.ID_CENTRO_CONTACTO, p.ID_CAJERO
ORDER BY cc.NOMBRE ASC, u.APELLIDO_PATERNO ASC");
$cierresCaja->bind_param('s', $fechaB);
$cierresCaja->execute();
$cierresCaja->bind_result($cc_idCentroContacto,	$cc_nombreCentroContacto,	$cc_countPagos, $cc_montoPagado, $cc_idCajero, $cc_nombreCajero);
$cierresCaja->store_result();
$numRowsCierresCaja = $cierresCaja->num_rows;

/* Cierres de Egresos */
$qCierreEgreso = $mysqli->prepare("SELECT ID_CIERRE_EGRESO FROM cierre_egresos WHERE FECHA = ?");
$qCierreEgreso->bind_param('s', $fechaB);
$qCierreEgreso->execute();
$qCierreEgreso->bind_result($ce_id);
$qCierreEgreso->fetch();
$qCierreEgreso->close();

/* todos los egresos no cerrados, si $ce_id existe, busco los egresos del cierre */
if ($ce_id != '') {
	$qEgresos = $mysqli->prepare("SELECT SUM(MONTO) FROM egresos WHERE ID_CIERRE_EGRESO = ?");
	$qEgresos->bind_param('i', $ce_id);
} else {
	$qEgresos = $mysqli->prepare("SELECT SUM(MONTO) FROM egresos WHERE FLAG_CIERRECAJA = 'N' AND FECHA <= ?");
	$qEgresos->bind_param('s', $fechaB);
}
$qEgresos->execute();
$qEgresos->bind_result($e_monto);
$qEgresos->fetch();
$qEgresos->close();

ob_start();
?>

<form id="formBuscar" class="smart-form">
	<div class="row">
		<section class="col col-2">
			Fecha: <br>
			<label class="input"> <i></i>
				<input type="date" class="input-sm" name="fecha" value="<?= $fechaB ?>" />
			</label>
		</section>
		<section class="col col-2">
			Local: <br>
			<label class="select">
				<select id="id_cc" name="id_cc" class="input-sm">
					<?= $optionsLocal ?>
				</select> <i></i>
			</label>
		</section>
		<section class="col col-2">
			<br>
			<button id="buscar" type="button" class="btn btn-primary btn-sm">
				<i class="fa fa-search"></i> Buscar
			</button>
		</section>
	</div>
</form>

<!-- 
<h4> Cierre de Ingresos
	<?php if ($numRowsCierresCaja > 0) { ?>
		<a class="btn btn-link pull-right" href="pdf_cierre_ingresos.php?fecha=<?= $fechaB ?>" target="_blank"> Resumen PDF <i class="fa fa-file-pdf-o fa-lg"></i></a>
	<?php } ?>
</h4> 
-->

<table class="table table-hover table-bordered" id="dataTable_atenciones">
	<thead>
		<tr>
			<th>Local</th>
			<th>Cajero</th>
			<th>N° de pagos</th>
			<th>Monto Total</th>
			<th>Detalle de caja</th>
		</tr>
	</thead>
	<tbody>
		<?php if ($numRowsCierresCaja == 0) echo '<tr><td colspan="15" align="center">No Existen Ingresos en la fecha seleccionada</td></tr>'; ?>
		<?php while ($cierresCaja->fetch()) {
			$hidden = in_array(25, $autorizaciones) || $usuario_id == $cc_idCajero || $usuario_id == 1060 ? "" : "hidden";
		?>
			<tr>
				<td><?= $cc_nombreCentroContacto ?></td>
				<td><?= $cc_nombreCajero ?></td>
				<td><?= $cc_countPagos ?></td>
				<td>$ <?= number_format($cc_montoPagado, '0', ',', '.'); ?></td>
				<td class="text-center">
					<?= "<a class='btn btn-link btn-lg $hidden' target='_blank' href='detalleCierreCajaDiario.php?fecha=$fechaB&id_cc=$cc_idCentroContacto&id_c=$cc_idCajero'><i class='fa fa-search fa-lg'></i></a>" ?>
				</td>
			</tr>
		<?php }
		$cierresCaja->close(); ?>
	</tbody>
</table>

<!-- <p></p>
<h4>Cierre de Egresos
	<?php $link = '';
	if ($ce_id != '') {
		$link = '?idce=' . $ce_id; ?>
		<a class="btn btn-link pull-right" href="pdf_cierre_egresos.php<?= $link ?>" target="_blank">Resumen PDF <i class="fa fa-file-pdf-o fa-lg"></i></a>
	<?php } ?>
</h4>
<div class="well">

	<div class="row">
		<div class="col-md-4">
			<?php if ($ce_id == '') {
				echo '<h4>Egresos sin cerrar a la fecha (' . $fechaBusqueda . '):</h4>';
			} else {
				echo '<h4>Cierre de Egresos el Día ' . $fechaBusqueda . ' por :</h4>';
			}
			?>
		</div>
		<div class="col-md-2">
			<h4><?php if ($e_monto == '') {
						echo 'No hay Egresos';
					} else {
						echo '$ ' . $e_monto;
					} ?></h4>
		</div>
		<?php if ($e_monto > 0) { ?>
			<div class="col-md-1">
				<a data-toggle="modal" style="padding:0;" href="md_det_egresos.php?<?= 'f=' . $fechaB ?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-search fa-lg"></i> Detalle</a>
			</div>
			<div class="col-md-1">
				<?php if ($ce_id == '') { ?>
					<a class="btn btn-sm btn-success" id="btn-cerrarEgresos">Cerrar Egresos</a>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
</div> -->

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>
	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
	<div class="modal fade Edit" id="modal_detalle" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content"></div>
		</div>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {
		dataTable_atenciones = $('#dataTable_atenciones').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [0, "asc"],
      'columns': [
        null,
        null,
        null,
        null,
				{orderable: false}
      ]
    });

		// $(function() {
		// 	$("#fecha").datepicker();
		// });

		// $.validator.addMethod(
		// 	"fecha",
		// 	function(value, element) {
		// 		return value.match(/^(0?[1-9]|[12][0-9]|3[0-1])[/., -](0?[1-9]|1[0-2])[/., -](19|20)?\d{2}$/);
		// 	},
		// 	"Ingrese un fecha en formato dd-mm-yyyy."
		// );


		// $("#formBuscar").validate({
		// 	rules: {
		// 		fecha: {
		// 			required: true,
		// 			fecha: true
		// 		}
		// 	},
		// 	messages: {
		// 		fecha: {
		// 			required: 'Ingrese una fecha',
		// 			date: 'Ingrese una fecha válida'
		// 		}
		// 	},
		// 	onfocusout: false,
		// 	onsubmit: true,
		// 	// Do not change code below
		// 	errorPlacement: function(error, element) {
		// 		error.insertAfter(element.parent());
		// 	}
		// });

		$('#buscar').on('click', function() {
			var form = $('#formBuscar');
			if (form.valid()) {
				form.submit();
			}
		});

		$('#btn-cerrarEgresos').on('click', function() {
			var fecha = "<?= $fechaB ?>";
			var monto = "<?= $e_monto ?>";
			if (confirm('¿Desea hacer el Cierre de Egresos?')) {
				$.post('sql_cod.php', {
					cerrarEgresos: 1,
					fecha: fecha,
					monto: monto
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error(data.mensaje);
					}

				}, 'json');
			}
		});
	})
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>