<?php
$pantalla_actual = 'DET_CIE_CAJ';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$cierresCaja = $mysqli->prepare("SELECT SUM(p.MONTO_PAGADO), CONCAT_WS(' ',  u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO), cc.NOMBRE
FROM pagos p
INNER JOIN usuarios u ON p.ID_CAJERO = u.ID_USUARIO
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = p.ID_CC
WHERE p.FECHA_PAGO = ? AND p.ID_CAJERO = ? AND p.ID_CC = ?");
$cierresCaja->bind_param('sii', $_GET['fecha'], $_GET['id_c'], $_GET['id_cc']);
$cierresCaja->execute();
$cierresCaja->bind_result($monto_total, $nombreCajero, $nombreLocal);
$cierresCaja->store_result();
$cierresCaja->fetch();
$cierresCaja->close();

$cierresCaja = $mysqli->prepare("SELECT a.ID_ATENCION, cc.ID_CENTRO_CONTACTO, cc.NOMBRE, COUNT(p.ID_PAGOS), SUM(p.MONTO_PAGADO), p.FORMA_PAGO, cg.DESCRIPCION_CG
FROM atenciones a
LEFT JOIN pagos p ON p.ID_ATENCION = a.ID_ATENCION
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO AND COD_TABLA = 'SIS_FORPAG'
WHERE p.FECHA_PAGO = ? AND p.ID_CAJERO = ? AND p.ID_CC = ?
GROUP BY cg.DESCRIPCION_CG ASC");
$cierresCaja->bind_param('sii', $_GET['fecha'], $_GET['id_c'], $_GET['id_cc']);
$cierresCaja->execute();
$cierresCaja->bind_result($p_idAtencion, $p_idCentroContacto, $p_nombreCentroContacto, $cc_countPagos, $p_montoPagado, $p_codigoFormaPago, $p_descripcionFormaPago);
$cierresCaja->store_result();
$numRowsCierresCaja = $cierresCaja->num_rows;

ob_start();
?>

<div class="row">
  <div class="col-md-4">
    <p class="font-md">
      Fecha: <?= implode('/', array_reverse(explode('-', $_GET['fecha']))); ?>
      <br>
      Local: <?= $nombreLocal; ?>
      <br>
      Cajero: <?= $nombreCajero; ?>
      <br>
      Monto total: $ <?= number_format($monto_total, '0', ',', '.'); ?>
    </p>
  </div>
  <div class="col-md-4">
    <a style="margin-left:20px" class="btn btn-default pull-right" href="detalleCierreCajaDiario_xls.php?fecha=<?= $_GET['fecha'] ?>&id_cc=<?= $_GET['id_cc'] ?>&id_c=<?= $_GET['id_c'] ?>">
      <i class="fa fa-file-excel-o fa-lg"> </i> Exportar Excel
    </a>
    <a class="btn btn-default pull-right" href="detalleCierreCajaDiario_pdf.php?fecha=<?= $_GET['fecha'] ?>&id_cc=<?= $_GET['id_cc'] ?>&id_c=<?= $_GET['id_c'] ?>" target="_blank">
      <i class="fa fa-file-pdf-o fa-lg"> </i> Exportar PDF
    </a>
  </div>
</div>

<br>

<div class="row">
  <div class="col-md-8">
    <table class="table table-hover table-bordered" id="dataTable_atenciones">
      <thead>
        <tr>
          <th>Forma de Pago</th>
          <th>N° de pagos</th>
          <th>Monto Total</th>
          <th>Detalle Atenciones</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($numRowsCierresCaja == 0) echo '<tr><td colspan="15" align="center">No Existen Ingresos en la fecha seleccionada</td></tr>'; ?>
        <?php while ($cierresCaja->fetch()) { ?>
          <tr>
            <td><?= $p_descripcionFormaPago ?></td>
            <td><?php echo $cc_countPagos ?></td>
            <td>$ <?= number_format($p_montoPagado, '0', ',', '.'); ?></td>
            <td> <a data-toggle="modal" data-target="#md_atencionesDetalleCierreCaja" href="md_atencionesDetalleCierreCaja.php?fecha=<?= $_GET['fecha'] ?>&id_c=<?= $_GET['id_c'] ?>&id_cc=<?= $_GET['id_cc'] ?>&fp=<?= $p_codigoFormaPago ?>" class="btn btn-default"><i class="fa fa-list"></i></a>
            </td>
          </tr>
        <?php  }
        $cierresCaja->close(); ?>
      </tbody>
    </table>
  </div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <div class="modal fade Edit" id="md_atencionesDetalleCierreCaja" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content"></div>
    </div>
  </div>

</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    dataTable_atenciones = $('#dataTable_atenciones').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [0, "asc"],
      'columns': [
        null,
        null,
        null,
        null,
      ]
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>