<?php
$pantalla_actual = 'INF_VEN';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

# $f_de = (isset($_GET['f_de']) && $_GET['f_de'] != "") ? $_GET['f_de'] : date('Y-m-d', strtotime('-1 week'));

$filtroDesde = (isset($_GET['desde'])) ? $_GET['desde'] : date('Y-m-d', strtotime('-1 month'));
$filtroHasta = (isset($_GET['hasta'])) ? $_GET['hasta'] : date('Y-m-d');

if (isset($_GET['origen']) && $_GET['origen'] != '') {
  if ($_GET['origen'] == 1) $filtro .= " AND FLAG_COPAGO_BONO IS NULL";
  if ($_GET['origen'] == 2) $filtro .= " AND FLAG_COPAGO_BONO = 1";
}

$qInformeVentas = $mysqli->prepare("SELECT COUNT(p.ID_PAGOS), SUM(p.MONTO_PAGADO), cg.DESCRIPCION_CG
FROM pagos p
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO AND COD_TABLA = 'SIS_FORPAG'
WHERE p.FECHA_PAGO BETWEEN ? AND ? $filtro
GROUP BY cg.DESCRIPCION_CG ASC");
$qInformeVentas->bind_param('ss', $filtroDesde, $filtroHasta);
$qInformeVentas->execute();
$qInformeVentas->bind_result($cc_countPagos, $p_montoPagado, $p_descripcionFormaPago);
$qInformeVentas->store_result();
$numRows = $qInformeVentas->num_rows;

ob_start();
?>

<div class="well" style="padding:0">
  <div class="row">
    <div class="col-md-8">
      <h4 style="padding:5px">Filtros:</h4>
    </div>
    <div class="col-md-1">
    </div>
    <div class="col-md-1">
      <a class="btn btn btn-link txt-color-red" target="_blank" href="informeVentas_pdf.php?desde=<?= $filtroDesde ?>&hasta=<?= $filtroHasta ?>&origen=<?= $_GET["origen"] ?>">
        <i class="fa fa-file-pdf-o"></i> Exportar PDF
      </a>
    </div>
    <div class="col-md-1">
      <a class="btn btn btn-link txt-color-green" target="_blank" href="informeVentas_xls.php?desde=<?= $filtroDesde ?>&hasta=<?= $filtroHasta ?>&origen=<?= $_GET["origen"] ?>">
        <i class="fa fa-file-pdf-o"></i> Exportar Excel
      </a>
    </div>
  </div>
  <form class="smart-form" action="" method="get">
    <fieldset>
      <div class="row">
        <section class="col col-2">
          <label class="input">
            <input type="date" class="input-sm" name="desde" value="<?= $filtroDesde ?>">
          </label>
          <div class="note">
            Fecha Desde
          </div>
        </section>
        <section class="col col-2">
          <label class="input">
            <input type="date" class="input-sm" name="hasta" value="<?= $filtroHasta ?>">
          </label>
          <div class="note">
            Fecha Hasta
          </div>
        </section>
        <section class="col col-2">
          <label class="select">
            <select name="origen" class="input-sm">
              <option value="">--Seleccione--</option>
              <option <?= $_GET["origen"] == 1 ? "selected" : "" ?> value="1">Boleta</option>
              <option <?= $_GET["origen"] == 2 ? "selected" : "" ?> value="2">Copago bono electrónico</option>
            </select> <i></i>
          </label>
          <div class="note">Origen</div>
        </section>
        <section class="col col-1">
          <button type="submit" class="btn btn-sm btn-primary"><i class="fa fa-search"></i> Filtrar</button>
        </section>
        <section class="col col-1">
          <a class="btn btn-sm btn-default" href="informeVentas.php">Ver Todo</a>
        </section>
      </div>
    </fieldset>
  </form>
</div>

<br>

<div class="row">
  <div class="col-md-8">
    <table class="table table-hover table-bordered" id="dataTable_atenciones">
      <thead>
        <tr>
          <th>Forma de pago</th>
          <th>N° de pagos</th>
          <th>Monto total pagos</th>
          <!-- <th>Detalle Atenciones</th> -->
        </tr>
      </thead>
      <tbody>
        <?php while ($qInformeVentas->fetch()) { ?>
          <tr>
            <td><?= $p_descripcionFormaPago ?></td>
            <td><?= $cc_countPagos ?></td>
            <td>$ <?= number_format($p_montoPagado, '0', ',', '.'); ?></td>
            <!-- <td> 
              <a data-toggle="modal" data-target="#md_detalleAtenciones" href="md_detalleAtenciones.php?fecha=<?= $_GET['fecha'] ?>&id_c=<?= $_GET['id_c'] ?>&id_cc=<?= $_GET['id_cc'] ?>&fp=<?= $p_codigoFormaPago ?>" class="btn btn-default"><i class="fa fa-list"></i></a>
            </td> -->
          </tr>
        <?php }
        $qInformeVentas->close(); ?>
      </tbody>
    </table>
  </div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <div class="modal fade Edit" id="md_detalleAtenciones" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content"></div>
    </div>
  </div>

  <div class="modal fade Edit" id="md_comprobantes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="width:120%">
      </div>
    </div>
  </div>

</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    dataTable_atenciones = $('#dataTable_atenciones').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [0, "asc"],
      'columns': [
        null,
        null,
        null,
      ]
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>