<?php
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");
require_once("../assets/php/PHPExcel.php");
date_default_timezone_set("America/Santiago");

error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');
$objPHPExcel = new PHPExcel(); // Create new PHPExcel object
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Detalle de caja'); // Set document properties

$filtroDesde = (isset($_GET['desde'])) ? $_GET['desde'] : date('Y-m-d', strtotime('-1 month'));
$filtroHasta = (isset($_GET['hasta'])) ? $_GET['hasta'] : date('Y-m-d');

if (isset($_GET['origen']) && $_GET['origen'] != '') {
	if ($_GET['origen'] == 1) $filtro .= " AND FLAG_COPAGO_BONO IS NULL";
	if ($_GET['origen'] == 2) $filtro .= " AND FLAG_COPAGO_BONO = 1";
}

$qInformeVentas = $mysqli->prepare("SELECT COUNT(p.ID_PAGOS), SUM(p.MONTO_PAGADO), cg.DESCRIPCION_CG
FROM pagos p
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO AND COD_TABLA = 'SIS_FORPAG'
WHERE p.FECHA_PAGO BETWEEN ? AND ? $filtro
GROUP BY cg.DESCRIPCION_CG ASC");
$qInformeVentas->bind_param('ss', $filtroDesde, $filtroHasta);
$qInformeVentas->execute();
$qInformeVentas->bind_result($cc_countPagos, $p_montoPagado, $p_descripcionFormaPago);
$qInformeVentas->store_result();
$numRows = $qInformeVentas->num_rows;

//////////////////////// PARA QUE SE ACOMODE EL WIDTH DE LAS COLUMNAS //////////////////////////////
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

//////////////////////// ESTILO PARA LA CABECERA //////////////////////////////
$styleArray = array(
  'font'  => array(
    'bold'  => true,
    'color' => array('rgb' => 'FFFFFF'),
    'size'  => 11
    //'name'  => 'Verdana'
  ),
  'fill' => array(
    'type' => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array('rgb' => '4F81BD')
  ),
  'alignment' => array(
    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
  ),
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN
    )
  )
);

// $objPHPExcel->getActiveSheet()->getStyle('A1:H1')->applyFromArray($styleArray);

$aux = $numRows + 1;
$objPHPExcel->getActiveSheet()
  ->getStyle('A2:'.'H'.$aux)
  ->getNumberFormat()
  ->setFormatCode( PHPExcel_Style_NumberFormat::FORMAT_TEXT );

////////////////////////     ESCRITURA EN CELDAS      //////////////////////////////
$objPHPExcel->setActiveSheetIndex(0)
  ->setCellValue('A1', 'Forma de pago')
  ->setCellValue('B1', 'N° de pagos')
  ->setCellValue('C1', 'Monto total pagos');
  //->setCellValue('D1', 'N° documento')
  // ->setCellValue('E1', 'Método pago imed');
  // ->setCellValue('F1', 'Edad Paciente')
  // ->setCellValue('G1', 'Previsión')
  // ->setCellValue('H1', 'Resultado PCR');

// PARA ALINEAR CON LOS SALTOS DE LINEA
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('B1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('C1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('D1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('E1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('F1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('G1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('H1')->getAlignment()->setWrapText(true);

$f=2;
while ($qInformeVentas->fetch()) {
  $objPHPExcel->setActiveSheetIndex(0)
  ->setCellValue('A' . $f, $p_descripcionFormaPago)
  ->setCellValue('B' . $f, $cc_countPagos)
  ->setCellValue('C' . $f, $p_montoPagado);
  # ->setCellValue('D' . $f, $p_montoPagado)
  # ->setCellValue('E' . $f, $p_formaPagoImed ? $p_formaPagoImed : "-");
	$f++;
}
$qInformeVentas->close();

$objPHPExcel->getActiveSheet()->setTitle("Informe de ventas"); // Rename worksheet
$objPHPExcel->setActiveSheetIndex(0); // Set active sheet index to the first sheet, so Excel opens this as the first sheet


// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');

// header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); # Para xlsx, no funciona en servidor
header("Content-Disposition: attachment;filename=Informe de ventas $filtroDesde $filtroHasta.xls");
header('Cache-Control: max-age=0');

// // If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->setPreCalculateFormulas(false);
$objWriter->save('php://output');
exit();
