<?php
define('PERMITIDO', true);
require_once('../inc/init.php');
require_once('../assets/tcpdf/tcpdf.php');

class DetalleCaja extends TCPDF {
	public function Header() {
		$this->setImageScale(13);
		$this->setJPEGQuality(100);
		$this->Image('../imagenes/new_logo.jpg', '5', '5');
		# $this->Image('../assets/img/logo_informes.png', '10', '10'); TO DO: LOGO CON ESLOGAN
		$this->SetFont('times', '', 13);
		$this->writeHTMLCell(null, null, 10, 10, "<b>Informe de Ventas</b>", 0, 0, false, true, 'C', true);
	}
	
	public function Footer() {
		$this->SetFont('times', '', 10);
		$paginas = '<b>Página ' . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages(). '</b>';
    $this->writeHTMLCell(null, null, 10, 285, $paginas, 0, 0, false, true, 'C', true);
	}
}

$pdf = new DetalleCaja('P', 'mm', 'letter', true, 'UTF-8', false);
$pdf->SetMargins(10, 20, 10);
# $pdf->SetHeaderMargin(20);
$pdf->SetFooterMargin(15);
$pdf->SetAutoPageBreak(true, 15);
$pdf->setFontSubsetting(true);
$pdf->AddPage();

$filtroDesde = (isset($_GET['desde'])) ? $_GET['desde'] : date('Y-m-d', strtotime('-1 month'));
$filtroHasta = (isset($_GET['hasta'])) ? $_GET['hasta'] : date('Y-m-d');

if (isset($_GET['origen']) && $_GET['origen'] != '') {
	if ($_GET['origen'] == 1) $filtro .= " AND FLAG_COPAGO_BONO IS NULL";
	if ($_GET['origen'] == 2) $filtro .= " AND FLAG_COPAGO_BONO = 1";
}

$qInformeVentas = $mysqli->prepare("SELECT COUNT(p.ID_PAGOS), SUM(p.MONTO_PAGADO), cg.DESCRIPCION_CG
FROM pagos p
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO AND COD_TABLA = 'SIS_FORPAG'
WHERE p.FECHA_PAGO BETWEEN ? AND ? $filtro
GROUP BY cg.DESCRIPCION_CG ASC");
$qInformeVentas->bind_param('ss', $filtroDesde, $filtroHasta);
$qInformeVentas->execute();
$qInformeVentas->bind_result($cc_countPagos, $p_montoPagado, $p_descripcionFormaPago);
$qInformeVentas->store_result();
$numRows = $qInformeVentas->num_rows;

$data = "";
while ($qInformeVentas->fetch()) {
  # $p_formaPagoImed = $p_formaPagoImed ? $p_formaPagoImed : "-";
  $p_montoPagado = number_format($p_montoPagado, 0, ',', '.');
  $data .= "
      <tr>
        <td style=\"width: 40%\">{$p_descripcionFormaPago}</td>
        <td style=\"width: 20%\">{$cc_countPagos}</td>
        <td style=\"width: 40%\">$ {$p_montoPagado}</td>
      </tr>";
}
$qInformeVentas->close();

########################################################################################################
########################################################################################################

$pdf->SetFont('times', '', 10);
$datosCaja = "
	<table border=\"0\" cellpadding=\"40\">
		<tbody>
			<tr>
				<td style=\"width: 14%\">Rango de fechas: </td>
				<td style=\"width: 80%\">Desde $filtroDesde Hasta $filtroHasta</td>
			</tr>
		</tbody>
	</table>";
$pdf->writeHTML($datosCaja, true, false, false, false, '');

if ($data == "") $pdf->writeHTML("Error, No hay resultados", true, false, false, false, '');
else {
	$tbl =
		"<table border=\"1\" cellpadding=\"40\">
			<thead>
				<tr style=\"background-color: #f8f8f8\">
          <th style=\"width: 40%\">Forma de pago</th>
          <th style=\"width: 20%\">N° pagos</th>
          <th style=\"width: 40%\">Monto total pagos</th>
				</tr>
			</thead>
			<tbody>
        $data
			</tbody>
		</table>";

	$pdf->SetFont('times', '', 9);
	$pdf->writeHTML($tbl, false, false, true, false, 'L');
}

ob_end_clean();
$pdf->Output("Informe de Ventas $fechaDesde $fechaHasta.pdf", 'I');
?>
