<?php
$pagina = 14;
define('PERMITIDO', true);
require_once("../inc/init.php");

$filtro="FLAG_CIERRECAJA='N' AND FECHA <= ?";
if(isset($_GET['idce'])){
    $filtro="ID_CIERRE_EGRESO=?";
}
$qEgresos = $mysqli->prepare("SELECT e.ID_EG, DATE_FORMAT(e.FECHA,'%d/%m/%Y') AS FECHA, e.TIPO_EGRESO, e.N_BOLETA,
e.MONTO, e.OBSERVACION, us.USUARIO, empresas.NOMBRE_E
FROM egresos e
INNER JOIN usuarios us ON e.ID_CAJERO=us.ID_USUARIO
LEFT JOIN empresas ON e.ID_PROVEEDOR=empresas.ID_EMPRESA
WHERE $filtro
ORDER BY e.FECHA DESC");
if(isset($_GET['idce'])){
    $qEgresos->bind_param('i',$_GET['idce']);
}else{
    $qEgresos->bind_param('s',$_GET['f']);
}
echo $mysqli->error;
$qEgresos->execute();
$qEgresos->bind_result($e_id, $e_fecha, $e_tipoEgreso, $e_nBoleta, $e_monto, $e_observacion, $e_usuario, $e_empresa);
$qEgresos->store_result();
$num_rows_egresos=$qEgresos->num_rows;



?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
        &times;
    </button>
    <h4 class="modal-title" id="myModalLabel">Detalle de Egresos</h4>
</div>
<div class="modal-body">
    <table class="table table-responsive table-hover">
        <thead>
            <tr>
                <th>Fecha</th>
                <th>Usuario</th>
                <th>Tipo Egreso</th>
                <th>Boleta</th>
                <th>Proveedor</th>
                <th>Observaciones</th>
                <th>Monto</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $suma=0;
                while($qEgresos->fetch()){ ?>
                <tr>
                    <td><?php echo $e_fecha; ?></td>
                    <td><?php echo $e_usuario; ?></td>
                    <td><?php echo $e_tipoEgreso; ?></td>
                    <td><?php echo $e_nBoleta; ?></td>
                    <td><?php echo $e_empresa; ?></td>
                    <td><?php echo $e_observacion ?></td>
                    <td nowrap align="right"><?php echo number_format($e_monto,'0',',','.'); ?></td>
                </tr>
            <?php
                $suma+=$e_monto;
                }$qEgresos->close(); ?>
        </tbody>
        <tfoot>
            <?php if($num_rows_egresos>0){ ?>
            <tr>
                <td colspan="7"><div class="pull-right">Total: <?php echo number_format($suma,'0',',','.'); ?></div></td>
            </tr>
            <?php }else{?>
            <tr>
                <td colspan="7"><div class="text-center">No se registraron Egresos</div></td>
            </tr>
            <?php } ?>
        </tfoot>
    </table>

</div>
