<?php
$pantalla_actual = 'CIE_CAJ_ING_VAL';
define('PERMITIDO', true);

require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$tiempo = time();
$hoy=date('Y-m-d', $tiempo);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
$style="<style>
			h5{padding-left:2em !important;}
			fieldset{padding-top:15px !important;
					height:30px !important;}
		</style>";
include("../inc/header.php");
include("../inc/nav.php");

//recibo id local
$idlocal="-1";
if (isset($_GET['idlocal'])){
	$idlocal=$_GET['idlocal'];
}

$fechaBusqueda=date('d-m-Y');
if(isset($_GET['fecha'])){$fechaBusqueda=$_GET['fecha'];}

$id_cajero=$_GET['idu'];#segun cajero que se este viendo

$qCajero=$mysqli->prepare("SELECT USUARIO FROM usuarios WHERE ID_USUARIO=?");
$qCajero->bind_param('i', $id_cajero);
$qCajero->execute();
$qCajero->bind_result($c_usuario);
$qCajero->fetch();
$qCajero->close();

$qlocal = $mysqli->prepare("SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO=?");
$qlocal->bind_param('i',$idlocal);
$qlocal->execute();
$qlocal->bind_result($l_nombre);
$qlocal->fetch();
$qlocal->close();


//INGRESOS POR BONOS
//total en bonos sin cierre de caja

$qPagoBono = $mysqli->prepare("SELECT SUM(MONTO_PAGADO) AS ibono
FROM pagos WHERE FLAG_CIERRECAJA='N' AND FORMA_PAGO='1' AND FLAG_ELEC='N'  AND ID_CC=? AND DATE_FORMAT(FECHA_PAGO,'%d-%m-%Y')=? AND ID_CAJERO=?");
$qPagoBono->bind_param('isi', $idlocal, $fechaBusqueda, $id_cajero);
$qPagoBono->execute();
$qPagoBono->bind_result($p_ibono);
$qPagoBono->fetch();
$qPagoBono->close();


$qPagoBonoEle = $mysqli->prepare("SELECT SUM(MONTO_PAGADO) AS ibono
FROM pagos WHERE pagos.FLAG_CIERRECAJA='N' AND pagos.FORMA_PAGO='1' AND FLAG_ELEC='S'  AND ID_CC=? AND DATE_FORMAT(FECHA_PAGO,'%d-%m-%Y')=? AND ID_CAJERO=?");
$qPagoBonoEle->bind_param('isi', $idlocal, $fechaBusqueda, $id_cajero);
$qPagoBonoEle->execute();
$qPagoBonoEle->bind_result($p_ibonoE);
$qPagoBonoEle->fetch();
$qPagoBonoEle->close();

//INGRESOS POR BOLETA
//total en efectivo sin cierre de caja

$qPagoEfectivo = $mysqli->prepare("SELECT SUM(MONTO_PAGADO) AS ibolef
FROM pagos WHERE pagos.FLAG_CIERRECAJA='N' AND pagos.FORMA_PAGO='2'  AND ID_CC=? AND DATE_FORMAT(FECHA_PAGO,'%d-%m-%Y')=? AND ID_CAJERO=?");
$qPagoEfectivo->bind_param('isi', $idlocal, $fechaBusqueda, $id_cajero);
$qPagoEfectivo->execute();
$qPagoEfectivo->bind_result($p_ibolEf);
$qPagoEfectivo->fetch();
$qPagoEfectivo->close();


//total en cheques sin cierre de caja

$qPagoCheque = $mysqli->prepare("SELECT SUM(MONTO_PAGADO) AS ibolch
FROM pagos WHERE pagos.FLAG_CIERRECAJA='N' AND pagos.FORMA_PAGO='4'  AND ID_CC=? AND DATE_FORMAT(FECHA_PAGO,'%d-%m-%Y')=? AND ID_CAJERO=?");
$qPagoCheque->bind_param('isi', $idlocal, $fechaBusqueda, $id_cajero);
$qPagoCheque->execute();
$qPagoCheque->bind_result($p_ibolCh);
$qPagoCheque->fetch();
$qPagoCheque->close();

//total en Tarjeta Debito sin cierre de caja

$qPagoTD = $mysqli->prepare("SELECT SUM(MONTO_PAGADO) AS iboltd FROM pagos
WHERE pagos.FLAG_CIERRECAJA='N' AND pagos.FORMA_PAGO='5'  AND ID_CC=? AND DATE_FORMAT(FECHA_PAGO,'%d-%m-%Y')=? AND ID_CAJERO=?");
$qPagoTD->bind_param('isi', $idlocal, $fechaBusqueda, $id_cajero);
$qPagoTD->execute();
$qPagoTD->bind_result($p_ibolTd);
$qPagoTD->fetch();
$qPagoTD->close();


//total en Tarjeta Credito sin cierre de caja

$qPagoTC = $mysqli->prepare("SELECT SUM(MONTO_PAGADO) AS iboltc FROM pagos WHERE pagos.FLAG_CIERRECAJA='N' AND pagos.FORMA_PAGO='6'  AND ID_CC=? AND DATE_FORMAT(FECHA_PAGO,'%d-%m-%Y')=?");
$qPagoTC->bind_param('isi', $idlocal, $fechaBusqueda, $id_cajero);
$qPagoTC->execute();
$qPagoTC->bind_result($p_ibolTc);
$qPagoTC->fetch();
$qPagoTC->close();



$idcc="-1";
if(isset($_GET['idcc']) && $_GET['idcc']!=''){$idcc=$_GET['idcc'];}

$cierreCaja = $mysqli->prepare("SELECT FECHA, HORA, iBONOS, iBONOSE, iBolTC, iBolTD, iBolEF, iBolCH,
                iBonTC, iBonTD, iBonEF, iBonCH, EGRESOS, INGRESOS_CAJA_CHICA, SALDO_EFECTIVO, SALDO_CAJA
                FROM cierres_caja
                WHERE ID_CC=?");
                echo $mysqli->error;
$cierreCaja->bind_param('i', $idcc);
$cierreCaja->execute();
$cierreCaja->bind_result($cc_fecha, $cc_hora, $cc_iBonos, $cc_iBonosE, $cc_iBolTC, $cc_iBolTD, $cc_ibolEF, $cc_iBolCH,
                        $cc_iBonTC, $cc_iBonTD, $cc_iBonEF, $cc_iBonCH, $cc_egresos, $cc_ingresosCajaChica, $cc_saldoEfectivo, $cc_saldoCaja);
$cierreCaja->fetch();
$cierreCaja->close();

//---------------------------
if($idcc!="-1"){#consulta lo guadado en el cierre
	$in_bono=0+$cc_iBonos;
	$in_bonoE=0+$cc_iBonosE;
	$in_efec=0+$cc_ibolEF;
	$in_cheque=0+$cc_iBolCH;
	$in_td=0+$cc_iBolTD;
	$in_tc=0+$cc_iBolTC;
	$in_bonTC=0+$cc_iBonTC;
	$in_bonTD=0+$cc_iBonTD;
	$in_bonEF=0+$cc_iBonEF;
	$in_bonCH=0+$cc_iBonCH;
	$out_gasto=0+$cc_egresos;
	$caja_chica=0+$cc_ingresosCajaChica;
}else{#consulta totales
	$in_bono=0+$p_ibono;
	$in_bonoE=0+$p_ibonoE;
	$in_efec=0+$p_ibolEf;
	$in_cheque=0+$p_ibolCh;
	$in_td=0+$p_ibolTd;
	$in_tc=0+$p_ibolTc;
	$in_bonTC=0;
	$in_bonTD=0;
	$in_bonEF=0;
	$in_bonCH=0;
	$out_gasto=0+$e_monto;
	$caja_chica=0;

}
$linkDetalle='&idlocal='.$idlocal.'&fecha='.$fechaBusqueda.'&idu='.$id_cajero.'&idcc='.$idcc;
$linkDetallejs='&idlocal='.$idlocal.'&fecha='.$fechaBusqueda.'&idu='.$id_cajero;
ob_start();
?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->

<form id="formCierreCaja" name="formCierreCaja" class="smart-form" method="post" action="sql_cod.php">
	<header>
		<div class="row">
			<section class="col col-1">
				<h3><b>Caja: <?php echo $cc_idCentroContacto ?></b></h3>
			</section>
			<section class="col col-2">
				<h3><?php echo $l_nombre ?></h3>
			</section>
			<section class="col col-2">
				<h3><b>Cajero:</b> </h3>
			</section>
			<section class="col col-2">
				<h3><?php echo $c_usuario; ?></h3>
			</section>
			<section class="col col-1">
				<h3><b>Fecha:</b></h3>
			</section>
			<section class="col col-2">
				<h3><?php echo $fechaBusqueda; ?></h3>
			</section>
		</div>
	</header>

	<fieldset>
		<div class="row">
			<section class="col col-12">
				<h3>Ingresos por Bono</h3>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>A)</h5>
			</section>
			<section class="col col-3">
				<h5>Total Bono: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBONOS" id="iBONOS" type="text"  value="<?php echo $in_bono ;?>" size="20" pattern="[0-9]{1,10}" required readonly/>
				</label>
			</section>
			<section class="col col-3">
				<a data-toggle="modal" style="padding:0;" href="md_det_pagos.php?idfp=1&e=N<?php echo $linkDetalle?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-edit fa-lg"></i> Detalle</a>
			</section>
			<section class="col col-3">
				<a href="det_pagos_pdf.php?idfp=1&e=N<?php echo $linkDetalle?>" target="_blank"><i class="fa fa-pdf-file-o"></i></a>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>B)</h5>
			</section>
			<section class="col col-3">
				<h5>Total Bono Electrónico: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBONOSE" id="iBONOSE" type="text"  value="<?php echo $in_bonoE ;?>" size="20" pattern="[0-9]{1,10}" required readonly/>
				</label>
			</section>
			<section class="col col-3">
				<a data-toggle="modal" style="padding:0;" href="md_det_pagos.php?idfp=1&e=S<?php echo $linkDetalle?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-edit fa-lg"></i> Detalle</a>
			</section>
			<section class="col col-3">
				<a href="det_pagos_pdf.php?idfp=1&e=S<?php echo $linkDetalle?>" target="_blank"><i class="fa fa-pdf-file-o"></i></a>
			</section>
		</div>
	</fieldset>

	<fieldset>
		<div class="row">
			<section class="col col-12">
				<h3>Ingresos por Bono Electrónico</h3>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>C)</h5>
			</section>
			<section class="col col-3">
				<h5>Efectivo: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBonEF" id="iBonEF" type="text" required pattern="[0-9]{1,10}" value="<?php echo $in_bonEF?>" size="20{1,10}"/>
				</label>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>D)</h5>
			</section>
			<section class="col col-3">
				<h5>Cheque: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBonCH" id="iBonCH" type="text" required pattern="[0-9]{1,10}" value="<?php echo $in_bonCH?>"/>
				</label>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>E)</h5>
			</section>
			<section class="col col-3">
				<h5>Tarjeta Débito: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBonTD" id="iBonTD" type="text" required pattern="[0-9]{1,10}" value="<?php echo $in_bonTD?>" />
				</label>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>F)</h5>
			</section>
			<section class="col col-3">
				<h5>Tarjeta Crédito: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBonTC" id="iBonTC" type="text" required pattern="[0-9]{1,10}" value="<?php echo $in_bonTC?>" />
				</label>
			</section>
		</div>
	</fieldset>

	<fieldset>
		<div class="row">
			<section class="col col-12">
				<h3>Ingresos por Boleta</h3>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>G)</h5>
			</section>
			<section class="col col-3">
				<h5>Efectivo: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBolEF" id="iBolEF" type="text" value="<?php echo $in_efec ;?>" pattern="[0-9]{1,10}" required readonly />
				</label>
			</section>
			<section class="col col-3">
				<a data-toggle="modal" style="padding:0;" href="md_det_pagos.php?idfp=2&e=N<?php echo $linkDetalle?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-edit fa-lg"></i> Detalle</a>
			</section>
			<section class="col col-3">
				<a href="det_pagos_pdf.php?idfp=2&e=N<?php echo $linkDetalle?>" target="_blank"><i class="fa fa-pdf-file-o"></i></a>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>H)</h5>
			</section>
			<section class="col col-3">
				<h5>Cheque: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBolCH" id="iBolCH" type="text" value="<?php echo $in_cheque;?>" size="20" pattern="[0-9]{1,10}" required readonly/>
				</label>
			</section>
			<section class="col col-3">
				<a data-toggle="modal" style="padding:0;" href="md_det_pagos.php?idfp=4&e=N<?php echo $linkDetalle?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-edit fa-lg"></i> Detalle</a>
			</section>
			<section class="col col-3">
				<a href="det_pagos_pdf.php?idfp=4&e=N<?php echo $linkDetalle?>" target="_blank"><i class="fa fa-pdf-file-o"></i></a>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>I)</h5>
			</section>
			<section class="col col-3">
				<h5>Tarjeta Débito: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBolTD" id="iBolTD" type="text" value="<?php echo $in_td;?>" pattern="[0-9]{1,10}" required readonly/>
				</label>
			</section>
			<section class="col col-3">
				<a data-toggle="modal" style="padding:0;" href="md_det_pagos.php?idfp=5&e=N<?php echo $linkDetalle?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-edit fa-lg"></i> Detalle</a>
			</section>
			<section class="col col-3">
				<a href="det_pagos_pdf.php?idfp=5&e=N<?php echo $linkDetalle?>" target="_blank"><i class="fa fa-pdf-file-o"></i></a>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>J)</h5>
			</section>
			<section class="col col-3">
				<h5>Tarjeta Crédito: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="iBolTC" id="iBolTC" type="text" value="<?php echo $in_tc;?>" pattern="[0-9]{1,10}" required readonly/>
				</label>
			</section>
			<section class="col col-3">
				<a data-toggle="modal" style="padding:0;" href="md_det_pagos.php?idfp=6&e=N<?php echo $linkDetalle?>" data-target="#modal_detalle" title="Detalle"><i class="fa fa-edit fa-lg"></i> Detalle</a>
			</section>
			<section class="col col-3">
				<a href="det_pagos_pdf.php?idfp=6&e=N<?php echo $linkDetalle?>" target="_blank"><i class="fa fa-pdf-file-o"></i></a>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-12">
				<h3>CAJA</h3>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-1">
				<h5>K)</h5>
			</section>
			<section class="col col-3">
				<h5>Fondo Caja: $</h5>
			</section>
			<section class="col col-2">
				<label class="input">
					<input name="INGRESOS_CAJA_CHICA" id="INGRESOS_CAJA_CHICA" type="text" pattern="[0-9]{1,10}"  value="<?php echo $caja_chica?>" />
				</label>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-2">
				<h3>Saldos</h3>
			</section>
			<section class="col col-3">
				<a class="btn btn-primary btn-sm" id="calcular"> Calcular</a>
			</section>
		</div>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-3">
				<h5>Saldo Efectivo (Depósito):
					<div style="margin:0;" class="note">(C + G)</div>
				</h5>
			</section>
			<section class="col col-1">
				<h5>$</h5>
			</section>
			<section class="col col-2">
				<h5><div id="saldoEfectivo"><?php echo number_format($cc_saldoEfectivo,'0',',','.'); ?></div></h5>
			</section>
	</fieldset>
	<fieldset>
		<div class="row">
			<section class="col col-3">
				<h5>Saldo Caja:
					<div style="margin:0;" class="note">(A + B + C + D + E + F + G + H +I + J)</div>
				</h5>
			</section>
			<section class="col col-1">
				<h5>$</h5>
			</section>
			<section class="col col-3">
				<h5><div id="saldoCaja"><?php echo number_format($cc_saldoCaja,'0',',','.') ?></div></h5>
			</section>
		</div>
	</fieldset>

	<footer>
		<a class="btn btn-primary btn-sm" name="button" id="btn-grabar" value="Grabar" data-form="#formCierreCaja"> Grabar </a>
	</footer>

<input type="hidden" name="idcc" value="<?php echo $idcc?>" />
<input type="hidden" name="idl" value="<?php echo $idlocal; ?>" />
<input type="hidden" name="fecha" value="<?php echo $fechaBusqueda; ?>" />
<input type="hidden" name="id_usuario" value="<?php echo $id_cajero;?>">
<input type="hidden" name="SALDO_CAJA" id="input_saldoCaja" value="<?php echo $cc_saldoCaja;?>">
<input type="hidden" name="SALDO_EFECTIVO" id="input_saldoEfectivo" value="<?php echo $cc_saldoEfectivo;?>">
</form>
<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php include("../inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
    <div id="content">
		<?php
            $widget->print_html();
        ?>
	</div>
    		<!-- modal Edit-->
<!-- END MAIN PANEL -->
</div>

<div class="modal fade Edit" id="modal_detalle" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	 <div class="modal-dialog modal-lg">
		<div class="modal-content"></div>
	 </div>
</div>
<!-- ==========================CONTENT ENDS HERE ========================== -->
<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->
<script language="javascript" src="../scripts/format_number.js"></script>

<script>
$(document).ready(function() {

	$('#btn-grabar').addClass('disabled');

	$('#calcular').click(function(){
		var a=parseInt($('#iBONOS').val());
		var b=parseInt($('#iBONOSE').val());
		var c=parseInt($('#iBolEF').val());
		var d=parseInt($('#iBolCH').val());
		var e=parseInt($('#iBolTD').val());
		var f=parseInt($('#iBolTC').val());
		var g=parseInt($('#iBonEF').val());
		var h=parseInt($('#iBonCH').val());
		var i=parseInt($('#iBonTD').val());
		var j=parseInt($('#iBonTC').val());


		var suma_caja = a+b+c+d+e+f+g+h+i+j;
		var suma_deposito = c+g;//efectivo boleta + efectivo bono - egresos

		$('#saldoEfectivo').text(number_format(suma_deposito, 0,',','.'));
		$('#input_saldoEfectivo').val(suma_deposito);
		$('#saldoCaja').text(number_format(suma_caja, 0,',','.'));
		$('#input_saldoCaja').val(suma_caja);

		$('#btn-grabar').removeClass('disabled');
	})

	$('#btn-grabar').on('click', function(){//para mandar post con mensaje exito o error
		console.log('envio');
		var link='<?php echo $linkDetallejs?>';

		var form = $(this).data('form'); console.log(form);
		$.post($(form).attr('action'), $(form).serialize(), function(data){
			if(data.exito){
				exito();
				window.location.href='n_cierreC.php?idcc='+data.id+link;
			}else{
				error(data.mensaje);
			}

		}, 'json');
	});

});


</script>

<?php
	//include footer
	include("../inc/google-analytics.php");
?>
