<?php
$pagina = 0;

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');

$titulo = 'Laboratorio Central<br>Arlegui 440 - Oficina 218<br>Viña del Mar<br>Fono: 32-2714189';
$firma = 'QF Andoni Etcheverry<br>Director Técnico';
$nombre_centro_contacto = '';

$ce_id=$_GET['idce'];
$qCierreEgreso=$mysqli->prepare("SELECT DATE_FORMAT(FECHA,'%d-%m-%Y'), MONTO, u.USUARIO
						FROM cierre_egresos ce
						INNER JOIN usuarios u ON u.ID_USUARIO=ce.ID_USUARIO
						WHERE ID_CIERRE_EGRESO=?");
$qCierreEgreso->bind_param('i', $ce_id);
$qCierreEgreso->execute();
$qCierreEgreso->bind_result($ce_fecha, $ce_monto, $ce_usuario);
$qCierreEgreso->fetch();
$qCierreEgreso->close();

class documento extends TCPDF {

	public function Header() {
		global $titulo;
		global $ce_fecha;
		$this->SetFont('times', '', 8);
		$this->writeHTMLCell('50', '', 150, 10, $titulo, 0, 1, 0, true, 'C', true);
		$this->SetFont('times', '', 11);
		$this->writeHTMLCell('', '', '', '15', "Fecha: ".$ce_fecha, 0, 1, 0, true, 'C', true);
		$this->writeHTMLCell('', '', '', '10', "Detalle Cierre de Egresos", 0, 1, 0, true, 'C', true);
		$this->setImageScale(3);
		$this->setJPEGQuality(100);
		$this->Image(ASSETS_URL.'/img/logo.jpg', '10', '10');
	}
	public function Footer() {
		global $firma;
		$this->SetFont('times', '', 10);
		$this->writeHTMLCell('50', '', 230, 180, $firma, 0, 1, 0, true, 'C', true);
		$paginas = "Página ".$this->getAliasNumPage().' de '.$this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
		#$this->setImageScale(2.5);
		#$this->setJPEGQuality(100);
		#$this->Image('firma.jpg', '235', '160');
	}
}

$pdf = new documento('P', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 30, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 58);
$pdf->setFontSubsetting(true);
$pdf->SetFont('times', '', 9);





$qEgresos = $mysqli->prepare("SELECT e.ID_EG, DATE_FORMAT(e.FECHA,'%d-%m-%Y') AS FECHA, e.TIPO_EGRESO, e.N_BOLETA,
e.MONTO, e.OBSERVACION, us.USUARIO, empresas.NOMBRE_E
FROM egresos e
INNER JOIN usuarios us ON e.ID_CAJERO=us.ID_USUARIO
LEFT JOIN empresas ON e.ID_PROVEEDOR=empresas.ID_EMPRESA
WHERE ID_CIERRE_EGRESO=?");
$qEgresos->bind_param('i',$ce_id);
$qEgresos->execute();
$qEgresos->bind_result($e_id, $e_fecha, $e_tipoEgreso, $e_nBoleta, $e_monto, $e_observacion, $e_usuario, $e_empresa);
$qEgresos->store_result();
$num_rows_egresos=$qEgresos->num_rows;

$tbl= '
	<table border="1" cellpadding="3">
		<thead>
			<tr style="background-color: #f2f2f2;">
				<th><b>Fecha</b></th>
				<th><b>Egreso</b></th>
				<th><b>Proveedor</b></th>
				<th style="text-align:right"><b>Boleta</b></th>
				<th style="text-align:right"><b>Monto ($)</b></th>
			</tr>
		</thead>
		<tbody>';

		while($qEgresos->fetch()){


	$tbl.='	<tr>
				<td style="text-align:left">'.$e_fecha.'</td>
				<td style="text-align:left">'.$e_tipoEgreso.'</td>
				<td style="text-align:left">'.$e_empresa.'</td>
				<td style="text-align:right">'.$e_nBoleta.'</td>
				<td style="text-align:right">'.number_format($e_monto,'0',',','.').'</td>
			</tr>';

		}$qEgresos->close();

	$tbl.='	<tr>
				<td colspan="5" align="right">Total $ '.number_format($ce_monto,'0',',','.').'</td>
			</tr>';
$tbl.='	</tbody>
	</table>';

$pdf->AddPage();


$pdf->writeHTML($tbl, true, false, false, false, '');

ob_end_clean();
$pdf->Output('documento_pdf_nuevo.pdf', 'I');
?>
