<?php
$pantalla_actual = 'COBR_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qConvenios = $mysqli->prepare("SELECT e.NOMBRE_E FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($nombreConvenio);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();

$filtro = "";
if (isset($_GET['desde']) && $_GET['desde'] != "") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'";
if (isset($_GET['hasta']) && $_GET['hasta'] != "") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'";

$qConvenios = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO, 
CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO), a.ID_COBRANZA_CONVENIO
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_CONVENIO
WHERE e.ID_EMPRESA = ? AND a.FLAG_ELIMINADO = 0 AND a.ID_COBRANZA_CONVENIO IS NULL $filtro
AND a.FECHA >= '2021-04-07'  # FECHA DE CORTE ES 07-04-2021, NO QUITAR CONDICION
ORDER BY a.ID_ATENCION DESC");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result(
  $a_idAtencion,
  $a_fechaAtencion,
  $a_montoAtencion,
  $a_montoPagado,
  $a_montoDescuento,
  $a_montoACobrarConvenio,
  $a_pctjeDescuento,
  $a_nombrePaciente,
  $a_idCobroConvenio
);
$qConvenios->store_result();
$num_atenciones = $qConvenios->num_rows();

ob_start();
?>

<form action="" method="get" class="smart-form">
  <input type="hidden" name="id_conv" value="<?= $_GET['id_conv']; ?>" />
  <section>
    <div class="row">
      <div class="col col-2">
        <label class="input">
          <!-- FECHA DE CORTE ES 07-04-2021, NO QUITAR VALOR MINIMO DEFAULT -->
          <input type="date" class="form-control" name="desde" min="2021-04-07" value="<?= isset($_GET["desde"]) ? $_GET["desde"] : "2021-04-07" ?>" />
          <div class="note"> Desde <?php if (isset($_GET['desde']) && $_GET['desde'] != '') echo '<i class="fa fa-filter txt-color-red"></i>' ?> </div>
        </label>
      </div>
      <div class="col col-2">
        <label class="input">
          <input type="date" class="form-control" name="hasta" value="<?= isset($_GET["hasta"]) ? $_GET["hasta"] : "" ?>" />
          <div class="note"> Hasta <?php if (isset($_GET['hasta']) && $_GET['hasta'] != '') echo '<i class="fa fa-filter txt-color-red"></i>' ?> </div>
        </label>
      </div>
      <div class="col col-1">
        <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search fa-lg"></i>Filtrar</button>
      </div>
      <div class="col col-1">
        <a class="btn btn-sm btn-info" href="cobro_convenio.php?id_conv=<?= $_GET['id_conv'] ?>">Ver todo</a>
      </div>
      <div class="col col-1">
        <a class="btn btn-sm btn-link" target="_blank" href="pdf_cobro_convenio.php?id_conv=<?= $_GET['id_conv'] ?>&desde=<?= $_GET['desde'] ?>&hasta=<?= $_GET['hasta'] ?>"> Ver PDF <i class="fa fa-file-excel-o fa-lg"></i></a>
      </div>
      <div class="col col-1">
        <a class="btn btn-sm btn-link" target="_blank" href="xls_cobro_convenio.php?id_conv=<?= $_GET['id_conv'] ?>&desde=<?= $_GET['desde'] ?>&hasta=<?= $_GET['hasta'] ?>"> Ver Excel <i class="fa fa-file-excel-o fa-lg"></i></a>
      </div>
    </div>
  </section>
</form>

<form action="sql_cod.php" method="post" class="" name="formCobroConvenio" id="formCobroConvenio">
  <div class="table-responsive">
    <table id="dataTable_cobranza" class="table table-hover table-bordered">
      <thead>
        <tr>
          <th>Nro. Atención</th>
          <th>Fecha Atención</th>
          <th>Paciente</th>
          <th>Monto Atención</th>
          <th>Descuento ($)</th>
          <th>Descuento (%)</th>
          <th>Monto Atención con Descuentos</th>
          <th>Monto Pagado</th>
          <th>Monto a Cobrar a Convenio</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $monto_cobranza = 0;
        while ($qConvenios->fetch()) {
          $montoConDescuentos = $a_montoAtencion - $a_montoDescuento - ($a_montoAtencion * $a_pctjeDescuento / 100);
          $monto_cobranza += $a_montoACobrarConvenio;
        ?>
          <tr>
            <td><?= $a_idAtencion ?> <a style="padding-left:5px" target="_blank" href="../o_atenciones/e_atencion.php?idate=<?= $a_idAtencion ?>" title="Detalle Atención"> <i class="fa fa-search fa-lg"></i></a></td>
            <td><?= $a_fechaAtencion ?></td>
            <td><?= $a_nombrePaciente ?></td>
            <td>$ <?= number_format($a_montoAtencion, 0, ',', '.'); ?></td>
            <td>$ <?= number_format($a_montoDescuento, 0, ',', '.'); ?></td>
            <td><?= $a_pctjeDescuento ?> %</td>
            <td><b>$ <?= number_format($montoConDescuentos, 0, ',', '.'); ?></b></td>
            <td>
              $ <?= number_format($a_montoPagado, 0, ',', '.'); ?>
              <input type="hidden" name="id_atencion[]" value="<?= $a_idAtencion ?>" />
              <input type="hidden" name="monto_convenio[]" value="<?= $a_montoACobrarConvenio ?>" />
            </td>
            <td>
              $ <a href="#" class="montoACobrarConvenio" data-pk="<?= $a_idAtencion ?>" data-value="<?= $a_montoACobrarConvenio ?>">
            </td>
          </tr>
        <?php } ?>
      </tbody>
      <tfoot <?php if ($num_atenciones == 0) echo "hidden" ?>>
        <tr>
          <td class="text-center" colspan="9">
            <h5 class="text-center" colspan="9"> <b>Monto Total a Cobrar: </b>$ <?= number_format($monto_cobranza, 0, ',', '.'); ?> </h5>
            <a class="btn btn-sm btn-success btn-grabarCobroConvenio" data-form="#formCobroConvenio"> <i class="fa fa-money fa-lg"></i> Generar Cobranza </a>
          </td>
        </tr>
      </tfoot>
    </table>
  </div>

  <input type="hidden" name="grabarCobroConvenio" value="grabarCobroConvenio" />
  <input type="hidden" name="monto_cobranza" value="<?= $monto_cobranza ?>" />
  <input type="hidden" name="id_conv" value="<?= $_GET['id_conv'] ?>">
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'] . "<em>" . $nombreConvenio . "</em></h2>",
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) -->
<script src="../assets/js/plugin/x-editable/x-editable.min.js"></script>

<script>
  $(document).ready(function() {
    $('#dataTable_cobranza').DataTable({
      'lengthMenu': [
        [5, 10, 20],
        [5, 10, 20]
      ],
      'language': {
        'sProcessing': 'Procesando...',
        'sZeroRecords': 'No se encontraron resultados',
        'sInfoPostFix': '',
        'sUrl': '',
        'oPaginate': {
          'sFirst': 'Primero',
          'sPrevious': 'Anterior',
          'sNext': 'Siguiente',
          'sLast': 'Último'
        },
        'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
        'sInfoEmpty': '0 Registros',
        'sInfoFiltered': '(de _MAX_ Registros en total)',
        'sLengthMenu': 'Mostrar _MENU_ Registros',
        'sSearch': 'Buscar: '
      },
      'pageLength': 50,
      'order': [0, 'desc'],
      'columns': [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        {
          'orderable': false
        },
        {
          'orderable': false
        }
      ],
      'destroy': true
    });

    $('.montoACobrarConvenio').editable({
      onblur: "ignore",
      url: 'sql_cod.php',
      type: 'number',
      name: "grabarMontoACobrar",
      title: 'Modificar monto a cobrar',
      success: function(response, newValue) {
        location.reload();
        exito();
      }
    });

    $('.btn-grabarCobroConvenio').on('click', function() {
      if (confirm("¿Desea generar una cobranza considerando todas las actualmente atenciones en pantalla?")) {
        var form = $(this).data('form');
        $.post($(form).attr('action'), $(form).serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            var id_conv = <?= $_GET['id_conv'] ?>;
            window.location.href = 'historial_cobros_convenio.php?id_conv=' + id_conv;
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>