<?php
$pantalla_actual = 'DET_HIS_COBR_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qConvenios=$mysqli->prepare("SELECT DATE_FORMAT(cc.FECHA_COBRANZA,'%d/%m/%Y'), e.NOMBRE_E
FROM cobranzas_convenios cc
LEFT JOIN empresas e ON e.ID_EMPRESA = cc.ID_CONVENIO
WHERE ID_COBRANZA_CONVENIO = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_cc']);
$qConvenios->execute();
$qConvenios->bind_result($fechaCobro, $nombreConvenio);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();

$filtro = ""; 
if(isset($_GET['desde']) && $_GET['desde']!="") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'"; 
if(isset($_GET['hasta']) && $_GET['hasta']!="") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'"; 

$query = "SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO, 
CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO), a.ID_COBRANZA_CONVENIO
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_CONVENIO
WHERE a.ID_COBRANZA_CONVENIO = ? AND a.FLAG_ELIMINADO = 0 $filtro
ORDER BY a.ID_ATENCION DESC";
$qAtencionesCobranza=$mysqli->prepare($query);
$qAtencionesCobranza->bind_param('i', $_GET['id_cc']);
$qAtencionesCobranza->execute();
$qAtencionesCobranza->bind_result($a_idAtencion, $a_fechaAtencion, $a_montoAtencion, $a_montoPagado, $a_montoDescuento, $a_montoACobrarConvenio, $a_pctjeDescuento, 
$a_nombrePaciente, $a_idCobroConvenio);
$qAtencionesCobranza->execute();
$qAtencionesCobranza->store_result();

ob_start();
?>
<form action="" method="get" class="smart-form">
  <input type="hidden" name="id_cc" value="<?=$_GET['id_cc'];?>" />
  <section>
    <div class="row">
      <div class="col col-2">
        <label class="input">
          <!-- FECHA DE CORTE ES 07-04-2021, NO QUITAR VALOR MINIMO DEFAULT -->
          <input type="date" class="form-control" name="desde" min="2021-04-07" value="<? if(!isset($_GET["desde"])) echo "2021-04-07"; else echo $_GET["desde"]?>" />
          <div class="note"> Desde <?php if(isset($_GET['desde']) && $_GET['desde']!='') echo '<i class="fa fa-filter txt-color-red"></i>'?> </div> 
        </label>
      </div>
      <div class="col col-2">
        <label class="input">
        <input type="date" class="form-control" name="hasta" value="<?=$_GET['hasta']?>" />
        <div class="note"> Hasta <?php if(isset($_GET['hasta']) && $_GET['hasta']!='') echo '<i class="fa fa-filter txt-color-red"></i>'?> </div>
        </label>
      </div>
      <div class="col col-1">
        <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search fa-lg"></i> Filtrar</button>
      </div>
      <div class="col col-1">
        <a class="btn btn-sm btn-info" href="detalle_historial.php?id_cc=<?=$_GET['id_cc']?>">Ver todo</a>
      </div>
      <!-- <div class="col col-1">
        <a class="btn btn-sm btn-link" target="_blank" href="pdf_cobro_convenio.php?id_conv=<?=$_GET['id_conv']?>&desde=<?=$_GET['desde']?>&hasta=<?=$_GET['hasta']?>"> Ver PDF <i class="fa fa-file-excel-o fa-lg"></i></a>
      </div>
      <div class="col col-1">
        <a class="btn btn-sm btn-link" target="_blank" href="xls_cobro_convenio.php?id_conv=<?=$_GET['id_conv']?>&desde=<?=$_GET['desde']?>&hasta=<?=$_GET['hasta']?>"> Ver Excel <i class="fa fa-file-excel-o fa-lg"></i></a>
      </div> -->
    </div>
  </section>
</form>

<h5><b>Fecha Cobranza: </b><?=$fechaCobro?> </h5>
<!-- <h5><b>Monto Total Cobrado: </b>$ <?=number_format($monto_cobranza,0,',','.');?></h5> -->

<form action="sql_cod.php" method="post" class="" name="formCobroConvenio" id="formCobroConvenio">
  <table class="table table-responsive table-hover table-bordered datatable-atenciones-cobranza" >
    <thead>
      <tr>
        <th>Nro. Atención</th>
        <th>Fecha Atención</th>
        <th>Paciente</th>
        <th>Monto Atención</th>
        <th>Descuento ($)</th>
        <th>Descuento (%)</th>
        <th>Monto Atención con Descuentos</th>
        <th>Monto Pagado</th>
        <th>Monto Cobrado a Convenio</th>
      </tr>
    </thead>
    <tbody>
    <?php
      $monto_cobranza = 0;
      while($qAtencionesCobranza->fetch()) {
        $montoConDescuentos = $a_montoAtencion - $a_montoDescuento;
        if($a_pctjeDescuento != "" || $a_pctjeDescuento > 0) $montoConDescuentos = $montoConDescuentos*(100-$a_pctjeDescuento)/100;
        $monto_cobranza += $a_montoACobrarConvenio;
    ?>
      <tr>
        <td><?=$a_idAtencion?></td>
        <td><?=$a_fechaAtencion?></td>
        <td><?=$a_nombrePaciente?></td>
        <td>$ <?=number_format($a_montoAtencion,0,',','.');?></td>
        <td>$ <?=number_format($a_montoDescuento,0,',','.');?></td>
        <td><?=$a_pctjeDescuento?> %</td>
        <td><b>$ <?=number_format($montoConDescuentos,0,',','.');?></b></td>
        <td>$ <?=number_format($a_montoPagado,0,',','.');?></td>
        <td><b>$ <?=number_format($a_montoACobrarConvenio,0,',','.');?></b></td>
      </tr>
    <?php } $qAtencionesCobranza->close() ?>
    </tbody>
    <tfoot>
      <tr>
        <td class="text-center" colspan="9">
          <h5 class="text-center" colspan="9"> <b>Monto Total Cobrado: </b>$ <?=number_format($monto_cobranza,0,',','.');?> </h5>
        </td>
      </tr>
    </tfoot>
  </table>
</form>


<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title']."<em>".$nombreConvenio."</em></h2>",
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		include("../inc/ribbon.php");
	?>
	<!-- MAIN CONTENT -->
  <div id="content">	
    <?php
      $widget->print_html();
    ?>
  </div>
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) -->
<script src="../assets/js/plugin/x-editable/x-editable.min.js"></script>

<script>
$(document).ready(function() {

  $('.datatable-atenciones-cobranza').DataTable({
    'lengthMenu': [[5, 10, 20], [5, 10, 20]],
    'language': {
      'sProcessing': 'Procesando...',
      'sZeroRecords': 'No se encontraron resultados',
      'sInfoPostFix': '',
      'sUrl': '',
      'oPaginate': {
        'sFirst': 'Primero',
        'sPrevious': 'Anterior',
        'sNext': 'Siguiente',
        'sLast': 'Último'
      },
      'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
      'sInfoEmpty': '0 Registros',
      'sInfoFiltered': '(de _MAX_ Registros en total)',
      'sLengthMenu': 'Mostrar _MENU_ Registros',
      'sSearch': 'Buscar: '
    },
    'pageLength' : 50,
    'order' : [ 0, 'desc' ],
    'columns': [
      null,
      null,
      null,
      null,
      null,
      null,
      null,
      null,
      null
    ],
    'destroy': true
  });
});
</script>

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>