<?php
$pantalla_actual = 'COBR_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qConvenios = $mysqli->prepare("SELECT e.NOMBRE_E, e.FLAG_IVA, CONCAT_WS('-',e.NRO_RUT_EMPRESA,e.DV_RUT_EMPRESA) 
FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($nombreConvenio, $flag_iva, $rut_empresa);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();

$filtro = "";
if (isset($_GET['f_desde']) && $_GET['f_desde'] != "") $filtro .= " AND a.FECHA >= '{$_GET['f_desde']}'";
if (isset($_GET['f_hasta']) && $_GET['f_hasta'] != "") $filtro .= " AND a.FECHA <= '{$_GET['f_hasta']}'";

$qConvenios = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO, 
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), cc.NOMBRE, IFNULL(a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO),0) as por_pagar
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_CONVENIO
LEFT JOIN pagos pa ON pa.ID_ATENCION = a.ID_ATENCION AND pa.FORMA_PAGO IN (1,9) # BONOS O SEGUROS
WHERE e.ID_EMPRESA = ? AND a.FLAG_ELIMINADO = 0 AND a.ID_COBRANZA_CONVENIO IS NULL $filtro
GROUP BY a.ID_ATENCION
ORDER BY a.ID_ATENCION ASC");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result(
  $a_idAtencion,
  $a_fechaAtencion,
  $a_montoAtencion,
  $a_montoPagado,
  $a_montoDescuento,
  $a_montoACobrarConvenio,
  $a_pctjeDescuento,
  $a_nombrePaciente,
  $a_nombreLocal,
  $a_porPagarConvenio
);
$qConvenios->store_result();
$num_atenciones = $qConvenios->num_rows();

function calcularIva($flag_iva, $monto)
{
  if ($flag_iva == 'S') $monto = round($monto * 1.19, 0);
  return $monto;
}

ob_start();
?>

<form action="" method="get" class="smart-form">
  <input type="hidden" name="id_conv" value="<?= $_GET['id_conv']; ?>" />
  <div class="row">
    <section class="col col-2">
      <label class="label">
        Desde <?php if ($_GET['f_desde'] != '') echo '<i class="fa fa-filter txt-color-red"></i>' ?>
      </label>
      <label class="input">
        <input type="date" class="form-control" name="f_desde" value="<?= isset($_GET["f_desde"]) ? $_GET["f_desde"] : "" ?>" />
      </label>
    </section>
    <section class="col col-2">
      <label class="label">
        Hasta <?php if ($_GET['f_hasta'] != '') echo '<i class="fa fa-filter txt-color-red"></i>' ?>
      </label>
      <label class="input">
        <input type="date" class="form-control" name="f_hasta" value="<?= isset($_GET["f_hasta"]) ? $_GET["f_hasta"] : "" ?>" />
      </label>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <button class="btn btn-sm btn-default btn-block" type="submit"> <i class="fa fa-search fa-lg"></i> Filtrar</button>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default btn-block" href="cobro_convenio.php?id_conv=<?= $_GET['id_conv'] ?>"> <i class="fa fa-list  fa-lg"></i> Ver todo</a>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default" target="_blank" href="pdf_cobro_convenio2.php?id_conv=<?= $_GET['id_conv'] ?>&f_desde=<?= $_GET['f_desde'] ?>&f_hasta=<?= $_GET['f_hasta'] ?>"> <i class="fa fa-file-pdf-o fa-lg"> </i> Exportar PDF</a>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default" target="_blank" href="xls_cobro_convenio.php?id_conv=<?= $_GET['id_conv'] ?>&f_desde=<?= $_GET['f_desde'] ?>&f_hasta=<?= $_GET['f_hasta'] ?>"> <i class="fa fa-file-excel-o fa-lg"> </i> Exportar Excel</a>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default" target="_blank" href="xls_cobro_convenio2.php?id_conv=<?= $_GET['id_conv'] ?>&f_desde=<?= $_GET['f_desde'] ?>&f_hasta=<?= $_GET['f_hasta'] ?>"> <i class="fa fa-file-excel-o fa-lg"> </i> Exportar Excel (detalle exámenes)</a>
    </section>
  </div>

  <div class="well">
    <div style="display: flex; align-items: stretch;">
      <h5><b>Tipo Factura: </b></h5>
      <div class="inline-group" style="margin-left: 10px">
        <label class="radio">
          <input class="tipo_factura" type="radio" name="tipo_factura" <?= $tipo_factura == 33 ? "checked='true'" : "" ?> value="33">
          <i></i>Afecta
        </label>
        <label class="radio">
          <input class="tipo_factura" type="radio" name="tipo_factura" <?= $tipo_factura == 34 ? "checked='true'" : "" ?> value="34">
          <i></i>Exenta
        </label>
      </div>
    </div>
    <div class="font-md">
      IVA incluido: <?= $flag_iva == "S" ? "Si" : "No" ?>
    </div>
  </div>
</form>

<br>
<form action="sql_cod.php" method="post" name="formCobroConvenio" id="formCobroConvenio">
  <div class="table-responsive">
    <table id="dataTable_cobranza" class="table table-hover table-bordered">
      <thead>
        <tr>
          <th>N° atención</th>
          <th>Fecha atención</th>
          <th>Local</th>
          <th>Paciente</th>
          <th>Monto atención</th>
          <th>Descuento ($)</th>
          <th>Descuento (%)</th>
          <th>Monto atención con descuentos</th>
          <th>Monto pagado</th>
          <th>Monto convenio</th>
          <th>Detalle exámenes</th>
          <th>Excluir de cobranza</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $monto_cobranza = 0;
        while ($qConvenios->fetch()) {
          $montoConDescuentos = $a_montoAtencion - $a_montoDescuento - ($a_montoAtencion * $a_pctjeDescuento / 100);
          $aPagar = $montoConDescuentos;
          if ($a_porPagarConvenio) $aPagar = $a_porPagarConvenio;
          if ($a_montoACobrarConvenio) $aPagar = $a_montoACobrarConvenio;
          $monto_cobranza += $aPagar;
        ?>
          <tr>
            <td><?= $a_idAtencion ?> <a style="padding-left:5px" target="_blank" href="../o_atenciones/e_atencion.php?idate=<?= $a_idAtencion ?>" title="Detalle Atención"> <i class="fa fa-search fa-lg"></i></a></td>
            <td><?= $a_fechaAtencion ?></td>
            <td><?= $a_nombreLocal ?></td>
            <td><?= $a_nombrePaciente ?></td>
            <td>$ <?= number_format($a_montoAtencion, 0, ',', '.'); ?></td>
            <td>$ <?= number_format($a_montoDescuento, 0, ',', '.'); ?></td>
            <td><?= $a_pctjeDescuento ?> %</td>
            <td><b>$ <?= number_format($montoConDescuentos, 0, ',', '.'); ?></b></td>
            <td>
              $ <?= number_format($a_montoPagado, 0, ',', '.'); ?>
              <input type="hidden" name="id_atencion[]" value="<?= $a_idAtencion ?>" />
            </td>
            <td>
              <!-- <a href="#" class="montoACobrarConvenio" data-pk="<?= $a_idAtencion ?>" data-value="<?= $aPagar ?>"> -->
              <div style="display: flex;align-items: baseline;">
                $
                <label class="input" style="margin-left: 5px">
                  <input style=" padding:2px; text-align:right;width: 90%;" data-pk="<?= $a_idAtencion ?>" data-last_value="<?= $aPagar ?>" class="form-control input-xs monto_a_pagar" type="text" name="monto_convenio[]" value="<?= $aPagar ?>">
                </label>
              </div>
            </td>
            <td>
              <a data-toggle="modal" href="md_detalleExamenesAtencion.php?idate=<?= $a_idAtencion ?>" data-target="#md_detalleExamenesAtencion" class="btn btn-link btn-sm btn-modalExamenes">
                <i class="fa fa-lg fa-list"></i>
              </a>
            </td>
            <td class="text-center">
              <input type="checkbox" class="id_excluir" name="id_excluir[]" value="<?= $a_idAtencion ?>">
            </td>
          </tr>
        <?php } ?>
      </tbody>
      <tfoot <?php if ($num_atenciones == 0) echo "hidden" ?>>
        <tr>
          <td class="text-center" colspan="12">
            <?php
            $total_atenciones = $flag_iva == "S" ? ($monto_cobranza / 1.19) : $monto_cobranza;
            $iva = $flag_iva == "S" ? ($monto_cobranza / 1.19) * 0.19 : $monto_cobranza * 0.19;
            $total_pagar = $flag_iva == "S" ? $monto_cobranza : $monto_cobranza * 1.19;
            $array_detalles_factura = array(array('nombre' => "A", 'descripcion' => "COBRANZA", 'cantidad' => '1', 'precio_unitario' => round($total_pagar, 0), 'porc_descuento' => '0', 'monto_descuento' => '0', 'monto' => round($total_pagar, 0), 'id_detalle_venta' => ''));
            $datos_venta = "c_razon_social: '" . json_encode($nombreConvenio)  . "', c_direccion: 'A', c_rut: '" . $rut_empresa . "'";

            ?>
            <h5 class="text-center" id="total_atenciones"> <b>Total atenciones : </b>$<?= number_format($total_atenciones, 0, ',', '.'); ?> </h5>
            <h5 class="text-center" id="IVA"> <b>IVA: </b>$<?= number_format($iva, 0, ',', '.'); ?> </h5>
            <h5 class="text-center" id="monto_total_label"> <b>Monto Total a Cobrar: </b>$<?= number_format($total_pagar, 0, ',', '.'); ?> </h5>
            <a <? if ($_GET['f_desde'] == "" || $_GET['f_hasta'] == "") echo "disabled" ?> class="btn btn-sm btn-success btn-grabarCobroConvenio" data-form="#formCobroConvenio"> <i class="fa fa-money fa-lg"></i> Generar Cobranza </a>
          </td>
        </tr>
      </tfoot>
    </table>
  </div>
  <input type="hidden" id="f_desde" value="<?= $_GET['f_desde'] ?>">
  <input type="hidden" id="f_hasta" value="<?= $_GET['f_hasta'] ?>">
  <input type="hidden" name="monto_cobranza" id="monto_cobranza" value="<?= round($total_pagar, 0); ?>" />
  <input type="hidden" name="id_conv" value="<?= $_GET['id_conv'] ?>">
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'] . $nombreConvenio . "</h2>",
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

  <div class="modal fade Edit" id="md_detalleExamenesAtencion" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
      </div>
    </div>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) -->
<script src="../assets/js/plugin/x-editable/x-editable.min.js"></script>

<script>
  var flag_iva = '<?= $flag_iva ?>';
  $(document).ready(function() {
    $('#dataTable_cobranza').DataTable({
      "drawCallback": function(settings) {
        var api = this.api();
        // console.log(api.rows({
        //   page: 'current'
        // }).data());
        $(".monto_a_pagar").on('focusout', function() {
          var value = this.value;
          var pk = $(this).data("pk");
          // $.ajax({
          //     data: {
          //       "name": 'grabarMontoACobrar',
          //       "value": value,
          //       "pk": pk
          //     },
          //     type: "POST",
          //     dataType: "json",
          //     url: "sql_cod.php",
          //   })
          //   .done(function(data, textStatus, jqXHR) {
          //     console.log("La solicitud se ha completado correctamente.");
          //     console.log();
          //   })
          //   .fail(function(jqXHR, textStatus, errorThrown) {
          //     error(textStatus)
          //   });
          calcular_monto_total();
        });

        $(".id_excluir").each(function() {
          //console.log($(this).data());
        });

        $(".id_excluir").off('change').on('change', function() {
          var pk = this.value;
          if (this.checked) {
            $(".monto_a_pagar").each(function() {
              if ($(this).data('pk') == pk) {
                console.log($(this).data());
                $(this).css("display", 'none');
                $(this).data("last_value", this.value)
                $(this).val(0);
                console.log("A");
              }
            })
          } else {
            $(".monto_a_pagar").each(function() {
              if ($(this).data('pk') == pk) {
                console.log($(this).data());
                $(this).css("display", 'inherit');
                console.log(this.value);
                $(this).val($(this).data("last_value"));
                console.log("B");
              }
            })
          }
          calcular_monto_total();
        })
      },
      'lengthMenu': [
        [5, 10, 20, 50],
        [5, 10, 20, 50]
      ],
      'language': {
        'sProcessing': 'Procesando...',
        'sZeroRecords': 'No se encontraron resultados',
        'sInfoPostFix': '',
        'sUrl': '',
        'oPaginate': {
          'sFirst': 'Primero',
          'sPrevious': 'Anterior',
          'sNext': 'Siguiente',
          'sLast': 'Último'
        },
        'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
        'sInfoEmpty': '0 Registros',
        'sInfoFiltered': '(de _MAX_ Registros en total)',
        'sLengthMenu': 'Mostrar _MENU_ Registros',
        'sSearch': 'Buscar: '
      },
      'pageLength': 20,
      'order': [0, 'asc'],
      'columns': [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        {
          'orderable': false
        },
        {
          'orderable': false
        },
        {
          'orderable': false
        }
      ],
      'destroy': true
    });

    // $('.btn-modalExamenes').prop("disabled", true); // para activar los botones del modal despues de que cargue la info correctamente

    function calcular_monto_total() {
      var exenta = false;
      if ($('.tipo_factura:checked').val() == 34) {
        exenta = true;
      }
      console.log(exenta);
      var data = $('#dataTable_cobranza').dataTable().$('input, select').serializeArray();
      var monto_total = 0;
      data.forEach(element => {
        if (element['name'] == "monto_convenio[]") {
          monto_total += parseInt(element['value']);
          console.log(parseInt(element['value']));
        }
      });

      var total_atenciones = flag_iva == "S" ? monto_total / 1.19 : monto_total;
      var iva = flag_iva == "S" ? (monto_total / 1.19) * 0.19 : monto_total * 0.19;
      var total_pagar = flag_iva == "S" ? monto_total : monto_total * 1.19;

      if (exenta) {
        total_atenciones = monto_total;
        total_pagar = monto_total;
      }

      $("#total_atenciones").html("<b>Total atenciones:</b> $" + addCommas(toFixed(total_atenciones, 0)));
      if (!exenta) {
        $("#IVA").html("<b>IVA:</b> $" + addCommas(toFixed(iva, 0)));
      } else {
        $("#IVA").html("");
      }
      $("#monto_total_label").html("<b>Monto Total a Cobrar:</b> $" + addCommas(toFixed(total_pagar, 0)));

      $('#monto_cobranza').val(total_pagar);
    }

    function toFixed(num, precision) {
      return (+(Math.round(+(num + 'e' + precision)) + 'e' + -precision)).toFixed(precision);
    }

    function addCommas(nStr) {
      nStr += '';
      var x = nStr.split('.');
      var x1 = x[0];
      var x2 = x.length > 1 ? '.' + x[1] : '';
      var rgx = /(\d+)(\d{3})/;
      while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + '.' + '$2');
      }
      return x1 + x2;
    }

    $('.btn-grabarCobroConvenio').on('click', function() {
      if (!$('.tipo_factura:checked').val()) {
        alert("SELECCIONE UN TIPO DE FACTURA");
        return false;
      }
      if (confirm("¿Desea generar una cobranza considerando todas las actualmente atenciones en pantalla?")) {
        var form = $(this).data('form');
        var serializedForm = $(form).serializeArray();
        var dtForm = $('#dataTable_cobranza').dataTable().$('input, select').serializeArray();
        dtForm.push({
          name: 'grabarCobroConvenio',
          value: 'grabarCobroConvenio'
        }, {
          name: 'monto_cobranza',
          value: $("#monto_cobranza").val()
        }, {
          name: 'id_conv',
          value: '<?= $_GET['id_conv'] ?>'
        }, {
          name: 'tipo_factura',
          value: $('.tipo_factura:checked').val()
        }, {
          name: 'f_desde',
          value: $('#f_desde').val()
        }, {
          name: 'f_hasta',
          value: $('#f_hasta').val()
        });
        // console.log(dtForm);
        $.post($(form).attr('action'), dtForm, function(data) {
          if (data.exito) {
            exito(data.mensaje);
            var id_conv = <?= $_GET['id_conv'] ?>;
            window.location.href = 'historial_cobros_convenio.php?id_conv=' + id_conv;
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    $(".tipo_factura").on('click', function() {
      console.log(this.value);
      calcular_monto_total();
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>