<?php
# $pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$qExamenes = $mysqli->prepare("SELECT ea.COD_EXAMEN, ex.NOMBRE, em.NBR, ea.PRECIO_EXAMEN
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
  INNER JOIN empresas em ON em.ID_EMPRESA = ea.PREV
	WHERE ea.ID_ATENCION = ? AND ea.PADRE IS NULL");
	$qExamenes->bind_param('i', $_GET["idate"]);
	$qExamenes->execute();
	$qExamenes->bind_result($codigoExamen, $nombreExamen, $nbrEmpresaExamen, $precioExamen);
	$qExamenes->store_result();

  $filasExamenes = "";
  while ($qExamenes->fetch()) {
    $precioExamen = number_format($precioExamen, 0, ',', '.');
		$filasExamenes .= "
    <tr>
      <td>$codigoExamen</td>
      <td>$nombreExamen</td>
      <td>$nbrEmpresaExamen</td>
      <td>$ $precioExamen</td>
    </tr>";
	}
  $qExamenes->close();

	$tablaDetalleExamenes = "
	<table class='table table-bordered' style='font-size:11px'>
		<thead>
			<tr>
				<th>Código</th>
				<th>Nombre</th>
				<th>Empresa</th>
        <th>Precio</th>
			</tr>
		</thead>
		<tbody>
      $filasExamenes
    </tbody>
  </table>";

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Detalle de exámenes de atención</h4>
</div>

<div class="modal-body smart-form">
  <?= $tablaDetalleExamenes ?>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cerrar
  </button>
</div>


<script>
  $(document).ready(function() {
  });
</script>