<?php
$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$codExamen = isset($_GET['codExamen']) ? $_GET['codExamen'] : "-1";
$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

$query = $mysqli->prepare("SELECT NOMBRE
FROM examenes
WHERE COD_INTERNO = ?
LIMIT 1");
$query->bind_param("s", $codExamen);
$query->execute();
$query->bind_result($nombreExamen);
$query->store_result();
$query->fetch();
$query->close();

$qEmpresas = $mysqli->prepare("SELECT pe.ID_PEX, pe.COD_EXAMEN, pe.PRECIO, DATE_FORMAT(pe.FECHA_INICIO,'%d/%m/%Y %H:%i:%s') 
FROM precios_examenes pe
INNER JOIN examenes e ON pe.COD_EXAMEN = e.COD_INTERNO
WHERE pe.COD_EXAMEN = ? AND ID_EMPRESA = ?
ORDER BY pe.ID_PEX DESC");
$qEmpresas->bind_param("si", $codExamen, $idEmpresa);
$qEmpresas->execute();
$qEmpresas->bind_result($id_pex, $cod_examen, $precio_examen, $fecha_precio);
$qEmpresas->store_result();
$rows = $qEmpresas->num_rows;

ob_start();
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
        &times;
    </button>
    <h4 class="modal-title" id="myModalLabel">Historial de precios de examen </h4>
</div>

<div class="modal-body">
    <p class="font-md">Código examen: <?= $codExamen ?></p>
    <p class="font-md">Nombre examen: <?= $nombreExamen ?></p>
    <div class="table-responsive">
        <table id="dataTable-historialPrecios" class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>Precio examen</th>
                    <th>Fecha última modificación</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($qEmpresas->fetch()) { ?>
                    <tr>
                        <td>$ <?= number_format($precio_examen, '0', ',', '.') ?></td>
                        <td><?= $fecha_precio ?></td>
                    </tr>
                <?php }
                $qEmpresas->close();
                ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">
        Cancelar
    </button>
    <!-- <button class="btn btn-primary btn-modificarPrecioExamen pull-right" data-form="#formModificarPrecioExamen"> <i class="fa fa-save"></i> Grabar </button> -->
</div>

<script>
    $(document).ready(function() {
        $(".btn-modificarPrecioExamen").on("click", function() {
            $(".btn-modificarPrecioExamen").attr('disabled', true);
            $.post('sql_cod.php', $('#formModificarPrecioExamen').serialize(), function(data) {
                if (data.exito) {
                    exito();
                    location.reload();
                } else {
                    error(data.mensaje);
                    $(".btn-modificarPrecioExamen").attr('disabled', false);
                }
            }, 'json');
        });
    });
</script>