<?php
$pantalla_actual = 'INF_ATE_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qAtencionesConvenio = $mysqli->prepare("SELECT e.ID_EMPRESA, e.NBR
FROM usuarios u
INNER JOIN empresas e ON u.NRO_RUT = e.NRO_RUT_EMPRESA
WHERE ID_USUARIO = ?");
$qAtencionesConvenio->bind_param('i', $usuario_id);
$qAtencionesConvenio->execute();
$qAtencionesConvenio->bind_result($id_convenio, $nbr_convenio);
$qAtencionesConvenio->store_result();
$qAtencionesConvenio->fetch();
$qAtencionesConvenio->close();

# FILTRO POR LOCAL 
$resultado_locales = $mysqli->query("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto WHERE ID_EMPRESA = $id_convenio ORDER BY NOMBRE ASC");
$id_local = -1;
if (isset($_GET['id_cc']) && $_GET['id_cc'] != '') $id_local = $_GET['id_cc'];
$opciones_locales = '<option value="">-</option>';
while ($local = $resultado_locales->fetch_assoc()) {
  $selected = $local['ID_CENTRO_CONTACTO'] == $id_local ? 'selected' : '';
  $opciones_locales .= "<option value='" . $local['ID_CENTRO_CONTACTO'] . "'" . $selected . "> " . $local['NOMBRE'] . "</option>";
}

$f_de = isset($_GET['f_de']) ? $_GET['f_de'] : date('Y-m-d', strtotime('-1 week'));
$f_ha = isset($_GET['f_ha']) ? $_GET['f_ha'] : date('Y-m-d');
$filtro = (isset($_GET['id_cc']) && $_GET['id_cc'] != "") ? " AND a.ID_CENTRO_CONTACTO  = {$_GET['id_cc']}" : "";

$qAtencionesConvenio = $mysqli->prepare("SELECT a.ID_ATENCION
FROM atenciones a
INNER JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA AND conv.ID_EMPRESA = ?
# INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION  # AND ea.COD_EXAMEN = '00.00.069'
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
LEFT JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
WHERE (FECHA BETWEEN ? AND ?) AND FECHA_R IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro
ORDER BY ID_ATENCION DESC");
$qAtencionesConvenio->bind_param('iss', $id_convenio, $f_de, $f_ha);
$qAtencionesConvenio->execute();
$qAtencionesConvenio->bind_result($id_atencion);
$qAtencionesConvenio->store_result();
$numRows_Atenciones = $qAtencionesConvenio->num_rows;

$qAtencionesConvenioConInforme = $mysqli->prepare("SELECT a.ID_ATENCION
FROM atenciones a
# INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION # AND ea.COD_EXAMEN = '00.00.069'
INNER JOIN archivos_atenciones aa ON aa.ID_ATENCION = a.ID_ATENCION AND aa.ID_ARCHIVO = (SELECT MAX(z.ID_ARCHIVO) FROM archivos_atenciones z WHERE z.ID_ATENCION = a.ID_ATENCION AND z.TIPO = 'INFORME')
INNER JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA AND conv.ID_EMPRESA = ?
WHERE (a.FECHA BETWEEN ? AND ?) AND FECHA_R IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro");
$qAtencionesConvenioConInforme->bind_param('iss', $id_convenio, $f_de, $f_ha);
$qAtencionesConvenioConInforme->execute();
$qAtencionesConvenioConInforme->bind_result($id_atencion);
$qAtencionesConvenioConInforme->store_result();
$numRows_AtencionesConInforme = $qAtencionesConvenioConInforme->num_rows;

ob_start();
?>

<form id="formFiltros" method="get" action="">
  <div class="row">
    <div class="col-md-2">
      <strong>Fecha Desde:</strong>
      <br>
      <input type="date" class="form-control" name="f_de" value="<?= $f_de ?>" />
    </div>
    <div class="col-md-2">
      <strong>Fecha Hasta:</strong>
      <br>
      <input type="date" class="form-control" name="f_ha" value="<?= $f_ha ?>" />
    </div>
    <div class="col-md-2">
      <strong>Local:</strong>
      <br>
      <select class="form-control" name="id_cc">
        <?= $opciones_locales ?>
      </select>
    </div>
    <div class="col-md-3">
      <br>
      <div class="btn-group">
        <button class="btn btn-success" type="submit"> <i class="fa fa-search"> </i> Filtrar </button>
        <a class="btn btn-info" href="consolidado_atenciones.php" style="margin-left: 5px">Ver todo</a>
      </div>
    </div>
  </div>
</form>
<br>

<div class="row">
  <div class="col-md-6">
    <p class="text-center"> Atenciones: <?= $numRows_Atenciones ?></p>
    <table class="table table-bordered table-hover">
      <tbody>
        <tr>
          <td>
            Informe consolidado de atenciones (pdf)
          </td>
          <td width="80" class="text-center">
            <a href="consolidado_atenciones_pdf.php?id_conv=<?= $id_convenio ?>&f_de=<?= $_GET['f_de'] ?>&f_ha=<?= $_GET['f_ha'] ?>&id_cc=<?= $_GET['id_cc'] ?>" target="_blank">
              <i class="fa fa-file-pdf-o fa-lg"> </i>
            </a>
          </td>
        </tr>
        <tr>
          <td>
            Informe consolidado de atenciones (excel)
          </td>
          <td class="text-center">
            <a href="consolidado_atenciones_excel.php?id_conv=<?= $id_convenio ?>&f_de=<?= $_GET['f_de'] ?>&f_ha=<?= $_GET['f_ha'] ?>&id_cc=<?= $_GET['id_cc'] ?>">
              <i class="fa fa-file-excel-o fa-lg"> </i>
            </a>
          </td>
        </tr>
      </tbody>
    </table>
  </div>
</div>

<div class="row">
  <div class="col-md-6">
    <p class="text-center"> Atenciones con informe generado: <?= $numRows_AtencionesConInforme ?></p>
    <table class="table table-bordered table-hover">
      <tbody>
        <tr>
          <td id="zip">
            Comprimido de Informes de Resultados (zip)
          </td>
          <td class="text-center">
            <a id="zip_button" href="consolidado_atenciones_zip.php?id_conv=<?= $id_convenio ?>&f_de=<?= $_GET['f_de'] ?>&f_ha=<?= $_GET['f_ha'] ?>&id_cc=<?= $_GET['id_cc'] ?>" target="_blank">
              <i class="fa fa-file-archive-o fa-lg"> </i>
            </a>
          </td>
        </tr>
      </tbody>
    </table>
  </div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => sprintf($datos_pantallas[$pantalla_actual]['body_title'], $nbr_convenio),
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  var numeroResultados = "<?= $numRows_AtencionesConInforme ?>";
  $(document).ready(function() {
    numeroResultados = parseInt(numeroResultados);
    if (numeroResultados > 1000) {
      $("#zip_button").css("display", "none");
      $("#zip").css("color", "red");
      $("#zip").html("El numero de informes es mayor a 1000, Descarga no disponible <br> Elija un rango de fechas distinto");
    }
  })
</script>

<?php
include("../inc/google-analytics.php");
?>