<?php
define('PERMITIDO', true);
$pagina = 64;
include('../pdfClasses/class.ezpdf.php');
require_once("../inc/init.php");
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once('../lib/connection.php');
require_once("../lib/config.php");

$pdf = new Cezpdf('FOLIO');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(3.2, 1, 1, 1);
$pdf->ezStartPageNumbers(330, 18, 9, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);

$id_conv = isset($_GET['id_conv']) ? $_GET['id_conv'] : -1;
$id_cc   = isset($_GET['id_cc'])   ? $_GET['id_cc']   : -1;
$f_de = (isset($_GET['f_de']) && $_GET['f_de'] != "") ? $_GET['f_de'] : date('Y-m-d', strtotime('-1 week'));
$f_ha = (isset($_GET['f_ha']) && $_GET['f_ha'] != "") ? $_GET['f_ha'] : date('Y-m-d');
$filtro = (isset($_GET['idcc']) && $_GET['idcc'] != "") ? " AND a.ID_CENTRO_CONTACTO  = {$_GET['idcc']}" : "";

$qEmpresa = $mysqli->prepare("SELECT NBR FROM empresas WHERE ID_EMPRESA = ?");
$qEmpresa->bind_param('i', $id_conv);
$qEmpresa->execute();
$qEmpresa->bind_result($nbr_empresa);
$qEmpresa->store_result();
$qEmpresa->fetch();
$qEmpresa->close();

$qLocal = $mysqli->prepare("SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO = ?");
$qLocal->bind_param('i', $id_cc);
$qLocal->execute();
$qLocal->bind_result($nombre_local_filtro);
$qLocal->store_result();
$qLocal->fetch();
$qLocal->close();

$qAtencionesConvenio = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.FECHA_INF,
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.NRO_RUT, p.DV_RUT,
YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO) AS EDAD, 
(((YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(a.FECHA)-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
prev.NBR, cc.NOMBRE# , ea.COD_EXAMEN, ea.RESULTADO
FROM atenciones a
INNER JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA AND conv.ID_EMPRESA = ?
# INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION # AND ea.COD_EXAMEN = '00.00.069'
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
LEFT JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
WHERE (FECHA BETWEEN ? AND ?) AND FECHA_R IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro
ORDER BY ID_ATENCION DESC");
$qAtencionesConvenio->bind_param('iss', $id_conv, $f_de, $f_ha);
$qAtencionesConvenio->execute();
$qAtencionesConvenio->bind_result(
  $id_atencion,
  $fecha_atencion,
  $fecha_informe,
  $nombre_paciente,
  $nroRut_paciente,
  $dvRut_paciente,
  $edad,
  $edad_mes,
  $nbr_prevision,
  $nombre_local # , $cod_examen, $resultado
);
$qAtencionesConvenio->store_result();
$num_rows = $qAtencionesConvenio->num_rows;

$logo_empresa = imagecreatefrompng('../assets/img/logo_empresa_informes.png');
$glosa_convenio  = $_GET['id_conv'] != "" ? "Convenio: $nbr_empresa   " : "";
$glosa_local  = $_GET['id_cc'] != "" ? "Local: $nombre_local_filtro   " : "Local: TODOS   ";

$titles_at = [
  'fecha' => '<b>Fecha</b>',
  'atencion' => '<b>Atención</b>',
  'local' => '<b>Local</b>',
  'rut' => '<b>RUT</b>',
  'paciente' => '<b>Nombre</b>',
  'prevision' => '<b>Previsión</b>',
  # 'resultado' => '<b>Resultado</b>',
];

$data_at = [];
while ($qAtencionesConvenio->fetch()) {
  if ($cod_examen == "00.00.069") {
    $resultado = preg_split('/\r\n|\r|\n/', $resultado);
    $resultado = $resultado[0];
  }
  $data_at[] = [
    'fecha' => $fecha_atencion,
    'atencion' => $id_atencion,
    'local' => $nombre_local,
    'rut' => number_format($nroRut_paciente, '0', ',', '.') . '-' . $dvRut_paciente,
    'paciente' => $nombre_paciente,
    'prevision' => $nbr_prevision,
    # 'resultado' => $fecha_informe != "" ? $resultado : "PENDIENTE" # split para etcheverry que tiene resultados son textos largos con saltos de linea (fix pls)
  ];
}
$qAtencionesConvenio->close();

$options_at = [
  'shadeCol' => [0.9, 0.9, 0.9],
  'showLines' => 2,
  'shaded' => 0, # color de fila una por medio
  'xOrientation' => 'center',
  'innerLineThickness' => 0.5,
  'outerLineThickness' => 0.5,
  'maxWidth' => 570,
  'fontSize' => 8,
  'cols' => [
    'fecha' => ['justification' => 'left', 'width' => 55],
    'atencion' => ['justification' => 'left', 'width' => 50],
    'local' => ['justification' => 'left', 'width' => 75],
    'rut' => ['justification' => 'left', 'width' => 60],
    'paciente' => ['justification' => 'left', 'width' => 245],
    'prevision' => ['justification' => 'left', 'width' => 80],
    # 'resultado' => ['justification' => 'left', 'width' => 80]
  ]
];

$pdf->ezTable($data_at, $titles_at, "", $options_at);

# repetir pie de pagina en cada pagina
foreach ($pdf->ezPages as $pageNum => $id) {
  $pdf->reopenObject($id);
  $pdf->addImage($logo_empresa, 30, 875, 180, 50);
  $pdf->addText(20, 855, 9, $glosa_convenio . $glosa_local . "Rango de fechas: " . date("d/m/Y", strtotime($f_de)) . " - " . date("d/m/Y", strtotime($f_ha)));
  $pdf->addText(505, 855, 9, "N° Atenciones: " . $num_rows);
  $pdf->closeObject();
}

ob_end_clean();
$pdf->ezStream(['Content-Disposition' => 'Consolidado atenciones de ' . date("d-m-Y", strtotime($f_de)) . ' a ' . date("d-m-Y", strtotime($f_ha)) . '.pdf']);
