<?php
define('PERMITIDO', true);
# $pagina = 34;
require_once("../inc/init.php");
require_once '../assets/php/PHPExcel.php';

date_default_timezone_set("America/Santiago");

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

$obs = isset($_GET['obs']) ? $_GET['obs'] : "";
$fechaDesde = isset($_GET['f_desde'])  ? $_GET['f_desde']  : date('Y-m-d', strtotime('-1 week'));
$fechaHasta = isset($_GET['f_hasta']) ? $_GET['f_hasta'] : date('Y-m-d');
$filtro  = (isset($_GET['idpv']) && $_GET['idpv'] != "") ? " AND a.ID_PREVISION        = {$_GET['idpv']}" : "";
$filtro .= (isset($_GET['idcv']) && $_GET['idcv'] != "") ? " AND a.ID_CONVENIO         = {$_GET['idcv']}" : "";
$filtro .= (isset($_GET['idcc']) && $_GET['idcc'] != "") ? " AND a.ID_CENTRO_CONTACTO  = {$_GET['idcc']}" : "";
$filtro .= (isset($_GET['pp']) && $_GET['pp'] != "") ? " AND a.MONTO_ATENCION - (a.MONTO_CONDONADO + a.MONTO_PAGADO + a.MONTO_DESCUENTO + (a.MONTO_ATENCION * a.PCTJE_DESCUENTO / 100)) > 0" : "";
$filtro .= (isset($_GET['iduc']) && $_GET['iduc'] != "") ? " AND a.ID_USUARIO          = {$_GET['iduc']}" : "";
$filtro .= (isset($_GET['mpri']) && $_GET['mpri'] != "") ? " AND a.MOTIVO_PRIORIZACION = {$_GET['mpri']}" : "";
$filtro .= (isset($_GET['idmed']) && $_GET['idmed'] != "") ? " AND a.ID_MEDICO = {$_GET['idmed']}" : "";
$filtro .= (isset($_GET['obs'])  && $_GET['obs'] != "")   ? " AND a.OBS LIKE '%$obs%'" : "";

$stmt_atenciones = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, a.HORA, DATE_FORMAT(a.FECHA_TM,'%d/%m/%Y') AS FECHA_TM,
a.ID_COBRANZA_CONVENIO, a.OBS, a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO,
(a.MONTO_ATENCION - (a.MONTO_ATENCION*PCTJE_DESCUENTO / 100)) - a.MONTO_PAGADO - a.MONTO_DESCUENTO - a.MONTO_CONDONADO AS DEUDA,
p.NRO_RUT, p.DV_RUT, CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) AS PACIENTE, p.FONO_1, LOWER(p.MAIL) AS MAIL,
YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(a.FECHA)-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO) AS nombreMedico,
prev.NBR AS PREVISION,
conv.NBR AS CONVENIO,
cto.NOMBRE AS LOCAL,
CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO) as usuario_creador,
cg.DESCRIPCION_CG AS MOTPRIO
FROM atenciones a
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO = m.ID_PERSONA
LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
LEFT JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA
LEFT JOIN centros_contacto cto ON a.ID_CENTRO_CONTACTO = cto.ID_CENTRO_CONTACTO
LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
LEFT JOIN codigos_generales cg ON cg.CODIGO = a.MOTIVO_PRIORIZACION AND COD_TABLA = 'SIS_MOTPRIO'
WHERE a.FLAG_ELIMINADO = 0 AND (a.FECHA BETWEEN ? AND ?) $filtro
ORDER BY ID_ATENCION ASC");
$stmt_atenciones->bind_param('ss', $fechaDesde, $fechaHasta);
$stmt_atenciones->execute();
$result = $stmt_atenciones->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC);
$result->free();
$stmt_atenciones->close();

$columnasInicio = 'A';
$columnasFin = 'R';

$objPHPExcel->getActiveSheet()
	->setCellValue('A1', 'NRO. ATENCIÓN')
	->setCellValue('B1', 'FECHA')
	->setCellValue('C1', 'FECHA TOMA MUESTRA')
	->setCellValue('D1', 'LOCAL')
	->setCellValue('E1', 'RUT PACIENTE')
	->setCellValue('F1', 'NOMBRE PACIENTE')
	->setCellValue('G1', 'EDAD PACIENTE')
	->setCellValue('H1', 'PREVISIÓN')
	->setCellValue('I1', 'CONVENIO')
	->setCellValue('J1', 'MONTO ATENCIÓN')
	->setCellValue('K1', 'MONTO PAGADO')
	->setCellValue('L1', 'DESCUENTO / COPAGO')
	->setCellValue('M1', 'MONTO CONVENIO')
	->setCellValue('N1', 'DEUDA')
	->setCellValue('O1', 'MOTIVO PRIORIZACIÓN')
	->setCellValue('P1', 'TELÉFONO')
	->setCellValue('Q1', 'CORREO ELECTRÓNICO')
	->setCellValue('R1', 'OBSERVACIÓN');

$f = 2;
foreach ($rows as $row) {
	$edad = ($row['EDAD_MES'] < "12") ? $row['EDAD_MES'] . " MESES" : $row['EDAD'] . " AÑOS";
	$monto_convenio = $row['ID_COBRANZA_CONVENIO'] != "" ? $row['MONTO_CONVENIO'] . " (COBRADO)" : $row['MONTO_CONVENIO'];
	$objPHPExcel->getActiveSheet()->setCellValue('A' . $f, $row['ID_ATENCION']);
	$objPHPExcel->getActiveSheet()->setCellValue('B' . $f, $row['FECHA']);
	$objPHPExcel->getActiveSheet()->setCellValue('C' . $f, $row['FECHA_TM']);
	$objPHPExcel->getActiveSheet()->setCellValue('D' . $f, $row['LOCAL']);
	$objPHPExcel->getActiveSheet()->setCellValue('E' . $f, number_format($row['NRO_RUT'], '0', ',', '.') . '-' . $row['DV_RUT']);
	$objPHPExcel->getActiveSheet()->setCellValue('F' . $f, $row['PACIENTE']);
	$objPHPExcel->getActiveSheet()->setCellValue('G' . $f, $edad);
	$objPHPExcel->getActiveSheet()->setCellValue('H' . $f, $row['PREVISION']);
	$objPHPExcel->getActiveSheet()->setCellValue('I' . $f, $row['CONVENIO']);
	$objPHPExcel->getActiveSheet()->setCellValue('J' . $f, $row['MONTO_ATENCION']);
	$objPHPExcel->getActiveSheet()->setCellValue('K' . $f, $row['MONTO_PAGADO']);
	$objPHPExcel->getActiveSheet()->setCellValue('L' . $f, $row['MONTO_DESCUENTO']);
	$objPHPExcel->getActiveSheet()->setCellValue('M' . $f, $monto_convenio);
	$objPHPExcel->getActiveSheet()->setCellValue('N' . $f, $row['DEUDA']);
	$objPHPExcel->getActiveSheet()->setCellValue('O' . $f, $row['MOTPRIO']);
	$objPHPExcel->getActiveSheet()->setCellValue('P' . $f, $row['FONO_1']);
	$objPHPExcel->getActiveSheet()->setCellValue('Q' . $f, $row['MAIL']);
	$objPHPExcel->getActiveSheet()->setCellValue('R' . $f, $row['OBS']);
	$f++;
}

// Establecer tamaño automático de las columnas
for ($letra = $columnasInicio; $letra <= $columnasFin; $letra++) {
	$objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setAutoSize(true);
}

$fechaDesdeFormateada = date('d-m-Y', strtotime($fechaDesde));
$fechaHastaFormateada = date('d-m-Y', strtotime($fechaHasta));

header('Content-Disposition: attachment;filename="Atenciones ' . $fechaDesdeFormateada . ' a ' . $fechaHastaFormateada . '.xlsx"');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');

die();
