<?php
# $pagina = 24;
define('PERMITIDO', true);
require_once("../inc/init.php");
include('../pdfClasses/class.ezpdf.php');

$pdf = new Cezpdf('FOLIO');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezSetCmMargins(2, 1.5, 1, 1);
$pdf->ezStartPageNumbers(330, 18, 9, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);

date_default_timezone_set("America/Santiago");

$stmt = $mysqli->prepare("SELECT NBR FROM empresas WHERE ID_EMPRESA = ?");
$stmt->bind_param('i', $_GET["idpv"]);
$stmt->execute();
$result = $stmt->get_result();
$row_prevision = $result->fetch_assoc(); // Obtén la primera fila (única)
$result->free();
$stmt->close();

$stmt = $mysqli->prepare("SELECT NBR FROM empresas WHERE ID_EMPRESA = ?");
$stmt->bind_param('i', $_GET["idcv"]);
$stmt->execute();
$result = $stmt->get_result();
$row_convenio = $result->fetch_assoc(); // Obtén la primera fila (única)
$result->free();
$stmt->close();

$stmt = $mysqli->prepare("SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO = ?");
$stmt->bind_param('i', $_GET["idcc"]);
$stmt->execute();
$result = $stmt->get_result();
$row_centroContacto = $result->fetch_assoc(); // Obtén la primera fila (única)
$result->free();
$stmt->close();

$stmt = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) AS nombreUsuarioCreador FROM usuarios WHERE ID_USUARIO = ?");
$stmt->bind_param('i', $_GET["iduc"]);
$stmt->execute();
$result = $stmt->get_result();
$row_usuarioCreador = $result->fetch_assoc(); // Obtén la primera fila (única)
$result->free();
$stmt->close();

$obs = isset($_GET['obs']) ? $_GET['obs'] : "";
$fechaDesde = isset($_GET['f_desde'])  ? $_GET['f_desde']  : date('Y-m-d', strtotime('-1 week'));
$fechaHasta = isset($_GET['f_hasta']) ? $_GET['f_hasta'] : date('Y-m-d');
$filtro  = (isset($_GET['idpv']) && $_GET['idpv'] != "") ? " AND a.ID_PREVISION        = {$_GET['idpv']}" : "";
$filtro .= (isset($_GET['idcv']) && $_GET['idcv'] != "") ? " AND a.ID_CONVENIO         = {$_GET['idcv']}" : "";
$filtro .= (isset($_GET['idcc']) && $_GET['idcc'] != "") ? " AND a.ID_CENTRO_CONTACTO  = {$_GET['idcc']}" : "";
$filtro .= (isset($_GET['pp']) && $_GET['pp'] != "") ? " AND a.MONTO_ATENCION - (a.MONTO_CONDONADO + a.MONTO_PAGADO + a.MONTO_DESCUENTO + (a.MONTO_ATENCION * a.PCTJE_DESCUENTO / 100)) > 0" : "";
$filtro .= (isset($_GET['iduc']) && $_GET['iduc'] != "") ? " AND a.ID_USUARIO          = {$_GET['iduc']}" : "";
$filtro .= (isset($_GET['mpri']) && $_GET['mpri'] != "") ? " AND a.MOTIVO_PRIORIZACION = {$_GET['mpri']}" : "";
$filtro .= (isset($_GET['idmed']) && $_GET['idmed'] != "") ? " AND a.ID_MEDICO = {$_GET['idmed']}" : "";
$filtro .= (isset($_GET['obs'])  && $_GET['obs'] != "")   ? " AND a.OBS LIKE '%$obs%'" : "";

$stmt_atenciones = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, a.HORA, DATE_FORMAT(a.FECHA_TM,'%d/%m/%Y') AS FECHA_TM,
a.ID_COBRANZA_CONVENIO, a.OBS, a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO,
(a.MONTO_ATENCION - (a.MONTO_ATENCION*PCTJE_DESCUENTO / 100)) - a.MONTO_PAGADO - a.MONTO_DESCUENTO - a.MONTO_CONDONADO AS DEUDA,
p.NRO_RUT, p.DV_RUT, CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) AS PACIENTE, p.FONO_1, LOWER(p.MAIL) AS MAIL,
YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(a.FECHA)-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO) AS nombreMedico,
prev.NBR AS PREVISION,
conv.NBR AS CONVENIO,
cto.NOMBRE AS LOCAL,
CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO) as usuario_creador,
cg.DESCRIPCION_CG AS MOTPRIO
FROM atenciones a
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO = m.ID_PERSONA
LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
LEFT JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA
LEFT JOIN centros_contacto cto ON a.ID_CENTRO_CONTACTO = cto.ID_CENTRO_CONTACTO
LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
LEFT JOIN codigos_generales cg ON cg.CODIGO = a.MOTIVO_PRIORIZACION AND COD_TABLA = 'SIS_MOTPRIO'
WHERE a.FLAG_ELIMINADO = 0 AND (a.FECHA BETWEEN ? AND ?) $filtro
ORDER BY ID_ATENCION ASC");
$stmt_atenciones->bind_param('ss', $fechaDesde, $fechaHasta);
$stmt_atenciones->execute();
$result = $stmt_atenciones->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC);
$result->free();
$stmt_atenciones->close();

$g_prev = $_GET['idpv'] != "" ? "    Previsión: {$row_prevision['NBR']}" : "";
$g_conv = $_GET['idcv'] != "" ? "    Convenio: {$row_convenio['NBR']}" : "";
$g_cto  = $_GET['idcc'] != "" ? "    Local: {$row_centroContacto['NOMBRE']}" : "";
$g_uc   = $_GET['iduc'] != "" ? "    Usuario creador: {$row_usuarioCreador['nombreUsuarioCreador']}" : "";

$data_at = array();

foreach ($rows as $row) {
  $data_at[] = array(
    'fecha' => $row['FECHA'],
    'atencion' => $row['ID_ATENCION'],
    'local' => $row['LOCAL'],
    'paciente' => $row['PACIENTE'],
    'rut' => number_format($row['NRO_RUT'], '0', ',', '.') . "-" . $row['DV_RUT'],
    'prevision' => $row['PREVISION'],
    'convenio' => $row['CONVENIO'],
    'monto_atencion' => number_format($row['MONTO_ATENCION'], '0', ',', '.'),
    'descuento' => number_format($row['MONTO_DESCUENTO'], '0', ',', '.'),
    'monto_convenio' => number_format($row['MONTO_CONVENIO'], '0', ',', '.'),
    'pagado' => number_format($row['MONTO_PAGADO'], '0', ',', '.'),
    'deuda' => number_format($row['DEUDA'], '0', ',', '.'),
  );
}

$titles_at = array(
  'fecha' => '<b>Fecha</b>',
  'atencion' => '<b>N° Atención</b>',
  'local' => '<b>Local</b>',
  'paciente' => '<b>Paciente</b>',
  'rut' => '<b>RUT</b>',
  'prevision' => '<b>Previsión</b>',
  'convenio' => '<b>Convenio</b>',
  'monto_atencion' => '<b>Monto Atención</b>',
  'descuento' => '<b>Desc. / Copago</b>',
  'monto_convenio' => '<b>Monto Convenio</b>',
  'pagado' => '<b>Monto Pagado</b>',
  'deuda' => '<b>Deuda</b>'
);
$options_at = array(
  'shadeCol' => array(0.9, 0.9, 0.9),
  'showLines' => 2,
  'shaded' => 0,
  'xOrientation' => 'center',
  'innerLineThickness' => 0.5,
  'outerLineThickness' => 0.5,
  'maxWidth' => 570,
  'fontSize' => 6,
  'cols' => array(
    'fecha' => array('justification' => 'left', 'width' => 45),
    'atencion' => array('justification' => 'left', 'width' => 40),
    'local' => array('justification' => 'left', 'width' => 50),
    'paciente' => array('justification' => 'left', 'width' => 115),
    'rut' => array('justification' => 'left', 'width' => 50),
    'prevision' => array('justification' => 'left', 'width' => 40),
    'convenio' => array('justification' => 'left', 'width' => 40),
    'monto_atencion' => array('justification' => 'right', 'width' => 40),
    'descuento' => array('justification' => 'right', 'width' => 40),
    'monto_convenio' => array('justification' => 'right', 'width' => 40),
    'pagado' => array('justification' => 'right', 'width' => 40),
    'deuda' => array('justification' => 'right', 'width ' => 40),
  )
);

$pdf->ezText($g_prev . " " . $g_conv . " " . $g_cto . " " . $g_uc, 9);
$pdf->ezText("", 10);
$pdf->ezTable($data_at, $titles_at, '', $options_at);

# repetir pie de pagina en cada pagina
foreach ($pdf->ezPages as $pageNum => $id) {
  $pdf->reopenObject($id);
  # if($pageNum!=1) $pdf->addText(25,880,8,"<b>Informe número: </b>".$nro_ingreso, 0,0);	
  $pdf->addText(40, 910, 11, $cliente_nombreLaboratorio);
  $pdf->addText(40, 895, 9, "Desde: " . date("d/m/Y", strtotime($fechaDesde)) . " Hasta: " . date("d/m/Y", strtotime($fechaHasta)));
  $pdf->addText(40, 885, 9, "N° Atenciones: " . $num_rows);
  $pdf->closeObject();
}

ob_end_clean();
$pdf->ezStream();
