<?php
$pantalla_actual = 'DESC_ARCH';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$options_convenio = optionsConvenio($_GET["idcv"]);
$options_prevision = optionsPrevision($_GET["idpv"]);
$options_local = optionsLocal($_GET["idcc"]);

$opciones_motivoPriorizacion = optionsCodigosG("SIS_MOTPRIO", $_GET["mpri"]);
$options_turnoDialisis = optionsCodigosG("SIS_TURDIA", $_GET["idtd"]);

$options_tipoInforme = "<option value=''>--Seleccione--</option>";
$query = $mysqli->prepare("SELECT ID_TIPO_INFORME, NOMBRE, NOMBRE_ARCHIVO_PDF, NOMBRE_ARCHIVO_EXCEL
FROM tipos_informe
# WHERE PERFIL = 'SECRETARIA' AND ACTIVO = 'S'
ORDER BY NOMBRE ASC");
$query->execute();
$query->bind_result($id, $nombre, $urlPdf, $urlExcel);
while ($query->fetch()) {
    $selected = $id == $_GET['ti'] ? 'selected' : '';
    $options_tipoInforme .= "<option $selected value='$id' data-pdf='$urlPdf' data-excel='$urlExcel'> $nombre </option>";
}
$query->close();

$options_usuarioCreador = "<option value=''>--Seleccione--</option>";
$query = $mysqli->prepare("SELECT ID_USUARIO, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) as nombre_usuario
FROM usuarios
WHERE PERFIL = 'SECRETARIA' AND ACTIVO = 'S'
ORDER BY nombre_usuario ASC");
$query->execute();
$query->bind_result($u_idUsuario, $u_nombreUsuario);
while ($query->fetch()) {
    $selected = $u_idUsuario == $_GET['iduc'] ? 'selected' : '';
    $options_usuarioCreador .= "<option value='$u_idUsuario' $selected> $u_nombreUsuario </option>";
}
$query->close();

$options_medico = "<option value=''>--Seleccione--</option>";
$query = $mysqli->prepare("SELECT ID_PERSONA, CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO) as nombre_usuario
FROM personas
WHERE FLAG_MEDICO = 'S' AND FLAG_ELIMINADO IS NULL
ORDER BY nombre_usuario ASC");
$query->execute();
$query->bind_result($idmed, $nombreMedico);
while ($query->fetch()) {
    $selected = $idmed == $_GET['idmed'] ? 'selected' : '';
    $options_medico .= "<option value='$idmed' $selected> $nombreMedico </option>";
}
$query->close();

$f_desde = date('Y-m-d', strtotime('-1 week'));
$f_hasta = date('Y-m-d');

ob_start();
?>

<p class="font-md">Filtros para exportación de informes:</p>
<form id="formFiltros" method="get" class="smart-form">
    <div class="row">
        <section class="col col-2">
            <label>Fecha desde</label>
            <label class="input">
                <input type="date" name="f_desde" class="form-control" value="<?= $f_desde ?>" />
                <i></i>
            </label>
        </section>
        <section class="col col-2">
            <label>Fecha hasta</label>
            <label class="input">
                <input type="date" name="f_hasta" class="form-control" value="<?= $f_hasta ?>" />
                <i></i>
            </label>
        </section>
        <section class="col col-2">
            <label>Previsión</label>
            <select name="idpv" class="select2" style="width:100%">
                <?= $options_prevision ?>
            </select>
        </section>
        <section class="col col-2">
            <label>Convenio</label>
            <select name="idcv" class="select2" style="width:100%">
                <?= $options_convenio ?>
            </select>
        </section>
        <section class="col col-2">
            <label>Local</label>
            <select name="idcc" class="select2" style="width:100%">
                <?= $options_local ?>
            </select>
        </section>
        <section class="col col-2">
            <br>
            Pendiente de Pago &nbsp;&nbsp; <input name="pp" type="checkbox" value="1" <?= $_GET['pp'] != "" ? 'checked' : '' ?> />
        </section>
    </div>
    <div class="row">
        <section class="col col-2">
            <label>Médico</label>
            <select name="idmed" class="select2" style="width:100%">
                <?= $options_medico ?>
            </select>
        </section>
        <section class="col col-2">
            <label>Motivo Priorización</label>
            <select name="mpri" class="select2" style="width:100%">
                <?= $opciones_motivoPriorizacion ?>
            </select>
        </section>
        <section class="col col-2">
            <label>Usuario creador</label>
            <select name="iduc" class="select2" style="width:100%">
                <?= $options_usuarioCreador ?>
            </select>
        </section>
        <section class="col col-2">
            <label>Observaciones</label>
            <label class="input">
                <input name="obs" value="<?= isset($_GET['obs']) ? $_GET['obs'] : '' ?>" class="form-control" placeholder="..." />
                <i></i>
            </label>
        </section>
        <section class="col col-2">
            <label>Turno de Diálisis</label>
            <select name="idtd" class="select2" style="width:100%">
                <?= $options_turnoDialisis ?>
            </select>
        </section>
    </div>
    <div class="row">
        <section class="col col-2">
            <label>Fecha Resultado PNTM</label>
            <label class="input">
                <input type="date" name="f_er" class="form-control" />
                <i></i>
            </label>
        </section>
        <section class="col col-2">
            <br>
            Notificado en PNTM &nbsp;&nbsp; <input name="pntm" type="checkbox" value="1" <?= $_GET['pntm'] != "" ? 'checked' : '' ?> />
        </section>
    </div>
</form>
<br>
<p class="font-md">Número de atenciones filtradas: <span id="nro_atenciones">-</span></p>
<br>
<div class="row">
    <section class="col-md-6">
        <label>Tipo de informe</label>
        <select id="tipo_informe" name="ti" class="select2" style="width:100%">
            <?= $options_tipoInforme ?>
        </select>
    </section>
</div>
<br>
<div class="btn-group" role="group">
    <a disabled class="btn btn-default btn-exportarPdf" target="_blank" style="margin-right: 2rem;"> <i class="fa fa-lg fa-file-pdf-o"></i> Exportar en PDF </a>
    <a disabled class="btn btn-default btn-exportarExcel" target="_blank" style="margin-right: 2rem;"> <i class="fa fa-lg fa-file-excel-o"></i> Exportar en Excel </a>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
    'toolbar' => ''
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
    <?php
    include("../inc/ribbon.php");
    ?>
    <div id="content">
        <?php
        $widget->print_html();
        ?>
    </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
    function filrarAtencionesInforme(formData) {
        $('.btn-exportarPdf').attr('disabled', 'disabled');
        $('.btn-exportarExcel').attr('disabled', 'disabled');
        $('#nro_atenciones').text("Cargando...");

        $.ajax({
            url: 'ajax_generarInforme.php',
            type: 'GET',
            dataType: 'json',
            data: formData,
            success: function(response) {
                $('#nro_atenciones').text(response);

                var pdfButton = $('.btn-exportarPdf');
                var excelButton = $('.btn-exportarExcel');

                var formParams = $.param(formData); // Obtener todos los campos del formulario y sus valores
                var tipoInformeValue = $('#tipo_informe').val();

                if (tipoInformeValue != "") { // Validación para que no se activen los botones sin que haya un tipo de informe elegido
                    $('.btn-exportarPdf').removeAttr('disabled');
                    $('.btn-exportarExcel').removeAttr('disabled');
                    
                    // Agregar los parámetros al atributo href de los botones
                    pdfButton.attr('href', pdfButton.attr('href').split('?')[0] + '?' + formParams);
                    excelButton.attr('href', excelButton.attr('href').split('?')[0] + '?' + formParams);

                    // Agregar los parámetros al atributo href de los botones
                    pdfButton.removeAttr('disabled');
                    excelButton.removeAttr('disabled');
                }
            },
            error: function(error) {
                console.error(error);
                console.error(error.responseText); // Muestra la respuesta del servidor en caso de error
            }
        });
    }


    $(document).ready(function() {
        var formData = $('#formFiltros').serializeArray();
        filrarAtencionesInforme(formData);

        $('#formFiltros input, #formFiltros select').on('change', function() {
            var formData = $('#formFiltros').serializeArray();
            console.log(formData);
            filrarAtencionesInforme(formData);
        });

        $('#tipo_informe').change(function() {
            var tipoInformeValue = $(this).val(); // Obtener el value seleccionado

            // Obtener todos los campos del formulario
            var formParams = $.param($('#formFiltros').serializeArray());

            if (tipoInformeValue !== '') {
                $('.btn-exportarPdf').removeAttr('disabled');
                $('.btn-exportarExcel').removeAttr('disabled');
            } else {
                $('.btn-exportarPdf').attr('disabled', 'disabled');
                $('.btn-exportarExcel').attr('disabled', 'disabled');
            }

            var selectedOption = $(this).find('option:selected'); // Obtener los datos del elemento seleccionado
            var urlPdf = selectedOption.data('pdf');
            var urlExcel = selectedOption.data('excel');

            // Agregar parámetros del formulario a los enlaces de los botones
            if (urlPdf) {
                $('.btn-exportarPdf').attr('href', urlPdf + '?' + formParams);
                $('.btn-exportarPdf').css("text-decoration", "none");
            } else {
                $('.btn-exportarPdf').attr('disabled', 'disabled');
                $('.btn-exportarPdf').css("text-decoration", "line-through");
            }

            if (urlExcel) {
                $('.btn-exportarExcel').attr('href', urlExcel + '?' + formParams);
                $('.btn-exportarExcel').css("text-decoration", "none");
            } else {
                $('.btn-exportarExcel').attr('disabled', 'disabled');
                $('.btn-exportarExcel').css("text-decoration", "line-through");
            }
        });

        $(".select2-hidden-accessible").hide();
    });
</script>

<?php include("../inc/google-analytics.php"); ?>