<?php
define('PERMITIDO', true);
$pagina = 34;
require('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");
/** Include PHPExcel */
require_once '../assets/php/PHPExcel.php';


/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
// ini_set("memory_limit","512M");
// ini_set('max_execution_time', 20);


if (PHP_SAPI == 'cli')
  die('This file should only be run from a Web Browser');
// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
// Set document properties
$objPHPExcel->getProperties()->setCreator("RIPIT Chile.")
  ->setLastModifiedBy("RIPIT Chile.")
  ->setTitle("Resultados Examenses Excel")
  ->setSubject("Resultados Examenses Excel")
  ->setDescription("Resultados Examenses")
  ->setKeywords("Resultados Examenses")
  ->setCategory("Reporte Resultados Examenses");


//////////////////////////////////////////////////////////////////////////
////////////////////////     CONSULTAS      //////////////////////////////

$f_desde = "";
$f_hasta = "";
$f_in = "";
$f_er = "";
$f_pv = "";
$f_cv = "";
$f_cc = "";
$f_td = "";
$f_minsal = "";
$f_rev = "";

if (isset($_GET['f_desde']) && $_GET['f_desde'] != "") $f_desde = " AND a.FECHA >= '{$_GET['f_desde']}'";
if (isset($_GET['f_hasta']) && $_GET['f_hasta'] != "") $f_hasta = " AND a.FECHA <= '{$_GET['f_hasta']}'";
if (isset($_GET['f_in']) && $_GET['f_in'] != "") $f_in = " AND a.FECHA_INF = '{$_GET['f_in']}'";
if (isset($_GET['f_er']) && $_GET['f_er'] != "") $f_er = " AND DATE(t.FECHA_HORA_ENTREGA_RESULTADO) = '{$_GET['f_er']}'";
if (isset($_GET['idpv']) && $_GET['idpv'] != "") $f_pv = " AND a.ID_PREVISION = {$_GET['idpv']}";
if (isset($_GET['idcv']) && $_GET['idcv'] != "") $f_cv = " AND a.ID_CONVENIO = {$_GET['idcv']}";
if (isset($_GET['idcc']) && $_GET['idcc'] != "") $f_cc = " AND a.ID_CENTRO_CONTACTO = {$_GET['idcc']}";
if (isset($_GET['idtd']) && $_GET['idtd'] != "") $f_td = " AND a.TURNO_DIALISIS = {$_GET['idtd']}";
if (isset($_GET['pntm']) && $_GET['pntm'] != "") $f_minsal = " AND t.ID_TOMA_DE_MUESTRA IS NOT NULL";
if (!isset($_GET['rev'])) $f_rev = " AND ea.RESULTADO IS NOT NULL";

$query = "SELECT CONCAT('', p.NRO_RUT, p.DV_RUT), p.PASAPORTE, CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.GENERO, p.FECHA_NACIMIENTO,
IFNULL(cg.DESCRIPCION_CG, 'Desconocido'), ea.RESULTADO, DATE_FORMAT(a.FECHA_TM, '%d-%m-%Y'), DATE_FORMAT(a.FECHA_R, '%d-%m-%Y'), DATE_FORMAT(ea.FECHA_VAL, '%d-%m-%Y'), 
p.FONO_1, p.MAIL, p.DIRECCION, cg_2.DESCRIPCION_CG, CONCAT('', m.NRO_RUT, m.DV_RUT), CONCAT_WS(' ', m.NOMBRES, m.APELLIDO_PATERNO, m.APELLIDO_MATERNO), m.FONO_1, a.ID_ATENCION, a.OBS, e.NBR, prev.NOMBRE_E
FROM atenciones a
LEFT JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
LEFT JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN personas m ON a.ID_MEDICO = m.ID_PERSONA
LEFT JOIN codigos_generales cg ON cg.COD_TABLA = 'SIS_TIPMUE' AND cg.CODIGO = ex.TIPO_MUESTRA
LEFT JOIN codigos_generales cg_2 ON cg_2.COD_TABLA = 'SIS_COMUN' AND cg_2.CODIGO = p.COMUNA
LEFT JOIN empresas e ON a.ID_CONVENIO = e.ID_EMPRESA
LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
LEFT JOIN toma_de_muestras_minsal t ON t.ID_ATENCION = a.ID_ATENCION
WHERE a.FLAG_ELIMINADO = 0 AND ex.COD_INTERNO = '00.00.069' $f_desde $f_hasta $f_in $f_er $f_cv $f_pv $f_cc $f_rev $f_td $f_minsal
ORDER BY a.ID_ATENCION DESC";
$qresultados = $mysqli->prepare($query);
echo $mysqli->error;
$qresultados->execute();
$qresultados->bind_result(
  $rut,
  $pasaporte,
  $nombre,
  $sexo,
  $fecha_nacimiento,
  $tipo_muestra,
  $resultado,
  $f_tm,
  $f_recepcion,
  $f_resultado,
  $telefono,
  $correo,
  $direccion,
  $comuna,
  $rut_medico,
  $nombre_medico,
  $telefono_medico,
  $id_atencion,
  $observaciones,
  $convenio,
  $prevision
);
$qresultados->store_result();
$num_rows = $qresultados->num_rows;

/******************************************************************************************************************************************************************************/
/******************************************************************************************************************************************************************************/
/******************************************************************************************************************************************************************************/

////////////////////////   PARA QUE SE ACOMODE EL WIDTH DE LAS COLUMNAS    //////////////////////////////

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);

////////////////////////     $styleArray ESTILO PARA LA CABECERA    //////////////////////////////
$styleArray =
  array(
    'font'  => array(
      'bold'  => true,
      'color' => array('rgb' => 'FFFFFF'),
      'size'  => 11
      //'name'  => 'Verdana'
    ),
    'fill' => array(
      'type' => PHPExcel_Style_Fill::FILL_SOLID,
      'color' => array('rgb' => '4F81BD')
    ),
    'alignment' => array(
      'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
      'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    ),
    'borders' => array(
      'allborders' => array(
        'style' => PHPExcel_Style_Border::BORDER_THIN
      )
    )
  );

$objPHPExcel->getActiveSheet()->getStyle('A1:X1')->applyFromArray($styleArray);

$aux = $num_rows + 1;
$objPHPExcel->getActiveSheet()
  ->getStyle('A2:' . 'X' . $aux)
  ->getNumberFormat()
  ->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

////////////////////////     ESCRITURA EN CELDAS      //////////////////////////////

$objPHPExcel->setActiveSheetIndex(0)
  ->setCellValue('A1', "RUN")
  ->setCellValue('B1', "Nombre")
  ->setCellValue('C1', "Sexo")
  ->setCellValue('D1', "Edad")
  ->setCellValue('E1', "Tipo Muestra")
  ->setCellValue('F1', "Resultado")
  ->setCellValue('G1', "Fecha de toma de\nmuestra")
  ->setCellValue('H1', "Fecha de\nrecepcion de la\nmuestra")
  ->setCellValue('I1', "Fecha de\nresultado")
  ->setCellValue('J1', "Hospital o establecimiento de origen\n(lugar donde se toma la muestra)")
  ->setCellValue('K1', "Región de\nestablecimiento de origen")
  ->setCellValue('L1', "Laboratorio de referencia (lugar\ndonde se procesa la muestra)")
  ->setCellValue('M1', "Región de laboratorio\ndonde se procesa la\nmuestra")
  ->setCellValue('N1', "Teléfono\nde contacto de\npaciente")
  ->setCellValue('O1', "Correo de\ncontacto de\npaciente")
  ->setCellValue('P1', "Dirección\nde contacto de\npaciente")
  ->setCellValue('Q1', "Comuna")
  ->setCellValue('R1', "RUN del médico")
  ->setCellValue('S1', "Nombre del médico")
  ->setCellValue('T1', "Teléfono\nde contacto del\nmédico")
  ->setCellValue('U1', "Convenio")
  ->setCellValue('V1', "Número de \nAtención")
  ->setCellValue('W1', "Observaciones")
  ->setCellValue('X1', "Previsión");

// PARA ALINEAR CON LOS SALTOS DE LINEA
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('B1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('C1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('E1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('F1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('G1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('H1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('I1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('J1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('K1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('L1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('M1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('N1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('O1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('P1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('Q1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('R1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('S1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('T1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('U1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('V1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('W1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('X1')->getAlignment()->setWrapText(true);


//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A2', $num_rows);
$f = 2;
while ($qresultados->fetch()) {

  if ($sexo == "M") $sexo = "H";
  elseif ($sexo == "F") $sexo = "M";
  else $sexo = "No identificado";

  $DT_fecha_nacimiento = new DateTime($fecha_nacimiento);
  $DT_hoy = new Datetime(date('y-m-d'));
  $diff = $DT_hoy->diff($DT_fecha_nacimiento);
  if ($diff->y != 0) $edad = $diff->y;
  elseif ($diff->m != 0) $edad = $diff->m . " meses";
  elseif ($diff->d != 0) $edad = $diff->d . " días";

  $resultado = preg_split('/\r\n|\r|\n/', $resultado);

  $identificación_paciente = ($pasaporte === null) ? $rut : 'P' . $pasaporte;

  $objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A' . $f, $identificación_paciente)
    ->setCellValue('B' . $f, $nombre)
    ->setCellValue('C' . $f, $sexo)
    ->setCellValue('D' . $f, $edad)
    ->setCellValue('E' . $f, $tipo_muestra)
    ->setCellValue('F' . $f, $resultado[0])
    ->setCellValue('G' . $f, $f_tm)
    ->setCellValue('H' . $f, $f_recepcion)
    ->setCellValue('I' . $f, $f_resultado)
    ->setCellValue('N' . $f, $telefono)
    ->setCellValue('O' . $f, $correo)
    ->setCellValue('P' . $f, $direccion)
    ->setCellValue('Q' . $f, $comuna)
    ->setCellValue('R' . $f, $rut_medico)
    ->setCellValue('S' . $f, $nombre_medico)
    ->setCellValue('T' . $f, $telefono_medico)
    ->setCellValue('U' . $f, $convenio)
    ->setCellValue('V' . $f, $id_atencion)
    ->setCellValue('W' . $f, $observaciones)
    ->setCellValue('X' . $f, $prevision);
  $f++;
}
$qresultados->close();


//////////////////////////////////////////////////////////////////////////

// PHPExcel_Settings::(PHPExcel_Settings::PCLZIP);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Planilla');
// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');

// header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); # Para xlsx, no funciona en servidor

header('Content-Disposition: attachment;filename="PLANILLA_PCR_COVID_19.xls"');
header('Cache-Control: max-age=0');

// // If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->setPreCalculateFormulas(false);
$objWriter->save('php://output');
exit();
