<?php
$pagina = 1;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');

ini_set('memory_limit', '512M');

$titulo = 'Laboratorio Central<br>Arlegui 440 - Oficina 218<br>Viña del Mar<br>Fono: 32-2714189';
$firma = 'QF Andoni Etcheverry<br>Director Técnico';

$nombre_centro_contacto = '';
if ($_GET['idcc'] != '') {
	$centro_contacto = $mysqli->prepare("SELECT NOMBRE from centros_contacto WHERE ID_CENTRO_CONTACTO = ?");
	$centro_contacto->bind_param('i', $_GET['idcc']);
	$centro_contacto->execute();
	$centro_contacto->bind_result($nombre_centro_contacto);
	$centro_contacto->store_result();
	$centro_contacto->fetch();
	$centro_contacto->close();
}

$nombre_turno_dialisis = '';
if ($_GET['idtd'] != '') {
	$turno_dialisis = $mysqli->prepare("SELECT DESCRIPCION_CG from codigos_generales WHERE CODIGO = ? AND COD_TABLA = 'SIS_TURDIA'");
	$turno_dialisis->bind_param('i', $_GET['idtd']);
	$turno_dialisis->execute();
	$turno_dialisis->bind_result($nombre_turno_dialisis);
	$turno_dialisis->store_result();
	$turno_dialisis->fetch();
	$turno_dialisis->close();
}

$fi = (isset($_GET['f_desde'])) ? $_GET['f_desde'] : date('Y-m-d', strtotime('-1 week'));
$ft = (isset($_GET['f_hasta'])) ? $_GET['f_hasta'] : date('Y-m-d');
$f_prev = ($_GET['idpv'] != '') ? " AND a.ID_PREVISION = {$_GET['idpv']}" : "";
$f_conv = ($_GET['idcv'] != '') ? " AND a.ID_CONVENIO = {$_GET['idcv']}" : "";
$f_cto = ($_GET['idcc'] != '')  ? " AND a.ID_CENTRO_CONTACTO = {$_GET['idcc']}" : "";
$f_turdia = ($_GET['idtd'] != "") ? " AND a.TURNO_DIALISIS = {$_GET['idtd']}" : "";

$stmt_atenciones = $mysqli->prepare("SELECT DATE_FORMAT(FECHA_R,'%d/%m/%Y'), cg.DESCRIPCION_CG, a.HORA_R, a.ID_ATENCION,
CONCAT_WS(' ', pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO) AS paciente, obsr.OBS
FROM atenciones a
LEFT JOIN codigos_generales cg ON a.TURNO_DIALISIS = cg.CODIGO AND cg.COD_TABLA='SIS_TURDIA'
INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
LEFT JOIN obs_resultados obsr ON a.ID_ATENCION = obsr.ID_ATENCION
WHERE (a.FECHA BETWEEN ? AND ?) AND a.FLAG_ELIMINADO = 0 AND FECHA_R IS NOT NULL $f_prev $f_conv $f_cto $f_turdia 
ORDER BY a.FECHA_R, HORA_R");
echo $mysqli->error;
$stmt_atenciones->bind_param('ss', $fi, $ft);
$stmt_atenciones->execute();
$stmt_atenciones->bind_result($at_fecha, $at_turno_dialisis, $at_hora, $at_idAtencion, $at_paciente, $at_obs);
$stmt_atenciones->store_result();
$nroAtenciones = $stmt_atenciones->num_rows;

class ResultadosDialisis extends TCPDF
{
	public function Header()
	{
		global $titulo;
		global $nombre_centro_contacto;
		global $nombre_turno_dialisis;
		global $nroAtenciones;
		$this->SetFont('times', '', 10);

		if ($nombre_centro_contacto != '') $this->writeHTMLCell('150', '', 120, 10, 'Centro de Toma de Muestras: ' . $nombre_centro_contacto, 0, 1, 0, true, 'L', true);

		$label = $nombre_turno_dialisis != "" ? $nombre_turno_dialisis : "Todos";
		$this->writeHTMLCell('150', '', 120, 20, "Turno de Diálisis: $label<br>N° de Atenciones: $nroAtenciones", 0, 1, 0, true, 'L', true);
		$this->writeHTMLCell('50', '', 230, 10, $titulo, 0, 1, 0, true, 'C', true);

		$this->setImageScale(2);
		$this->setJPEGQuality(100);
		$this->Image('logo.jpg', '10', '10');
	}

	public function Footer()
	{
		global $firma;
		$this->SetFont('times', '', 10);

		$this->writeHTMLCell('50', '', 230, 180, $firma, 0, 1, 0, true, 'C', true);
		$paginas = "Página " . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
		$this->setImageScale(2.5);
		$this->setJPEGQuality(100);
		$this->Image('firma.jpg', '235', '160');
	}
}

$pdf = new ResultadosDialisis('L', 'mm', 'letter', true, 'UTF-8', false);

$examenesDeInforme = array(
	"01.01.036" => "HEMA",
	"01.01.038" => "HEMO",
	"02.02.323" => "POT",
	"02.02.322" => "SOD",
	"02.02.157" => "NU PRE",
	"02.02.557" => "NU POST",
	"02.02.057" => "U PRE",
	"02.02.576" => "U POST",
	"02.02.023" => "CREA",
	"02.02.047" => "GLUC",
	"02.02.015" => "CAL",
	"02.02.042" => "FOSF",
	"02.02.631" => "GOT",
	"02.02.632" => "GPT",
	"02.02.040" => "FALC",
	"02.02.261" => "ALB",
	"02.02.046" => "BIC",
	"02.02.067" => "COL",
	"02.02.064" => "TRIG",
	// "05.06.077" => "HEPB",
	// "05.06.081" => "HEPC",
	// "11.06.169" => "VIH",
	// "04.01.026" => "FERRI",
	// "04.03.018" => "PARAT",
	"04.01.028" => "FIE",
	"04.01.128" => "SAT",
	"04.01.228" => "TIBC"
);


$pdf->SetMargins(5, 35, 5);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 60);
$pdf->setFontSubsetting(true);
$fontSize = 8;
$pdf->SetFont('times', '', $fontSize);

$tableHeaders = '';
foreach ($examenesDeInforme as $valor) {
	$tableHeaders .= '<th style="width:3.5%">' . $valor . '</th>';
}

while ($stmt_atenciones->fetch()) {
	$resultadosAtencion = []; // Array para almacenar los resultados de los exámenes de esta atención

	$stmt_examenesAtencion = $mysqli->prepare("SELECT ea.COD_EXAMEN, ex.NOMBRE, RESULTADO, cg.DESCRIPCION_CG, N_DECIMALES
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN = ex.COD_INTERNO
	INNER JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA = cg.CODIGO AND cg.COD_TABLA = 'SIS_UNIMED'
	WHERE ID_ATENCION = ?");
	$stmt_examenesAtencion->bind_param('i', $at_idAtencion);
	$stmt_examenesAtencion->execute();
	$stmt_examenesAtencion->bind_result($ex_codExamen, $ex_nombre, $ex_resultado, $ex_unidad, $ex_ndecimales);
	$stmt_examenesAtencion->store_result();

	while ($stmt_examenesAtencion->fetch()) {
		// Verificar si el examen actual está en la lista $examenesDeInforme
		if (array_key_exists($ex_codExamen, $examenesDeInforme) && is_numeric($ex_resultado)) {
			$nro_decimales = ($ex_ndecimales != "") ? $ex_ndecimales : 2;
			$ex_resultado = number_format($ex_resultado, $nro_decimales, ',', '.');
			// Agregar el resultado al array de resultados de esta atención
			$resultadosAtencion[$examenesDeInforme[$ex_codExamen]] = $ex_resultado;
		}
	}
	$stmt_examenesAtencion->close();

	// Agregar esta atención y sus resultados a la lista de resultados
	$resultados[] = [
		'at_fecha' => $at_fecha,
		'at_idAtencion' => $at_idAtencion,
		'at_paciente' => $at_paciente,
		'resultados' => $resultadosAtencion // Almacenar los resultados de los exámenes relevantes
	];
}

// Construir las filas de la tabla
foreach ($resultados as $resultado) {
	$tableRows .= '<tr>';
	$tableRows .= '<td style="width:5%">' . $resultado['at_fecha'] . '</td>';
	$tableRows .= '<td style="width:4%">' . $resultado['at_idAtencion'] . '</td>';
	$tableRows .= '<td style="width:14%; text-align:left">' . $resultado['at_paciente'] . '</td>';
	// Agregar los resultados de los exámenes relevantes
	foreach ($examenesDeInforme as $clave => $valor) {
		$tableRows .= '<td style="width:3.5%">' . (isset($resultado['resultados'][$valor]) ? $resultado['resultados'][$valor] : '') . '</td>';
	}
	$tableRows .= '</tr>';
}

$table =
	'<table border="1" cellpadding="2" style="text-align: center">
	<thead>
		<tr>
			<th style="width:5%">FECHA RECEP.</th>
			<th style="width:4%">N° ATE</th>
			<th style="width:14%">PACIENTE</th>
			' . $tableHeaders . '
			</tr>
	</thead>
	<tbody>
		' . $tableRows . '
	</tbody>
</table>';

$pdf->AddPage();
$pdf->writeHTML($table, true, false, false, false, '');

ob_end_clean();
$pdf->Output('resultados_dialisis_1.pdf', 'I');
