<?php
$pantalla_actual = 'CON_ATE_LOC';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qUsuario = $mysqli->prepare("SELECT u.ID_CENTRO_COSTOS, cc.NOMBRE
FROM usuarios u
INNER JOIN centros_contacto cc ON u.ID_CENTRO_COSTOS = cc.ID_CENTRO_CONTACTO
WHERE ID_USUARIO = ?");
$qUsuario->bind_param("i", $usuario_id);
$qUsuario->execute();
$qUsuario->bind_result($id_ccto, $nombre_ccto);
$qUsuario->store_result();
$qUsuario->fetch();
$qUsuario->close();

$filtro = '';
//filtro por nombre, rut
if ((isset($_GET['busq'])) && ($_GET['busq'] != "")) {
  $busqueda = str_replace('.', '', $_GET['busq']);
  $filtro = "AND (a.ID_ATENCION = '$busqueda' OR CONCAT_WS(' ',p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) LIKE '%$busqueda%' OR p.NRO_RUT = '$busqueda')";
}

$cant_reg = 100;    //Limito la busqueda
$inicio = 0;
$pagina = 1;
if (isset($_GET["pag"])) { //examino la página a mostrar y el inicio del registro a mostrar
  $pagina = $_GET["pag"];
  $inicio = ($pagina - 1) * $cant_reg;
}

/* Consulta para saber total de paginas */
if (isset($_GET['tpag'])) {
  $total_paginas = $_GET['tpag'];
} else {
  $consultaTotal = "SELECT a.ID_ATENCION
  FROM atenciones a
  LEFT JOIN personas p ON a.ID_CLIENTE=p.ID_PERSONA
  WHERE a.ID_CENTRO_CONTACTO = ? AND a.FLAG_ELIMINADO = 0 $filtro";
  $qtotal = $mysqli->prepare($consultaTotal);
  echo $mysqli->error;
  $qtotal->bind_param('i', $id_ccto);
  $qtotal->execute();
  $qtotal->store_result();
  $totalRows_total = $qtotal->num_rows;
  $qtotal->close();
  $total_paginas = ceil($totalRows_total / $cant_reg);
}

$consulta = "SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d-%m-%Y'), CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), cto.NOMBRE, NRO_RUT, DV_RUT, FECHA_INF
FROM atenciones a
LEFT JOIN personas p ON a.ID_CLIENTE=p.ID_PERSONA
LEFT JOIN centros_contacto cto ON a.ID_CENTRO_CONTACTO=cto.ID_CENTRO_CONTACTO
WHERE a.ID_CENTRO_CONTACTO = ? AND a.FLAG_ELIMINADO = 0 $filtro
ORDER BY ID_ATENCION DESC
LIMIT ?, ?";
$qAtenciones = $mysqli->prepare($consulta);
$qAtenciones->bind_param('iii', $id_ccto, $inicio, $cant_reg);
$qAtenciones->execute();
$qAtenciones->bind_result($at_id, $at_fecha, $at_nombre, $at_local, $at_nroRut, $at_dvRut, $at_fechaInf);
$qAtenciones->store_result();
$totalRows_atenciones = $qAtenciones->num_rows;

ob_start();
?>

<form id="formBuscar" name="formBuscar" method="get" action="" class="smart-form">
  <table class="table table-responsive">
    <tr>
      <td align="left" style="width:6em;">
        <h5>Busqueda:</h5>
      </td>
      <td style="width:16em;">
        <label class="input">
          <input type="search" name="busq" class="input-sm" autofocus="autofocus" placeholder="Atención, Nombre, RUT, Local" value="<?php if (isset($_GET['busq'])) echo $_GET['busq'] ?>" />
        </label>
      </td>
      <td style="width:6em;">
        <a id="buscar" class="btn btn-link" title=""><i class="fa fa-search fa-lg"></i></a>
      </td>
      <td style="width:6em;">
        <a class="btn btn-info btn-sm" tittle="Ver Todo" onclick="location.href='l_atenciones.php'"> Ver Todo </a>
      </td>
      <td>
        <div class="text-right"><?php if ($total_paginas > 1) echo paginacion('l_atenciones.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina, 2, 2) ?></div>
      </td>
    </tr>
  </table>
</form>

<style>
  .popover {
    max-width: 500px;
    line-height: 150%;
  }
</style>

<table class="table table-bordered table-hover">
  <thead>
    <tr>
      <th>Nro Atención</th>
      <th>Fecha</th>
      <th>Rut</th>
      <th>Paciente</th>
      <th width="120" align="center">Informe</th>
      <th width="120" align="center">Estado Exámenes</th>
      <th width="120" align="center">Detalle</th>
    </tr>
  </thead>
  <tbody>
    <?php if ($totalRows_atenciones > 0) {
      while ($qAtenciones->fetch()) { ?>
        <tr>
          <td><?= $at_id ?></td>
          <td><?= $at_fecha ?></td>
          <td><?= number_format($at_nroRut, '0', ',', '.') . "-" . $at_dvRut ?></td>
          <td><?= $at_nombre ?></td>
          <?php
          if ($at_fechaInf != '') {
            $qInformeAtencion = $mysqli->prepare("SELECT
            CASE
              WHEN FLAG_HISTORICO = 1 THEN CONCAT('https://histarchetcheverry.ripit.cl', URL)
              ELSE 												 CONCAT('https://archetcheverry.ripit.cl', URL)
            END
            FROM archivos_atenciones 
            WHERE ID_ATENCION = ? AND TIPO = 'INFORME' ORDER BY FECHA DESC LIMIT 1");
            $qInformeAtencion->bind_param('s', $at_id);
            $qInformeAtencion->execute();
            $qInformeAtencion->bind_result($informe);
            $qInformeAtencion->store_result();
            $qInformeAtencion->fetch();
            $qInformeAtencion->close();
            if ($informe == null) $informe = '../pacientes/pdf_p_cm.php?r=' . $at_nroRut . '&i=' . $at_id;
          ?>
            <td width="120" align="center"> <a class="btn btn-link btn-sm" target="_blank" href="<?= $informe ?>"> <i class="fa fa-file-pdf-o fa-lg"></i> </a> </td>
          <?php } else { ?>
            <td width="120" align="center">En Proceso</td>
          <?php  } ?>
          <td align="center">
            <a href="javascript:void(0);" class="btn btn-default" rel="popover" data-html="true" data-placement="left" data-original-title="Estado de exámenes" data-content="<?= obtenerDetalleAtencion($at_id); ?>">
              <i class="fa fa-list"></i>
            </a>
          </td>
          <td width="120" align="center"> <a class="btn btn-link btn-sm" href="e_atencion.php?idate=<?= $at_id ?>"> <i class="fa fa-edit fa-lg"></i> </a> </td>
        </tr>
    <?php }
      $qAtenciones->close();
    } else echo "<tr><td colspan='7'>No posee atenciones de pacientes</td></tr>";
    ?>
  </tbody>
</table>

<?php if ($total_paginas > 1) echo '<div class="text-center" style="padding-top:1em;">' . paginacion('l_atenciones.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina) . '</div>'; ?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => sprintf($datos_pantallas[$pantalla_actual]['body_title'], $nombre_ccto),
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);

$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('#buscar').click(function() {
      $('#formBuscar').submit();
    });
  })
</script>

<?php
include("../inc/google-analytics.php");
?>