<?php
define('PERMITIDO', true);
$pagina = 28;
require_once("../inc/init.php");
require('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");
require_once '../assets/php/PHPExcel.php';

error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');
$objPHPExcel = new PHPExcel(); // Create new PHPExcel object
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Consolidado atenciones de convenio'); // Set document properties

$f_de = (isset($_GET['f_de']) && $_GET['f_de'] != "") ? $_GET['f_de'] : date('Y-m-d', strtotime('-1 week'));
$f_ha = (isset($_GET['f_ha']) && $_GET['f_ha'] != "") ? $_GET['f_ha'] : date('Y-m-d');

$filtro_convenio = isset($_GET['id_conv']) && $_GET['id_conv'] != "" ? " AND e.ID_EMPRESA = '{$_GET['id_conv']}'" : "";
$filtro_examen = isset($_GET['cod_ex']) && $_GET['cod_ex'] != "" ? " AND ea.COD_EXAMEN = '{$_GET['cod_ex']}'" : "";
$filtro_local = (isset($_GET['idcc']) && $_GET['idcc'] != "") ? " AND a.ID_CENTRO_CONTACTO  = {$_GET['idcc']}" : "";

$qAtencionesConvenio = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.FECHA_INF,
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), p.NRO_RUT, p.DV_RUT,
YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO) AS EDAD,
(((YEAR(a.FECHA)-YEAR(p.FECHA_NACIMIENTO))*12)+(MONTH(a.FECHA)-MONTH(p.FECHA_NACIMIENTO))) AS EDAD_MES,
prev.NBR, cc.NOMBRE, ea.COD_EXAMEN, ea.RESULTADO
FROM atenciones a
LEFT JOIN empresas conv ON a.ID_CONVENIO = conv.ID_EMPRESA
INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION $filtro_examen
LEFT JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
LEFT JOIN empresas prev ON a.ID_PREVISION = prev.ID_EMPRESA
LEFT JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
WHERE (FECHA BETWEEN ? AND ?) AND FECHA_R IS NOT NULL AND a.FLAG_ELIMINADO = 0 $filtro_convenio $filtro_local
ORDER BY ID_ATENCION DESC");
$qAtencionesConvenio->bind_param('ss', $f_de, $f_ha);
$qAtencionesConvenio->execute();
$qAtencionesConvenio->bind_result($id_atencion, $fecha_atencion, $fecha_informe, $nombre_paciente, $nroRut_paciente, $dvRut_paciente, 
$edad, $edad_mes,
$nbr_prevision, $nombre_local, $cod_examen, $resultado);
$qAtencionesConvenio->store_result();
$num_rows = $qAtencionesConvenio->num_rows;

////////////////////////   PARA QUE SE ACOMODE EL WIDTH DE LAS COLUMNAS    //////////////////////////////
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

////////////////////////     $styleArray ESTILO PARA LA CABECERA    //////////////////////////////
$styleArray = array(
  'font'  => array(
    'bold'  => true,
    'color' => array('rgb' => 'FFFFFF'),
    'size'  => 11
    //'name'  => 'Verdana'
  ),
  'fill' => array(
    'type' => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array('rgb' => '4F81BD')
  ),
  'alignment' => array(
    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
  ),
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN
    )
  )
);

$objPHPExcel->getActiveSheet()->getStyle('A1:H1')->applyFromArray($styleArray);

$aux = $num_rows + 1;
$objPHPExcel->getActiveSheet()
  ->getStyle('A2:'.'H'.$aux)
  ->getNumberFormat()
  ->setFormatCode( PHPExcel_Style_NumberFormat::FORMAT_TEXT );

////////////////////////     ESCRITURA EN CELDAS      //////////////////////////////
$objPHPExcel->setActiveSheetIndex(0)
  ->setCellValue('A1', 'N° Atención')
  ->setCellValue('B1', 'Fecha')
  ->setCellValue('C1', 'Local')
  ->setCellValue('D1', 'RUT Paciente')
  ->setCellValue('E1', 'Nombre Paciente')
  ->setCellValue('F1', 'Edad Paciente')
  ->setCellValue('G1', 'Previsión')
  ->setCellValue('H1', 'Resultado');

// PARA ALINEAR CON LOS SALTOS DE LINEA
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('B1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('C1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('E1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('F1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('G1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('H1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('I1')->getAlignment()->setWrapText(true);

$f=2;
while ($qAtencionesConvenio->fetch()) {
	$campo_edad = ($edad_mes < "12") ? $edad_mes." MESES" : $edad." AÑOS";
  if ($cod_examen == "00.00.069") {
    $resultado = preg_split('/\r\n|\r|\n/', $resultado);
    $resultado = $resultado[0];
  }
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $f, $id_atencion);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $f, $fecha_atencion);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $f, $nombre_local);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $f, number_format($nroRut_paciente, '0', ',', '.') . '-' . $dvRut_paciente);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E' . $f, $nombre_paciente);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F' . $f, $campo_edad);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G' . $f, $nbr_prevision);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H' . $f, $fecha_informe != "" ? $resultado : "PENDIENTE"); # split para etcheverry que tiene resultados son textos largos con saltos de linea (fix pls)
	$f++;
}
$qAtencionesConvenio->close();

// PHPExcel_Settings::(PHPExcel_Settings::PCLZIP);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Informe Consolidado');
// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');

// header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); # Para xlsx, no funciona en servidor

header('Content-Disposition: attachment;filename="Consolidado atenciones de '.date("d-m-Y", strtotime($f_de)).' a '.date("d-m-Y", strtotime($f_ha)).'.xls"');
header('Cache-Control: max-age=0');

// // If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->setPreCalculateFormulas(false);
$objWriter->save('php://output');
exit();
